/*
 * Decompiled with CFR 0.152.
 */
package com.hexagram2021.oceanworld.common.world.spawners;

import com.google.common.collect.Lists;
import com.hexagram2021.oceanworld.common.world.spawners.OceanWorldSpawner;
import java.util.List;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="oceanworld", bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class OWSpawners {
    private static final List<OceanWorldSpawner.Registry> REGISTERED_SPAWNERS = Lists.newArrayList();

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onServerStarted(ServerStartedEvent event) {
        REGISTERED_SPAWNERS.forEach(registry -> registry.spawner().reset());
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.LevelTickEvent event) {
        Level level;
        if (event.phase == TickEvent.Phase.END && (level = event.level) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            REGISTERED_SPAWNERS.stream().filter(registry -> registry.dimension().equals((Object)serverLevel.m_46472_())).forEach(registry -> registry.spawner().tick(serverLevel));
        }
    }

    public static void register(ResourceKey<Level> dimension, OceanWorldSpawner spawner) {
        REGISTERED_SPAWNERS.add(new OceanWorldSpawner.Registry(spawner, dimension));
    }

    private OWSpawners() {
    }
}

