/*
 * Decompiled with CFR 0.152.
 */
package com.hexagram2021.oceanworld.common.world.features;

import com.hexagram2021.oceanworld.common.world.features.configuration.OceanStoneConfiguration;
import com.mojang.serialization.Codec;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderSet;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class OceanStoneFeature
extends Feature<OceanStoneConfiguration> {
    public OceanStoneFeature(Codec<OceanStoneConfiguration> codec) {
        super(codec);
    }

    private boolean tryPlace(HolderSet<Block> replaceBlock, BlockState targetBlock, int maxDepth, int invPossibility, WorldGenLevel level, Set<BlockPos> visited, BlockPos curPosition, RandomSource random, Predicate<BlockState> predicate, int depth, boolean toPlace) {
        for (int b = 1; b <= 6; ++b) {
            int s = (b & 4) >> 2;
            int b1 = (b & 3) + s;
            int y = b1 & 1 ^ (b1 & 2) >> 1 ^ 1;
            int x = b1 & 1 ^ y;
            int z = (b1 & 2) >> 1 ^ y;
            BlockPos nextPos = curPosition.m_7918_(x *= 1 - 2 * s, y *= 1 - 2 * s, z *= 1 - 2 * s);
            BlockState blockstate = level.m_8055_(nextPos);
            if (blockstate.m_60713_(Blocks.f_49990_) || blockstate.m_60713_(Blocks.f_50016_) || blockstate.m_60713_(Blocks.f_50627_)) {
                return depth > 0;
            }
            if (depth >= maxDepth) {
                return false;
            }
            if (visited.contains(nextPos)) continue;
            visited.add(nextPos);
            if (random.m_188503_(invPossibility) == 0 || !blockstate.m_204341_(replaceBlock) && !blockstate.m_60713_(Blocks.f_50069_) && !blockstate.m_60713_(Blocks.f_50334_) && !blockstate.m_60713_(Blocks.f_50228_) && !blockstate.m_60713_(Blocks.f_50122_)) continue;
            if (this.tryPlace(replaceBlock, targetBlock, maxDepth, invPossibility, level, visited, nextPos, random, predicate, depth + 1, toPlace)) {
                toPlace = true;
            }
            if (!toPlace) continue;
            this.m_159742_(level, nextPos, targetBlock, predicate);
        }
        return toPlace;
    }

    public boolean m_142674_(FeaturePlaceContext<OceanStoneConfiguration> context) {
        Predicate predicate = Feature.m_204735_((TagKey)BlockTags.f_144287_);
        BlockPos blockpos = context.m_159777_();
        RandomSource random = context.m_225041_();
        WorldGenLevel worldgenlevel = context.m_159774_();
        OceanStoneConfiguration configuration = (OceanStoneConfiguration)context.m_159778_();
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        return this.tryPlace(configuration.replaceBlock(), configuration.targetBlock().m_49966_(), configuration.depth(), configuration.invPossibility(), worldgenlevel, visited, blockpos, random, predicate, 0, false);
    }
}

