/*
 * Decompiled with CFR 0.152.
 */
package com.hexagram2021.oceanworld.common.world;

import com.hexagram2021.oceanworld.common.register.OWBiomeKeys;
import com.mojang.datafixers.util.Pair;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Climate;

public class OceanWorldBiomeBuilder {
    private static final Climate.Parameter[] TEMPERATURES = new Climate.Parameter[]{Climate.Parameter.m_186822_((float)-1.0f, (float)-0.5f), Climate.Parameter.m_186822_((float)-0.5f, (float)0.25f), Climate.Parameter.m_186822_((float)0.25f, (float)1.0f)};
    private static final Climate.Parameter[] HUMIDITIES = new Climate.Parameter[]{Climate.Parameter.m_186822_((float)-1.0f, (float)-0.4f), Climate.Parameter.m_186822_((float)-0.4f, (float)0.3f), Climate.Parameter.m_186822_((float)0.3f, (float)1.0f)};
    private static final Climate.Parameter ALL = Climate.Parameter.m_186822_((float)-1.0f, (float)1.0f);
    private static final Climate.Parameter SURFACE = Climate.Parameter.m_186822_((float)0.0f, (float)0.35f);
    private static final Climate.Parameter UNDERGROUND = Climate.Parameter.m_186822_((float)0.35f, (float)1.0f);
    private static final Climate.Parameter OFF_COAST = Climate.Parameter.m_186822_((float)-1.2f, (float)0.875f);
    private static final Climate.Parameter ISLAND = Climate.Parameter.m_186822_((float)0.875f, (float)1.2f);
    private static final Climate.Parameter NORMAL = Climate.Parameter.m_186822_((float)-1.0f, (float)0.625f);
    private static final Climate.Parameter WEIRD = Climate.Parameter.m_186822_((float)0.625f, (float)1.0f);
    private static final Climate.Parameter NOT_POLLUTED = Climate.Parameter.m_186822_((float)-1.0f, (float)0.8125f);
    private static final Climate.Parameter POLLUTED = Climate.Parameter.m_186822_((float)0.8125f, (float)1.0f);

    public void addBiomes(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> mapper) {
        this.addBiome(mapper, OWBiomeKeys.ICY_OCEAN, TEMPERATURES[0], Climate.Parameter.m_186829_((Climate.Parameter)HUMIDITIES[0], (Climate.Parameter)HUMIDITIES[1]), OFF_COAST, NOT_POLLUTED, ALL, SURFACE);
        this.addBiome(mapper, OWBiomeKeys.GLACIER, TEMPERATURES[0], HUMIDITIES[2], OFF_COAST, NOT_POLLUTED, ALL, SURFACE);
        this.addBiome(mapper, OWBiomeKeys.DEPOSIT_OCEAN, TEMPERATURES[1], HUMIDITIES[0], OFF_COAST, NOT_POLLUTED, NORMAL, SURFACE);
        this.addBiome(mapper, OWBiomeKeys.OCEAN, TEMPERATURES[1], HUMIDITIES[1], OFF_COAST, NOT_POLLUTED, NORMAL, SURFACE);
        this.addBiome(mapper, OWBiomeKeys.SEAGRASS_MEADOW, TEMPERATURES[1], HUMIDITIES[2], OFF_COAST, NOT_POLLUTED, NORMAL, SURFACE);
        this.addBiome(mapper, OWBiomeKeys.VOLCANIC_OCEAN, TEMPERATURES[2], HUMIDITIES[0], OFF_COAST, NOT_POLLUTED, NORMAL, SURFACE);
        this.addBiome(mapper, OWBiomeKeys.CORAL_OCEAN, TEMPERATURES[2], Climate.Parameter.m_186829_((Climate.Parameter)HUMIDITIES[1], (Climate.Parameter)HUMIDITIES[2]), OFF_COAST, NOT_POLLUTED, NORMAL, SURFACE);
        this.addBiome(mapper, OWBiomeKeys.REEF_OCEAN, Climate.Parameter.m_186829_((Climate.Parameter)TEMPERATURES[0], (Climate.Parameter)TEMPERATURES[1]), ALL, OFF_COAST, NOT_POLLUTED, WEIRD, SURFACE);
        this.addBiome(mapper, OWBiomeKeys.POLLUTED_OCEAN, ALL, ALL, OFF_COAST, POLLUTED, ALL, SURFACE);
        this.addBiome(mapper, OWBiomeKeys.FROZEN_ISLAND, TEMPERATURES[0], ALL, ISLAND, ALL, NORMAL, SURFACE);
        this.addBiome(mapper, OWBiomeKeys.ISLAND, TEMPERATURES[1], ALL, ISLAND, ALL, NORMAL, SURFACE);
        this.addBiome(mapper, OWBiomeKeys.TROPICAL_ISLAND, TEMPERATURES[2], ALL, ISLAND, ALL, NORMAL, SURFACE);
        this.addBiome(mapper, OWBiomeKeys.MAGICAL_ISLAND, ALL, ALL, ISLAND, ALL, WEIRD, SURFACE);
        this.addBiome(mapper, OWBiomeKeys.UNDERGROUND, ALL, ALL, Climate.Parameter.m_186829_((Climate.Parameter)OFF_COAST, (Climate.Parameter)ISLAND), ALL, ALL, UNDERGROUND);
    }

    private void addBiome(Consumer<Pair<Climate.ParameterPoint, ResourceKey<Biome>>> mapper, OWBiomeKeys.BiomeKey biomeKey, Climate.Parameter temperature, Climate.Parameter humidity, Climate.Parameter continentalness, Climate.Parameter pollution, Climate.Parameter weirdness, Climate.Parameter depth) {
        mapper.accept((Pair<Climate.ParameterPoint, ResourceKey<Biome>>)new Pair((Object)Climate.m_186798_((Climate.Parameter)temperature, (Climate.Parameter)humidity, (Climate.Parameter)continentalness, (Climate.Parameter)pollution, (Climate.Parameter)depth, (Climate.Parameter)weirdness, (float)biomeKey.suppress()), biomeKey.key()));
    }
}

