/*
 * Decompiled with CFR 0.152.
 */
package com.hexagram2021.oceanworld.common.register;

import com.hexagram2021.oceanworld.common.blocks.FakeFrostedIceBlock;
import com.hexagram2021.oceanworld.common.register.OWItems;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SandBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class OWBlocks {
    public static final DeferredRegister<Block> REGISTER = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"oceanworld");
    public static final Map<ResourceLocation, BlockEntry<SlabBlock>> TO_SLAB = new HashMap<ResourceLocation, BlockEntry<SlabBlock>>();
    public static final Map<ResourceLocation, BlockEntry<StairBlock>> TO_STAIRS = new HashMap<ResourceLocation, BlockEntry<StairBlock>>();
    public static final Map<ResourceLocation, BlockEntry<WallBlock>> TO_WALL = new HashMap<ResourceLocation, BlockEntry<WallBlock>>();

    private OWBlocks() {
    }

    private static <T extends Block> void registerStairs(BlockEntry<T> fullBlock) {
        Object name = fullBlock.getId().m_135815_();
        name = ((String)name).endsWith("_block") ? ((String)name).replaceAll("_block", "_stairs") : (((String)name).endsWith("_bricks") ? ((String)name).replaceAll("_bricks", "_brick_stairs") : (String)name + "_stairs");
        TO_STAIRS.put(fullBlock.getId(), new BlockEntry<StairBlock>((String)name, fullBlock::getProperties, p -> new StairBlock(fullBlock::defaultBlockState, p)));
    }

    private static <T extends Block> void registerSlab(BlockEntry<T> fullBlock) {
        Object name = fullBlock.getId().m_135815_();
        name = ((String)name).endsWith("_block") ? ((String)name).replaceAll("_block", "_slab") : (((String)name).endsWith("_bricks") ? ((String)name).replaceAll("_bricks", "_brick_slab") : (String)name + "_slab");
        TO_SLAB.put(fullBlock.getId(), new BlockEntry<SlabBlock>((String)name, fullBlock::getProperties, p -> new SlabBlock(p.m_60960_((state, world, pos) -> fullBlock.defaultBlockState().m_60828_(world, pos) && state.m_61143_((Property)SlabBlock.f_56353_) == SlabType.DOUBLE).m_60924_((state, world, pos) -> fullBlock.defaultBlockState().m_60796_(world, pos) && state.m_61143_((Property)SlabBlock.f_56353_) == SlabType.DOUBLE))));
    }

    private static <T extends Block> void registerWall(BlockEntry<T> fullBlock) {
        Object name = fullBlock.getId().m_135815_();
        name = ((String)name).endsWith("_block") ? ((String)name).replaceAll("_block", "_wall") : (((String)name).endsWith("_bricks") ? ((String)name).replaceAll("_bricks", "_brick_wall") : (String)name + "_wall");
        TO_WALL.put(fullBlock.getId(), new BlockEntry<WallBlock>((String)name, fullBlock::getProperties, WallBlock::new));
    }

    public static void init(IEventBus bus) {
        REGISTER.register(bus);
        StoneDecoration.init();
        BrickDecoration.init();
        IceDecoration.init();
        for (Map.Entry<ResourceLocation, BlockEntry<SlabBlock>> entry : TO_SLAB.entrySet()) {
            OWItems.ItemEntry.register(entry.getValue().getId().m_135815_(), () -> new BlockItem(((BlockEntry)blockSlab.getValue()).get(), new Item.Properties()));
        }
        for (Map.Entry<ResourceLocation, BlockEntry<SlabBlock>> entry : TO_STAIRS.entrySet()) {
            OWItems.ItemEntry.register(entry.getValue().getId().m_135815_(), () -> new BlockItem(((BlockEntry)blockStairs.getValue()).get(), new Item.Properties()));
        }
        for (Map.Entry<ResourceLocation, BlockEntry<SlabBlock>> entry : TO_WALL.entrySet()) {
            OWItems.ItemEntry.register(entry.getValue().getId().m_135815_(), () -> new BlockItem(((BlockEntry)blockWall.getValue()).get(), new Item.Properties()));
        }
    }

    public static final class BlockEntry<T extends Block>
    implements Supplier<T>,
    ItemLike {
        private final RegistryObject<T> regObject;
        private final Supplier<BlockBehaviour.Properties> properties;

        public BlockEntry(String name, Supplier<BlockBehaviour.Properties> properties, Function<BlockBehaviour.Properties, T> make) {
            this.properties = properties;
            this.regObject = REGISTER.register(name, () -> (Block)make.apply((BlockBehaviour.Properties)properties.get()));
        }

        @Override
        public T get() {
            return (T)((Block)this.regObject.get());
        }

        public BlockState defaultBlockState() {
            return this.get().m_49966_();
        }

        public ResourceLocation getId() {
            return this.regObject.getId();
        }

        public BlockBehaviour.Properties getProperties() {
            return this.properties.get();
        }

        public Item m_5456_() {
            return this.get().m_5456_();
        }
    }

    public static final class StoneDecoration {
        public static final Supplier<BlockBehaviour.Properties> STONE_PROPERTIES = () -> BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283947_).m_280658_(NoteBlockInstrument.BASEDRUM).m_60999_().m_60913_(1.5f, 6.0f);
        public static final Supplier<BlockBehaviour.Properties> CONGLOMERATE_PROPERTIES = () -> BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283947_).m_280658_(NoteBlockInstrument.BASEDRUM).m_60999_().m_60978_(0.8f);
        public static final Supplier<BlockBehaviour.Properties> SMOOTH_CONGLOMERATE_PROPERTIES = () -> BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283947_).m_280658_(NoteBlockInstrument.BASEDRUM).m_60999_().m_60913_(2.0f, 6.0f);
        public static final Supplier<BlockBehaviour.Properties> BASALT_SAND_PROPERTIES = () -> BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283861_).m_280658_(NoteBlockInstrument.SNARE).m_60978_(0.5f).m_60918_(SoundType.f_56746_);
        public static final Supplier<BlockBehaviour.Properties> BASALT_SANDSTONE_PROPERTIES = () -> BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283861_).m_280658_(NoteBlockInstrument.BASEDRUM).m_60999_().m_60978_(0.8f);
        public static final BlockEntry<Block> PERIDOTITE = new BlockEntry<Block>("peridotite", STONE_PROPERTIES, Block::new);
        public static final BlockEntry<Block> SERPENTINE = new BlockEntry<Block>("serpentine", STONE_PROPERTIES, Block::new);
        public static final BlockEntry<Block> POLISHED_PERIDOTITE = new BlockEntry<Block>("polished_peridotite", STONE_PROPERTIES, Block::new);
        public static final BlockEntry<Block> POLISHED_SERPENTINE = new BlockEntry<Block>("polished_serpentine", STONE_PROPERTIES, Block::new);
        public static final BlockEntry<Block> CONGLOMERATE = new BlockEntry<Block>("conglomerate", CONGLOMERATE_PROPERTIES, Block::new);
        public static final BlockEntry<Block> SMOOTH_CONGLOMERATE = new BlockEntry<Block>("smooth_conglomerate", SMOOTH_CONGLOMERATE_PROPERTIES, Block::new);
        public static final BlockEntry<Block> CUT_CONGLOMERATE = new BlockEntry<Block>("cut_conglomerate", CONGLOMERATE_PROPERTIES, Block::new);
        public static final BlockEntry<Block> CHISELED_CONGLOMERATE = new BlockEntry<Block>("chiseled_conglomerate", CONGLOMERATE_PROPERTIES, Block::new);
        public static final BlockEntry<SandBlock> BASALT_SAND = new BlockEntry<SandBlock>("basalt_sand", BASALT_SAND_PROPERTIES, p -> new SandBlock(0x585656, p));
        public static final BlockEntry<Block> BASALT_SANDSTONE = new BlockEntry<Block>("basalt_sandstone", BASALT_SANDSTONE_PROPERTIES, Block::new);
        public static final BlockEntry<Block> SMOOTH_BASALT_SANDSTONE = new BlockEntry<Block>("smooth_basalt_sandstone", BASALT_SANDSTONE_PROPERTIES, Block::new);
        public static final BlockEntry<Block> CUT_BASALT_SANDSTONE = new BlockEntry<Block>("cut_basalt_sandstone", BASALT_SANDSTONE_PROPERTIES, Block::new);
        public static final BlockEntry<Block> CHISELED_BASALT_SANDSTONE = new BlockEntry<Block>("chiseled_basalt_sandstone", BASALT_SANDSTONE_PROPERTIES, Block::new);

        private static void init() {
            OWItems.ItemEntry.register(PERIDOTITE.getId().m_135815_(), () -> new BlockItem(PERIDOTITE.get(), new Item.Properties()));
            OWItems.ItemEntry.register(SERPENTINE.getId().m_135815_(), () -> new BlockItem(SERPENTINE.get(), new Item.Properties()));
            OWItems.ItemEntry.register(POLISHED_PERIDOTITE.getId().m_135815_(), () -> new BlockItem(POLISHED_PERIDOTITE.get(), new Item.Properties()));
            OWItems.ItemEntry.register(POLISHED_SERPENTINE.getId().m_135815_(), () -> new BlockItem(POLISHED_SERPENTINE.get(), new Item.Properties()));
            OWItems.ItemEntry.register(CONGLOMERATE.getId().m_135815_(), () -> new BlockItem(CONGLOMERATE.get(), new Item.Properties()));
            OWItems.ItemEntry.register(SMOOTH_CONGLOMERATE.getId().m_135815_(), () -> new BlockItem(SMOOTH_CONGLOMERATE.get(), new Item.Properties()));
            OWItems.ItemEntry.register(CUT_CONGLOMERATE.getId().m_135815_(), () -> new BlockItem(CUT_CONGLOMERATE.get(), new Item.Properties()));
            OWItems.ItemEntry.register(CHISELED_CONGLOMERATE.getId().m_135815_(), () -> new BlockItem(CHISELED_CONGLOMERATE.get(), new Item.Properties()));
            OWItems.ItemEntry.register(BASALT_SAND.getId().m_135815_(), () -> new BlockItem((Block)BASALT_SAND.get(), new Item.Properties()));
            OWItems.ItemEntry.register(BASALT_SANDSTONE.getId().m_135815_(), () -> new BlockItem(BASALT_SANDSTONE.get(), new Item.Properties()));
            OWItems.ItemEntry.register(SMOOTH_BASALT_SANDSTONE.getId().m_135815_(), () -> new BlockItem(SMOOTH_BASALT_SANDSTONE.get(), new Item.Properties()));
            OWItems.ItemEntry.register(CUT_BASALT_SANDSTONE.getId().m_135815_(), () -> new BlockItem(CUT_BASALT_SANDSTONE.get(), new Item.Properties()));
            OWItems.ItemEntry.register(CHISELED_BASALT_SANDSTONE.getId().m_135815_(), () -> new BlockItem(CHISELED_BASALT_SANDSTONE.get(), new Item.Properties()));
            OWBlocks.registerStairs(PERIDOTITE);
            OWBlocks.registerStairs(SERPENTINE);
            OWBlocks.registerStairs(POLISHED_PERIDOTITE);
            OWBlocks.registerStairs(POLISHED_SERPENTINE);
            OWBlocks.registerSlab(PERIDOTITE);
            OWBlocks.registerSlab(SERPENTINE);
            OWBlocks.registerSlab(POLISHED_PERIDOTITE);
            OWBlocks.registerSlab(POLISHED_SERPENTINE);
            OWBlocks.registerWall(PERIDOTITE);
            OWBlocks.registerWall(SERPENTINE);
            OWBlocks.registerStairs(CONGLOMERATE);
            OWBlocks.registerStairs(SMOOTH_CONGLOMERATE);
            OWBlocks.registerSlab(CONGLOMERATE);
            OWBlocks.registerSlab(SMOOTH_CONGLOMERATE);
            OWBlocks.registerSlab(CUT_CONGLOMERATE);
            OWBlocks.registerWall(CONGLOMERATE);
            OWBlocks.registerStairs(BASALT_SANDSTONE);
            OWBlocks.registerSlab(BASALT_SANDSTONE);
            OWBlocks.registerWall(BASALT_SANDSTONE);
            OWBlocks.registerSlab(CUT_BASALT_SANDSTONE);
            OWBlocks.registerStairs(SMOOTH_BASALT_SANDSTONE);
            OWBlocks.registerSlab(SMOOTH_BASALT_SANDSTONE);
        }
    }

    public static final class BrickDecoration {
        public static final Supplier<BlockBehaviour.Properties> CLAY_PROPERTIES = () -> BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283913_).m_280658_(NoteBlockInstrument.FLUTE).m_60978_(0.6f).m_60918_(SoundType.f_56739_);
        public static final Supplier<BlockBehaviour.Properties> BLACK_BRICK_PROPERTIES = () -> BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283846_).m_280658_(NoteBlockInstrument.BASEDRUM).m_60999_().m_60913_(2.0f, 6.0f);
        public static final Supplier<BlockBehaviour.Properties> GOLDEN_BRICK_PROPERTIES = () -> BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283757_).m_280658_(NoteBlockInstrument.BASEDRUM).m_60999_().m_60913_(2.0f, 6.0f);
        public static final BlockEntry<Block> RED_CLAY = new BlockEntry<Block>("red_clay", CLAY_PROPERTIES, Block::new);
        public static final BlockEntry<Block> BLACK_BRICKS = new BlockEntry<Block>("black_bricks", BLACK_BRICK_PROPERTIES, Block::new);
        public static final BlockEntry<Block> GOLDEN_BRICKS = new BlockEntry<Block>("golden_bricks", GOLDEN_BRICK_PROPERTIES, Block::new);

        private static void init() {
            OWItems.ItemEntry.register(RED_CLAY.getId().m_135815_(), () -> new BlockItem(RED_CLAY.get(), new Item.Properties()));
            OWItems.ItemEntry.register(BLACK_BRICKS.getId().m_135815_(), () -> new BlockItem(BLACK_BRICKS.get(), new Item.Properties()));
            OWItems.ItemEntry.register(GOLDEN_BRICKS.getId().m_135815_(), () -> new BlockItem(GOLDEN_BRICKS.get(), new Item.Properties()));
            OWBlocks.registerStairs(BLACK_BRICKS);
            OWBlocks.registerSlab(BLACK_BRICKS);
            OWBlocks.registerWall(BLACK_BRICKS);
            OWBlocks.registerStairs(GOLDEN_BRICKS);
            OWBlocks.registerSlab(GOLDEN_BRICKS);
            OWBlocks.registerWall(GOLDEN_BRICKS);
        }
    }

    public static final class IceDecoration {
        public static final Supplier<BlockBehaviour.Properties> FAKE_FROSTED_ICE_PROPERTIES = () -> BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283828_).m_60911_(0.98f).m_60977_().m_60978_(0.5f).m_60918_(SoundType.f_56744_).m_60955_();
        public static final BlockEntry<FakeFrostedIceBlock> FAKE_FROSTED_ICE = new BlockEntry<FakeFrostedIceBlock>("fake_frosted_ice", FAKE_FROSTED_ICE_PROPERTIES, FakeFrostedIceBlock::new);

        private static void init() {
        }
    }
}

