/*
 * Decompiled with CFR 0.152.
 */
package com.hexagram2021.oceanworld.common.register;

import com.google.common.collect.Maps;
import com.hexagram2021.oceanworld.common.config.OWCommonConfig;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.registries.ForgeRegistries;

public class OWBiomeKeys {
    public static final BiomeKey CORAL_OCEAN = new BiomeKey("coral_ocean", (Supplier<Boolean>)OWCommonConfig.GENERATE_CORAL_OCEAN, ((Double)OWCommonConfig.SUPPRESS_CORAL_OCEAN.get())::floatValue);
    public static final BiomeKey DEPOSIT_OCEAN = new BiomeKey("deposit_ocean", (Supplier<Boolean>)OWCommonConfig.GENERATE_DEPOSIT_OCEAN, ((Double)OWCommonConfig.SUPPRESS_DEPOSIT_OCEAN.get())::floatValue);
    public static final BiomeKey GLACIER = new BiomeKey("glacier", (Supplier<Boolean>)OWCommonConfig.GENERATE_GLACIER, ((Double)OWCommonConfig.SUPPRESS_GLACIER.get())::floatValue);
    public static final BiomeKey ICY_OCEAN = new BiomeKey("icy_ocean", (Supplier<Boolean>)OWCommonConfig.GENERATE_ICY_OCEAN, ((Double)OWCommonConfig.SUPPRESS_ICY_OCEAN.get())::floatValue);
    public static final BiomeKey OCEAN = new BiomeKey("ocean", true, -0.15f);
    public static final BiomeKey POLLUTED_OCEAN = new BiomeKey("polluted_ocean", (Supplier<Boolean>)OWCommonConfig.GENERATE_POLLUTED_OCEAN, ((Double)OWCommonConfig.SUPPRESS_POLLUTED_OCEAN.get())::floatValue);
    public static final BiomeKey REEF_OCEAN = new BiomeKey("reef_ocean", (Supplier<Boolean>)OWCommonConfig.GENERATE_REEF_OCEAN, ((Double)OWCommonConfig.SUPPRESS_REEF_OCEAN.get())::floatValue);
    public static final BiomeKey SEAGRASS_MEADOW = new BiomeKey("seagrass_meadow", (Supplier<Boolean>)OWCommonConfig.GENERATE_SEAGRASS_MEADOW, ((Double)OWCommonConfig.SUPPRESS_SEAGRASS_MEADOW.get())::floatValue);
    public static final BiomeKey UNDERGROUND = new BiomeKey("underground", true, 0.0f);
    public static final BiomeKey VOLCANIC_OCEAN = new BiomeKey("volcanic_ocean", (Supplier<Boolean>)OWCommonConfig.GENERATE_VOLCANIC_OCEAN, ((Double)OWCommonConfig.SUPPRESS_VOLCANIC_OCEAN.get())::floatValue);
    public static final BiomeKey FROZEN_ISLAND = new BiomeKey("frozen_island", (Supplier<Boolean>)OWCommonConfig.GENERATE_FROZEN_ISLAND, ((Double)OWCommonConfig.SUPPRESS_FROZEN_ISLAND.get())::floatValue);
    public static final BiomeKey ISLAND = new BiomeKey("island", (Supplier<Boolean>)OWCommonConfig.GENERATE_ISLAND, ((Double)OWCommonConfig.SUPPRESS_ISLAND.get())::floatValue);
    public static final BiomeKey TROPICAL_ISLAND = new BiomeKey("tropical_island", (Supplier<Boolean>)OWCommonConfig.GENERATE_TROPICAL_ISLAND, ((Double)OWCommonConfig.SUPPRESS_TROPICAL_ISLAND.get())::floatValue);
    public static final BiomeKey MAGICAL_ISLAND = new BiomeKey("magical_island", (Supplier<Boolean>)OWCommonConfig.GENERATE_MAGICAL_ISLAND, ((Double)OWCommonConfig.SUPPRESS_MAGICAL_ISLAND.get())::floatValue);

    @Nullable
    public static BiomeKey getBiomeKey(ResourceKey<Biome> key) {
        return BiomeKey.ALL_BIOME_KEYS.get(key);
    }

    public static float getSuppress(ResourceKey<Biome> key) {
        return OWBiomeKeys.getSuppress(key, 0.0f);
    }

    public static float getSuppress(ResourceKey<Biome> key, float defaultValue) {
        BiomeKey biomeKey = OWBiomeKeys.getBiomeKey(key);
        return biomeKey == null ? defaultValue : biomeKey.suppress();
    }

    public record BiomeKey(ResourceKey<Biome> key, boolean generate, float suppress) {
        static final Map<ResourceKey<Biome>, BiomeKey> ALL_BIOME_KEYS = Maps.newHashMap();

        public BiomeKey(ResourceKey<Biome> key, boolean generate, float suppress) {
            this.key = key;
            this.generate = generate;
            this.suppress = suppress;
            ALL_BIOME_KEYS.put(key, this);
        }

        public BiomeKey(String name, Supplier<Boolean> generate, Supplier<Float> suppress) {
            this(name, (boolean)generate.get(), suppress.get().floatValue());
        }

        public BiomeKey(String name, boolean generate, float suppress) {
            this((ResourceKey<Biome>)ResourceKey.m_135785_((ResourceKey)ForgeRegistries.Keys.BIOMES, (ResourceLocation)new ResourceLocation("oceanworld", name)), generate, suppress);
        }
    }
}

