/*
 * Decompiled with CFR 0.152.
 */
package com.hexagram2021.oceanworld.common.entities;

import com.hexagram2021.oceanworld.common.OWSounds;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.Nullable;

public abstract class OysterEntity
extends Animal
implements Bucketable {
    private static final UUID OYSTER_ARMOR_MODIFIER_UUID = UUID.fromString("C7A94ED1-297A-3AF1-8F77-8117271B1768");
    private static final AttributeModifier OYSTER_ARMOR_MODIFIER = new AttributeModifier(OYSTER_ARMOR_MODIFIER_UUID, "Oyster armor bonus", 4.0, AttributeModifier.Operation.ADDITION);
    private static final EntityDataAccessor<Boolean> FROM_BUCKET = SynchedEntityData.m_135353_(OysterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_OPEN = SynchedEntityData.m_135353_(OysterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    int openShellRemainTicks = 20;
    int closeShellRemainTicks = 0;
    int productPearlRemainTicks = 56000;
    boolean availableToProducePearl = false;

    protected OysterEntity(EntityType<? extends Animal> type, Level level) {
        super(type, level);
    }

    public float m_5610_(BlockPos blockPos, LevelReader level) {
        return 0.0f;
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.m_9236_().f_46443_) {
            return;
        }
        if (this.m_6084_() && this.openShellRemainTicks == 1) {
            for (Mob mob : this.m_9236_().m_45976_(Mob.class, this.m_20191_().m_82400_(0.3))) {
                if (!mob.m_6084_() || mob == this) continue;
                this.touch(mob);
            }
        }
        if (this.openShellRemainTicks > 0) {
            --this.openShellRemainTicks;
            if (this.openShellRemainTicks <= 0) {
                this.setOpen(false);
                this.closeShellRemainTicks = 1200 + this.f_19796_.m_188503_(120);
            } else if (!this.isOpen()) {
                this.setOpen(true);
            }
        } else {
            --this.closeShellRemainTicks;
            if (this.closeShellRemainTicks <= 0) {
                this.setOpen(true);
                this.openShellRemainTicks = 80 + this.f_19796_.m_188503_(20);
                if (this.availableToProducePearl) {
                    this.availableToProducePearl = false;
                    this.productPearlRemainTicks = 50000 + this.f_19796_.m_188503_(6000);
                    this.m_19998_((ItemLike)this.dropPearlItem());
                }
            } else if (this.isOpen()) {
                this.setOpen(false);
            }
        }
        if (!this.availableToProducePearl) {
            --this.productPearlRemainTicks;
            if (this.productPearlRemainTicks <= 0) {
                if (this.isOpen()) {
                    this.productPearlRemainTicks = 50000 + this.f_19796_.m_188503_(6000);
                    this.m_19998_((ItemLike)this.dropPearlItem());
                } else {
                    this.availableToProducePearl = true;
                }
            }
        }
    }

    private void touch(Mob mob) {
        if (mob.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), 2.0f)) {
            this.m_216990_(OWSounds.OYSTER_ATTACK);
        }
    }

    public void m_6123_(Player player) {
        if (this.m_6084_() && this.openShellRemainTicks == 1 && player instanceof ServerPlayer && player.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), 2.0f)) {
            this.m_216990_(OWSounds.OYSTER_ATTACK);
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(FROM_BUCKET, (Object)false);
        this.f_19804_.m_135372_(IS_OPEN, (Object)true);
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128379_("FromBucket", this.m_27487_());
        nbt.m_128405_("OpenRemainTick", this.openShellRemainTicks);
        nbt.m_128405_("CloseRemainTick", this.closeShellRemainTicks);
        nbt.m_128405_("ProductRemainTick", this.productPearlRemainTicks);
        nbt.m_128379_("AvailableToProducePearl", this.availableToProducePearl);
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.m_27497_(nbt.m_128471_("FromBucket"));
        this.openShellRemainTicks = nbt.m_128451_("OpenRemainTick");
        this.closeShellRemainTicks = nbt.m_128451_("CloseRemainTick");
        this.productPearlRemainTicks = nbt.m_128451_("ProductRemainTick");
        this.availableToProducePearl = nbt.m_128471_("AvailableToProducePearl");
    }

    public boolean m_6040_() {
        return true;
    }

    public boolean m_6063_() {
        return false;
    }

    public boolean m_6914_(LevelReader level) {
        return level.m_45784_((Entity)this);
    }

    public MobType m_6336_() {
        return MobType.f_21644_;
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel level, AgeableMob mob) {
        return null;
    }

    public boolean m_27487_() {
        return (Boolean)this.f_19804_.m_135370_(FROM_BUCKET);
    }

    public void m_27497_(boolean fromBucket) {
        this.f_19804_.m_135381_(FROM_BUCKET, (Object)fromBucket);
    }

    public boolean isOpen() {
        return (Boolean)this.f_19804_.m_135370_(IS_OPEN);
    }

    private void setOpen(boolean open) {
        this.f_19804_.m_135381_(IS_OPEN, (Object)open);
        AttributeInstance attributeInstance = Objects.requireNonNull(this.m_21051_(Attributes.f_22284_));
        if (open) {
            if (attributeInstance.m_22109_(OYSTER_ARMOR_MODIFIER)) {
                attributeInstance.m_22130_(OYSTER_ARMOR_MODIFIER);
            }
        } else if (!attributeInstance.m_22109_(OYSTER_ARMOR_MODIFIER)) {
            attributeInstance.m_22125_(OYSTER_ARMOR_MODIFIER);
        }
    }

    public boolean m_8023_() {
        return super.m_8023_() || this.m_27487_();
    }

    public boolean m_142066_() {
        return this.isOpen() && super.m_142066_();
    }

    public int m_6062_() {
        return 6000;
    }

    public void m_6075_() {
        int i = this.m_20146_();
        super.m_6075_();
        if (!this.m_21525_()) {
            this.handleAirSupply(i);
        }
    }

    public boolean m_6469_(DamageSource damageSource, float value) {
        this.availableToProducePearl = false;
        this.productPearlRemainTicks += 100 + this.f_19796_.m_188503_(100);
        if (this.isOpen()) {
            this.openShellRemainTicks = 4;
        }
        return super.m_6469_(damageSource, value);
    }

    protected void handleAirSupply(int airSupply) {
        if (this.m_6084_() && !this.m_20071_()) {
            this.m_20301_(airSupply - 1);
            if (this.m_20146_() == -40) {
                this.m_20301_(0);
                this.m_6469_(this.m_269291_().m_269483_(), 1.0f);
            }
        } else {
            this.m_20301_(this.m_6062_());
        }
    }

    public void m_6872_(ItemStack itemStack) {
        Bucketable.m_148822_((Mob)this, (ItemStack)itemStack);
        CompoundTag nbt = itemStack.m_41784_();
        nbt.m_128405_("OpenRemainTick", this.openShellRemainTicks);
        nbt.m_128405_("CloseRemainTick", this.closeShellRemainTicks);
        nbt.m_128405_("ProductRemainTick", this.productPearlRemainTicks);
        nbt.m_128379_("AvailableToProducePearl", this.availableToProducePearl);
    }

    public void m_142278_(CompoundTag nbt) {
        Bucketable.m_148825_((Mob)this, (CompoundTag)nbt);
        if (nbt.m_128425_("FromBucket", 1)) {
            this.m_27497_(nbt.m_128471_("FromBucket"));
        }
        if (nbt.m_128425_("OpenRemainTick", 3)) {
            this.openShellRemainTicks = nbt.m_128451_("OpenRemainTick");
        }
        if (nbt.m_128425_("CloseRemainTick", 3)) {
            this.closeShellRemainTicks = nbt.m_128451_("CloseRemainTick");
        }
        if (nbt.m_128425_("ProductRemainTick", 3)) {
            this.productPearlRemainTicks = nbt.m_128451_("ProductRemainTick");
        }
        this.availableToProducePearl = nbt.m_128471_("AvailableToProducePearl");
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return OWSounds.OYSTER_AMBIENT;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return OWSounds.OYSTER_HURT;
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return OWSounds.OYSTER_DEATH;
    }

    public SoundEvent m_142623_() {
        return OWSounds.BUCKET_FILL_OYSTER;
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        return Bucketable.m_148828_((Player)player, (InteractionHand)hand, (LivingEntity)this).orElse(super.m_6071_(player, hand));
    }

    protected void m_7472_(DamageSource damageSource, int looting, boolean recentlyHitIn) {
        super.m_7472_(damageSource, looting, recentlyHitIn);
        int count = this.f_19796_.m_188503_(looting + 1) + (this.availableToProducePearl ? 1 : 0);
        if (count > 0) {
            this.m_19983_(new ItemStack((ItemLike)this.dropPearlItem(), count));
        }
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficultyInstance, MobSpawnType mobSpawnType, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag nbt) {
        this.setOpen(false);
        this.closeShellRemainTicks = 1200 + this.f_19796_.m_188503_(120);
        this.productPearlRemainTicks = 50000 + this.f_19796_.m_188503_(6000);
        return super.m_6518_(level, difficultyInstance, mobSpawnType, spawnGroupData, nbt);
    }

    protected abstract Item dropPearlItem();

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 8.0).m_22268_(Attributes.f_22278_, 0.5).m_22268_(Attributes.f_22284_, 1.0).m_22268_(Attributes.f_22279_, 0.0).m_22268_(Attributes.f_22281_, 2.0);
    }

    public static boolean checkOysterSpawnRules(EntityType<? extends OysterEntity> entityType, ServerLevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        int brightness = level.m_45524_(pos, 0);
        return brightness < 8 && (spawnType.equals((Object)MobSpawnType.SPAWNER) || pos.m_123342_() <= level.m_5736_() - 8 && pos.m_123342_() >= 8 && level.m_8055_(pos.m_7494_()).m_60713_(Blocks.f_49990_));
    }
}

