/*
 * Decompiled with CFR 0.152.
 */
package com.hexagram2021.oceanworld.common.entities;

import com.google.common.collect.Lists;
import com.hexagram2021.oceanworld.common.OWSounds;
import com.hexagram2021.oceanworld.common.entities.DripIceEntity;
import com.hexagram2021.oceanworld.common.entities.goals.RideBoatGoal;
import com.hexagram2021.oceanworld.common.register.OWBlocks;
import com.hexagram2021.oceanworld.common.register.OWEntities;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.SpellcasterIllager;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.EntityGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.ForgeEventFactory;

public class OceanologerEntity
extends SpellcasterIllager {
    @Nullable
    private Sheep wololoTarget;

    public OceanologerEntity(EntityType<? extends OceanologerEntity> entityType, Level level) {
        super(entityType, level);
        this.f_21364_ = 12;
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(0, (Goal)new RideBoatGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(1, (Goal)new CastingSpellGoal());
        this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 6.0f, 0.6, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new AttackSpellGoal());
        this.f_21345_.m_25352_(5, (Goal)new TrapSpellGoal());
        this.f_21345_.m_25352_(6, (Goal)new WololoSpellGoal());
        this.f_21345_.m_25352_(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true).m_26146_(300));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false).m_26146_(300));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, false));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, 0.5).m_22268_(Attributes.f_22277_, 12.0).m_22268_(Attributes.f_22276_, 24.0);
    }

    public SoundEvent m_7930_() {
        return OWSounds.OCEANOLOGER_CELEBRATE;
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
    }

    public boolean m_7307_(Entity entity) {
        if (super.m_7307_(entity)) {
            return true;
        }
        if (entity instanceof LivingEntity && ((LivingEntity)entity).m_6336_() == MobType.f_21643_) {
            return this.m_5647_() == null && entity.m_5647_() == null;
        }
        return false;
    }

    protected SoundEvent m_7515_() {
        return OWSounds.OCEANOLOGER_AMBIENT;
    }

    protected SoundEvent m_5592_() {
        return OWSounds.OCEANOLOGER_DEATH;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return OWSounds.OCEANOLOGER_HURT;
    }

    void setWololoTarget(@Nullable Sheep sheep) {
        this.wololoTarget = sheep;
    }

    public boolean m_6040_() {
        return true;
    }

    @Nullable
    Sheep getWololoTarget() {
        return this.wololoTarget;
    }

    protected SoundEvent m_7894_() {
        return OWSounds.OCEANOLOGER_CAST_SPELL;
    }

    public void m_7895_(int group, boolean raidSpawn) {
    }

    public void m_33068_() {
        super.m_33068_();
        this.m_33070_(this.m_20183_().m_7918_(-64 + this.f_19796_.m_188503_(128), 0, -64 + this.f_19796_.m_188503_(128)));
    }

    class CastingSpellGoal
    extends SpellcasterIllager.SpellcasterCastingSpellGoal {
        CastingSpellGoal() {
            super((SpellcasterIllager)OceanologerEntity.this);
        }

        public void m_8037_() {
            if (OceanologerEntity.this.m_5448_() != null) {
                OceanologerEntity.this.m_21563_().m_24960_((Entity)OceanologerEntity.this.m_5448_(), (float)OceanologerEntity.this.m_8085_(), (float)OceanologerEntity.this.m_8132_());
            } else if (OceanologerEntity.this.getWololoTarget() != null) {
                OceanologerEntity.this.m_21563_().m_24960_((Entity)OceanologerEntity.this.getWololoTarget(), (float)OceanologerEntity.this.m_8085_(), (float)OceanologerEntity.this.m_8132_());
            }
        }
    }

    class AttackSpellGoal
    extends SpellcasterIllager.SpellcasterUseSpellGoal {
        AttackSpellGoal() {
            super((SpellcasterIllager)OceanologerEntity.this);
        }

        protected int m_8089_() {
            return 40;
        }

        protected int m_8067_() {
            return 100;
        }

        public boolean m_8036_() {
            LivingEntity target = OceanologerEntity.this.m_5448_();
            return super.m_8036_() && target != null && (double)target.m_20270_((Entity)OceanologerEntity.this) < 20.0;
        }

        public boolean m_8045_() {
            LivingEntity target = OceanologerEntity.this.m_5448_();
            return super.m_8045_() && target != null && (double)target.m_20270_((Entity)OceanologerEntity.this) < 20.0;
        }

        protected void m_8130_() {
            ServerLevel serverlevel = (ServerLevel)OceanologerEntity.this.m_9236_();
            float forceRotateAngle = (float)(OceanologerEntity.this.f_19796_.m_188503_(2) * 2 - 1) * 10.0f;
            for (int i = 0; i < 8; ++i) {
                BlockPos blockpos = OceanologerEntity.this.m_20183_().m_7918_(-2 + OceanologerEntity.this.f_19796_.m_188503_(5), 2, -2 + OceanologerEntity.this.f_19796_.m_188503_(5));
                DripIceEntity dripIce = (DripIceEntity)OWEntities.DRIP_ICE.m_20615_(OceanologerEntity.this.m_9236_());
                if (dripIce == null) continue;
                dripIce.m_20035_(blockpos, 0.0f, 0.0f);
                dripIce.m_6686_(0.0, 1.0, 0.0, 0.8f, 20.0f);
                dripIce.m_5602_((Entity)OceanologerEntity.this);
                dripIce.setForceRotateAngle(forceRotateAngle);
                serverlevel.m_47205_((Entity)dripIce);
            }
        }

        protected SoundEvent m_7030_() {
            return OWSounds.OCEANOLOGER_PREPARE_ATTACK;
        }

        protected SpellcasterIllager.IllagerSpell m_7269_() {
            return SpellcasterIllager.IllagerSpell.SUMMON_VEX;
        }
    }

    class TrapSpellGoal
    extends SpellcasterIllager.SpellcasterUseSpellGoal {
        TrapSpellGoal() {
            super((SpellcasterIllager)OceanologerEntity.this);
        }

        protected int m_8089_() {
            return 100;
        }

        protected int m_8067_() {
            return 1000;
        }

        public boolean m_8036_() {
            LivingEntity target = OceanologerEntity.this.m_5448_();
            if (!super.m_8036_() || OceanologerEntity.this.m_20159_() || target == null || (double)target.m_20270_((Entity)OceanologerEntity.this) >= 16.0) {
                return false;
            }
            return ForgeEventFactory.getMobGriefingEvent((Level)OceanologerEntity.this.m_9236_(), (Entity)OceanologerEntity.this);
        }

        public boolean m_8045_() {
            LivingEntity target = OceanologerEntity.this.m_5448_();
            return super.m_8045_() && target != null && (double)target.m_20270_((Entity)OceanologerEntity.this) < 16.0;
        }

        private void spellSetBlock(BlockPos blockPos, BlockState blockState, boolean forced) {
            BlockState defaultBlockState = OceanologerEntity.this.m_9236_().m_8055_(blockPos);
            if (forced) {
                if (!defaultBlockState.m_204336_(BlockTags.f_144287_)) {
                    OceanologerEntity.this.m_9236_().m_7731_(blockPos, blockState, 3);
                }
            } else if (defaultBlockState.m_60713_(Blocks.f_50016_) || defaultBlockState.m_60713_(Blocks.f_50083_) || defaultBlockState.m_204336_(BlockTags.f_13035_) || defaultBlockState.m_60713_(Blocks.f_49990_) || defaultBlockState.m_60713_(Blocks.f_49991_) || defaultBlockState.m_60713_(Blocks.f_50126_)) {
                OceanologerEntity.this.m_9236_().m_7731_(blockPos, blockState, 3);
            }
        }

        protected void m_8130_() {
            LivingEntity livingentity = OceanologerEntity.this.m_5448_();
            assert (livingentity != null);
            BlockPos blockPos = livingentity.m_20183_();
            livingentity.m_6021_((double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_(), (double)blockPos.m_123343_() + 0.5);
            BlockPos magmaBlockPos = blockPos.m_7495_();
            BlockPos aboveBlockPos = blockPos.m_7494_();
            this.spellSetBlock(magmaBlockPos, OWBlocks.IceDecoration.FAKE_FROSTED_ICE.defaultBlockState(), true);
            this.spellSetBlock(magmaBlockPos.m_122012_(), OWBlocks.IceDecoration.FAKE_FROSTED_ICE.defaultBlockState(), false);
            this.spellSetBlock(magmaBlockPos.m_122019_(), OWBlocks.IceDecoration.FAKE_FROSTED_ICE.defaultBlockState(), false);
            this.spellSetBlock(magmaBlockPos.m_122029_(), OWBlocks.IceDecoration.FAKE_FROSTED_ICE.defaultBlockState(), false);
            this.spellSetBlock(magmaBlockPos.m_122024_(), OWBlocks.IceDecoration.FAKE_FROSTED_ICE.defaultBlockState(), false);
            this.spellSetBlock(blockPos, Blocks.f_50628_.m_49966_(), true);
            this.spellSetBlock(blockPos.m_122012_(), OWBlocks.IceDecoration.FAKE_FROSTED_ICE.defaultBlockState(), false);
            this.spellSetBlock(blockPos.m_122019_(), OWBlocks.IceDecoration.FAKE_FROSTED_ICE.defaultBlockState(), false);
            this.spellSetBlock(blockPos.m_122029_(), OWBlocks.IceDecoration.FAKE_FROSTED_ICE.defaultBlockState(), false);
            this.spellSetBlock(blockPos.m_122024_(), OWBlocks.IceDecoration.FAKE_FROSTED_ICE.defaultBlockState(), false);
            this.spellSetBlock(aboveBlockPos, Blocks.f_50628_.m_49966_(), true);
            this.spellSetBlock(aboveBlockPos.m_122012_(), OWBlocks.IceDecoration.FAKE_FROSTED_ICE.defaultBlockState(), false);
            this.spellSetBlock(aboveBlockPos.m_122019_(), OWBlocks.IceDecoration.FAKE_FROSTED_ICE.defaultBlockState(), false);
            this.spellSetBlock(aboveBlockPos.m_122029_(), OWBlocks.IceDecoration.FAKE_FROSTED_ICE.defaultBlockState(), false);
            this.spellSetBlock(aboveBlockPos.m_122024_(), OWBlocks.IceDecoration.FAKE_FROSTED_ICE.defaultBlockState(), false);
            this.spellSetBlock(aboveBlockPos.m_7494_(), OWBlocks.IceDecoration.FAKE_FROSTED_ICE.defaultBlockState(), true);
            List<Boat> list = this.getNearbyBoats((EntityGetter)OceanologerEntity.this.m_9236_(), (LivingEntity)OceanologerEntity.this, OceanologerEntity.this.m_20191_().m_82377_(16.0, 4.0, 16.0));
            if (!list.isEmpty()) {
                for (Boat boat : list) {
                    boat.m_146870_();
                }
            }
        }

        private List<Boat> getNearbyBoats(EntityGetter level, LivingEntity entity, AABB aabb) {
            List list = level.m_6443_(Boat.class, aabb, target -> !(target.m_146895_() instanceof OceanologerEntity));
            ArrayList list1 = Lists.newArrayList();
            for (Boat boat : list) {
                if (!entity.m_19950_((Entity)boat, 16.0)) continue;
                list1.add(boat);
            }
            return list1;
        }

        protected SoundEvent m_7030_() {
            return OWSounds.OCEANOLOGER_PREPARE_SUMMON;
        }

        protected SpellcasterIllager.IllagerSpell m_7269_() {
            return SpellcasterIllager.IllagerSpell.FANGS;
        }
    }

    public class WololoSpellGoal
    extends SpellcasterIllager.SpellcasterUseSpellGoal {
        private final TargetingConditions wololoTargeting;

        public WololoSpellGoal() {
            super((SpellcasterIllager)OceanologerEntity.this);
            this.wololoTargeting = TargetingConditions.m_148353_().m_26883_(16.0).m_26888_(entity -> ((Sheep)entity).m_29874_() == DyeColor.RED);
        }

        public boolean m_8036_() {
            if (OceanologerEntity.this.m_5448_() != null) {
                return false;
            }
            if (OceanologerEntity.this.m_33736_()) {
                return false;
            }
            if (OceanologerEntity.this.f_19797_ < this.f_33775_) {
                return false;
            }
            if (!ForgeEventFactory.getMobGriefingEvent((Level)OceanologerEntity.this.m_9236_(), (Entity)OceanologerEntity.this)) {
                return false;
            }
            List list = OceanologerEntity.this.m_9236_().m_45971_(Sheep.class, this.wololoTargeting, (LivingEntity)OceanologerEntity.this, OceanologerEntity.this.m_20191_().m_82377_(16.0, 4.0, 16.0));
            if (list.isEmpty()) {
                return false;
            }
            OceanologerEntity.this.setWololoTarget((Sheep)list.get(OceanologerEntity.this.f_19796_.m_188503_(list.size())));
            return true;
        }

        public boolean m_8045_() {
            return OceanologerEntity.this.getWololoTarget() != null && this.f_33774_ > 0;
        }

        public void m_8041_() {
            super.m_8041_();
            OceanologerEntity.this.setWololoTarget(null);
        }

        protected void m_8130_() {
            Sheep sheep = OceanologerEntity.this.getWololoTarget();
            if (sheep != null && sheep.m_6084_()) {
                sheep.m_29855_(DyeColor.BLUE);
            }
        }

        protected int m_8069_() {
            return 40;
        }

        protected int m_8089_() {
            return 60;
        }

        protected int m_8067_() {
            return 140;
        }

        protected SoundEvent m_7030_() {
            return OWSounds.OCEANOLOGER_PREPARE_WOLOLO;
        }

        protected SpellcasterIllager.IllagerSpell m_7269_() {
            return SpellcasterIllager.IllagerSpell.WOLOLO;
        }
    }
}

