/*
 * Decompiled with CFR 0.152.
 */
package com.hexagram2021.oceanworld.common;

import com.hexagram2021.oceanworld.common.ModsLoadedHelper;
import com.hexagram2021.oceanworld.common.OWSounds;
import com.hexagram2021.oceanworld.common.entities.OceanologerEntity;
import com.hexagram2021.oceanworld.common.entities.OysterEntity;
import com.hexagram2021.oceanworld.common.entities.SeaCucumberEntity;
import com.hexagram2021.oceanworld.common.register.OWBiomeTags;
import com.hexagram2021.oceanworld.common.register.OWBlockTags;
import com.hexagram2021.oceanworld.common.register.OWBlocks;
import com.hexagram2021.oceanworld.common.register.OWConfiguredFeatureKeys;
import com.hexagram2021.oceanworld.common.register.OWCreativeModeTabs;
import com.hexagram2021.oceanworld.common.register.OWEntities;
import com.hexagram2021.oceanworld.common.register.OWFeatures;
import com.hexagram2021.oceanworld.common.register.OWItems;
import com.hexagram2021.oceanworld.common.register.OWMultiNoiseBiomeSourceParameterListPresets;
import com.hexagram2021.oceanworld.common.register.OWPlacedFeatureKeys;
import com.hexagram2021.oceanworld.common.register.OWPlacementModifierTypes;
import com.hexagram2021.oceanworld.common.register.OWProcessorType;
import com.hexagram2021.oceanworld.common.register.OWStructureKeys;
import com.hexagram2021.oceanworld.common.register.OWStructurePieceTypes;
import com.hexagram2021.oceanworld.common.register.OWStructureSetKeys;
import com.hexagram2021.oceanworld.common.register.OWStructureTypes;
import java.util.function.Consumer;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.monster.PatrollingMonster;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.SpawnPlacementRegisterEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.RegisterEvent;

@Mod.EventBusSubscriber(modid="oceanworld", bus=Mod.EventBusSubscriber.Bus.MOD)
public class OWContent {
    public static void modConstruction(IEventBus bus, Consumer<Runnable> runLater) {
        ModsLoadedHelper.compatModLoaded();
        OWMultiNoiseBiomeSourceParameterListPresets.init();
        OWCreativeModeTabs.init(bus);
        OWBlocks.init(bus);
        OWItems.init(bus);
        OWPlacementModifierTypes.init(bus);
        OWBiomeTags.init();
        OWBlockTags.init();
        OWConfiguredFeatureKeys.init();
        OWPlacedFeatureKeys.init();
        OWStructureTypes.init(bus);
        OWStructureKeys.init();
        OWStructureSetKeys.init();
    }

    @SubscribeEvent
    public static void onRegister(RegisterEvent event) {
        OWSounds.init(event);
        OWFeatures.init(event);
        OWStructurePieceTypes.init();
        OWProcessorType.init(event);
        OWEntities.init(event);
    }

    public static void init() {
    }

    @SubscribeEvent
    public static void registerEntitySpawnPlacement(SpawnPlacementRegisterEvent event) {
        event.register(OWEntities.SEA_CUCUMBER, SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, SeaCucumberEntity::checkSeaCucumberSpawnRules, SpawnPlacementRegisterEvent.Operation.OR);
        event.register(OWEntities.OCEANOLOGER, SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, PatrollingMonster::m_219025_, SpawnPlacementRegisterEvent.Operation.OR);
        event.register(OWEntities.BLACKLIP_OYSTER, SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, OysterEntity::checkOysterSpawnRules, SpawnPlacementRegisterEvent.Operation.OR);
        event.register(OWEntities.WHITELIP_OYSTER, SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, OysterEntity::checkOysterSpawnRules, SpawnPlacementRegisterEvent.Operation.OR);
    }

    @SubscribeEvent
    public static void onAttributeCreate(EntityAttributeCreationEvent event) {
        event.put(OWEntities.SEA_CUCUMBER, SeaCucumberEntity.createAttributes().m_22265_());
        event.put(OWEntities.OCEANOLOGER, OceanologerEntity.createAttributes().m_22265_());
        event.put(OWEntities.BLACKLIP_OYSTER, OysterEntity.createAttributes().m_22265_());
        event.put(OWEntities.WHITELIP_OYSTER, OysterEntity.createAttributes().m_22265_());
    }
}

