/*
 * Decompiled with CFR 0.152.
 */
package reloc.net.minecraftforge.fart.internal;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import reloc.net.minecraftforge.fart.api.ClassProvider;

class SortedClassProvider
implements ClassProvider {
    List<ClassProvider> classProviders;
    private final Consumer<String> log;
    private final Map<String, Optional<? extends ClassProvider.IClassInfo>> classCache = new ConcurrentHashMap<String, Optional<? extends ClassProvider.IClassInfo>>();

    SortedClassProvider(List<ClassProvider> classProviders, Consumer<String> log) {
        this.classProviders = classProviders;
        this.log = log;
    }

    @Override
    public Optional<? extends ClassProvider.IClassInfo> getClass(String cls) {
        return this.classCache.computeIfAbsent(cls, this::computeClassInfo);
    }

    @Override
    public Optional<byte[]> getClassBytes(String cls) {
        for (ClassProvider provider : this.classProviders) {
            Optional<byte[]> bytes = provider.getClassBytes(cls);
            if (!bytes.isPresent()) continue;
            return bytes;
        }
        return Optional.empty();
    }

    private Optional<? extends ClassProvider.IClassInfo> computeClassInfo(String name) {
        for (ClassProvider classProvider : this.classProviders) {
            Optional<? extends ClassProvider.IClassInfo> classInfo = classProvider.getClass(name);
            if (!classInfo.isPresent()) continue;
            return classInfo;
        }
        this.log.accept("Can't Find Class: " + name);
        return Optional.empty();
    }

    void clearCache() {
        this.classCache.clear();
    }

    @Override
    public void close() throws IOException {
        for (ClassProvider classProvider : this.classProviders) {
            classProvider.close();
        }
    }
}

