/*
 * Decompiled with CFR 0.152.
 */
package com.teampotato.despawn_tweaker.event;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.teampotato.despawn_tweaker.DespawnTweaker;
import com.teampotato.despawn_tweaker.api.IMob;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.server.ServerLifecycleHooks;

public class SpawnChecker {
    private static final Supplier<Set<String>> STRUCTURE_MODS = Suppliers.memoize(() -> new HashSet((Collection)DespawnTweaker.STRUCTURES_MODS.get()));
    private static final Supplier<Set<String>> STRUCTURES = Suppliers.memoize(() -> new HashSet((Collection)DespawnTweaker.STRUCTURES.get()));
    private static final Supplier<Registry<Structure>> STRUCTURES_REGISTRY = Suppliers.memoize(() -> ServerLifecycleHooks.getCurrentServer().m_206579_().m_175515_(Registries.f_256944_));

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onSpawn(MobSpawnEvent.FinalizeSpawn event) {
        if (event.isSpawnCancelled()) {
            return;
        }
        if (((Boolean)DespawnTweaker.ALLOW_MOBS_SPAWNED_BY_SPAWNERS_TO_DESPAWN.get()).booleanValue()) {
            return;
        }
        Mob entity = event.getEntity();
        if (!event.getSpawnType().equals((Object)MobSpawnType.SPAWNER)) {
            return;
        }
        if (entity.m_9236_().f_46443_) {
            return;
        }
        ((IMob)entity).despawnTweaker$setSpawnStructures(entity.m_9236_().m_46745_(entity.m_20183_()).m_62769_().keySet());
        entity.m_20049_("despawn_tweaker.shouldNotDespawn");
    }

    @SubscribeEvent
    public static void onDespwan(MobSpawnEvent.AllowDespawn event) {
        if (event.getResult().equals((Object)Event.Result.DENY)) {
            return;
        }
        Mob entity = event.getEntity();
        if (entity.m_9236_().f_46443_) {
            return;
        }
        if (!entity.m_19880_().contains("despawn_tweaker.shouldNotDespawn")) {
            return;
        }
        ChunkAccess levelChunk = entity.m_9236_().m_6522_(entity.m_20183_().m_123341_() >> 4, entity.m_20183_().m_123343_() >> 4, ChunkStatus.f_62326_, false);
        if (levelChunk == null) {
            return;
        }
        if (((Set)STRUCTURE_MODS.get()).isEmpty() && ((Set)STRUCTURES.get()).isEmpty()) {
            event.setResult(Event.Result.DENY);
        } else {
            for (Structure structure : ((IMob)entity).despawnTweaker$getSpawnStructures()) {
                boolean canDeny;
                ResourceLocation registryName = ((Registry)STRUCTURES_REGISTRY.get()).m_7981_((Object)structure);
                if (registryName == null) continue;
                boolean bl = canDeny = ((Set)STRUCTURE_MODS.get()).contains(registryName.m_135827_()) || ((Set)STRUCTURES.get()).contains(registryName.toString());
                if (!canDeny) continue;
                event.setResult(Event.Result.DENY);
                break;
            }
        }
    }
}

