/*
 * Decompiled with CFR 0.152.
 */
package net.cyber2000.oceanfront.common.effect;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Random;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.ProjectileImpactEvent;

public class DeflectionEffect
extends MobEffect {
    private static final Random random = new Random();

    public DeflectionEffect() {
        super(MobEffectCategory.BENEFICIAL, 16744272);
        MinecraftForge.EVENT_BUS.addListener(this::onProjectileImpact);
    }

    private void onProjectileImpact(ProjectileImpactEvent event) {
        HitResult hitResult = event.getRayTraceResult();
        if (!(hitResult instanceof EntityHitResult)) {
            return;
        }
        EntityHitResult hitResult2 = (EntityHitResult)hitResult;
        Entity entity = hitResult2.m_82443_();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity target = (LivingEntity)entity;
        if (!target.m_21023_((MobEffect)this)) {
            return;
        }
        Projectile proj = event.getProjectile();
        event.setCanceled(true);
        Vec3 oldMotion = this.attemptGetMotion(proj);
        if (oldMotion == null) {
            return;
        }
        double speed = oldMotion.m_82553_();
        Vec3 deflect = oldMotion.m_82520_((random.nextDouble() - 0.5) * 0.5, random.nextDouble() * 0.6 + 0.2, (random.nextDouble() - 0.5) * 0.5).m_82541_().m_82490_(speed);
        this.applyMotion(proj, deflect);
        this.applyRotation(proj, deflect);
    }

    private Vec3 attemptGetMotion(Object proj) {
        if (proj instanceof Projectile) {
            Projectile p = (Projectile)proj;
            return p.m_20184_();
        }
        try {
            Field vel = proj.getClass().getDeclaredField("motion");
            vel.setAccessible(true);
            Object vec = vel.get(proj);
            if (vec instanceof Vec3) {
                return (Vec3)vec;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private void applyMotion(Object proj, Vec3 deflect) {
        if (proj instanceof Projectile) {
            Projectile p = (Projectile)proj;
            p.m_20256_(deflect);
            p.f_19812_ = true;
        } else {
            try {
                Field vel = proj.getClass().getDeclaredField("motion");
                vel.setAccessible(true);
                vel.set(proj, deflect);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void applyRotation(Object proj, Vec3 deflect) {
        try {
            Method setY = proj.getClass().getMethod("setYRot", Float.TYPE);
            Method setX = proj.getClass().getMethod("setXRot", Float.TYPE);
            float yaw = (float)(Math.toDegrees(Math.atan2(deflect.f_82481_, deflect.f_82479_)) - 90.0);
            float pitch = (float)(-Math.toDegrees(Math.atan2(deflect.f_82480_, Math.sqrt(deflect.f_82479_ * deflect.f_82479_ + deflect.f_82481_ * deflect.f_82481_))));
            setY.invoke(proj, Float.valueOf(yaw));
            setX.invoke(proj, Float.valueOf(pitch));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

