/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.darkwaters.entity.tasks;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.Function;
import mod.azure.darkwaters.entity.AberrationEntity;
import mod.azure.darkwaters.entity.BaseWaterEntity;
import mod.azure.darkwaters.entity.ManarawEntity;
import mod.azure.darkwaters.entity.MohastEntity;
import mod.azure.darkwaters.entity.tasks.CustomDelayedBehaviour;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1690;
import net.minecraft.class_3218;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_4215;
import net.tslat.smartbrainlib.util.BrainUtils;
import org.jetbrains.annotations.Nullable;

public class WaterMeleeAttack<E extends BaseWaterEntity>
extends CustomDelayedBehaviour<E> {
    private static final List<Pair<class_4140<?>, class_4141>> MEMORY_REQUIREMENTS = ObjectArrayList.of((Object[])new Pair[]{Pair.of((Object)class_4140.field_22355, (Object)class_4141.field_18456), Pair.of((Object)class_4140.field_22475, (Object)class_4141.field_18457)});
    protected Function<E, Integer> attackIntervalSupplier = entity -> 20;
    @Nullable
    protected class_1309 target = null;

    public WaterMeleeAttack(int delayTicks) {
        super(delayTicks);
    }

    public WaterMeleeAttack<E> attackInterval(Function<E, Integer> supplier) {
        this.attackIntervalSupplier = supplier;
        return this;
    }

    protected List<Pair<class_4140<?>, class_4141>> getMemoryRequirements() {
        return MEMORY_REQUIREMENTS;
    }

    protected boolean checkExtraStartConditions(class_3218 level, E entity) {
        this.target = BrainUtils.getTargetOfEntity(entity);
        return entity.method_5985().method_6369((class_1297)this.target) && this.isWithinMeleeAttackRange(entity, this.target);
    }

    protected void start(E entity) {
        entity.method_6104(class_1268.field_5808);
        class_4215.method_19554(entity, (class_1309)this.target);
        ((BaseWaterEntity)((Object)entity)).setAttackingState(0);
    }

    protected void stop(E entity) {
        this.target = null;
        ((BaseWaterEntity)((Object)entity)).setAttackingState(0);
    }

    @Override
    protected void doDelayedAction(E entity) {
        BrainUtils.setForgettableMemory(entity, (class_4140)class_4140.field_22475, (Object)true, (int)this.attackIntervalSupplier.apply(entity));
        if (this.target == null) {
            return;
        }
        if (!entity.method_5985().method_6369((class_1297)this.target) || !entity.method_42150(this.target)) {
            return;
        }
        if (entity instanceof AberrationEntity) {
            ((BaseWaterEntity)((Object)entity)).grabTarget((class_1297)this.target);
            entity.method_6121((class_1297)this.target);
        }
        if (entity instanceof MohastEntity && this.target.method_5854() != null && this.target.method_5854() instanceof class_1690) {
            entity.method_6121((class_1297)this.target);
        }
        if (!(entity instanceof MohastEntity) || !(entity instanceof AberrationEntity)) {
            entity.method_6121((class_1297)this.target);
        }
    }

    public double getMeleeAttackRangeSqr(E entity, class_1309 target) {
        if (entity instanceof ManarawEntity) {
            return entity.method_17681() * 4.0f * (entity.method_17681() * 4.0f) + target.method_17681();
        }
        return entity.method_17681() * 3.0f * (entity.method_17681() * 3.0f) + target.method_17681();
    }

    public double getPerceivedTargetDistanceSquareForMeleeAttack(E entity, class_1309 target) {
        return Math.max(entity.method_5707(target.method_47921()), entity.method_5707(target.method_19538()));
    }

    public boolean isWithinMeleeAttackRange(E entity, class_1309 target) {
        double d = this.getPerceivedTargetDistanceSquareForMeleeAttack(entity, target);
        return d <= this.getMeleeAttackRangeSqr(entity, target);
    }
}

