/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.darkwaters.entity;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import mod.azure.azurelib.animatable.GeoEntity;
import mod.azure.azurelib.core.animatable.GeoAnimatable;
import mod.azure.azurelib.core.animatable.instance.AnimatableInstanceCache;
import mod.azure.azurelib.core.animation.AnimatableManager;
import mod.azure.azurelib.core.animation.Animation;
import mod.azure.azurelib.core.animation.AnimationController;
import mod.azure.azurelib.core.animation.RawAnimation;
import mod.azure.azurelib.util.AzureLibUtil;
import mod.azure.darkwaters.DarkWatersMod;
import mod.azure.darkwaters.entity.BaseWaterEntity;
import mod.azure.darkwaters.entity.helper.AttackType;
import mod.azure.darkwaters.entity.tasks.WaterMeleeAttack;
import mod.azure.darkwaters.util.DarkWatersSounds;
import net.minecraft.class_1282;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_4095;
import net.minecraft.class_4097;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.tslat.smartbrainlib.api.SmartBrainOwner;
import net.tslat.smartbrainlib.api.core.BrainActivityGroup;
import net.tslat.smartbrainlib.api.core.SmartBrainProvider;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.FirstApplicableBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.OneRandomBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.look.LookAtTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.Idle;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.MoveToWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetRandomWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetWalkTargetToAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.InvalidateAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.SetPlayerLookTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.SetRandomLookTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.TargetOrRetaliate;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.api.core.sensor.custom.UnreachableTargetSensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.HurtBySensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.NearbyLivingEntitySensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.NearbyPlayersSensor;

public class CraekenEntity
extends BaseWaterEntity
implements GeoEntity,
SmartBrainOwner<CraekenEntity> {
    private AnimatableInstanceCache cache = AzureLibUtil.createInstanceCache((GeoAnimatable)this);

    public CraekenEntity(class_1299<? extends BaseWaterEntity> entityType, class_1937 world) {
        super(entityType, world);
        this.field_6194 = DarkWatersMod.config.craekenconfigs.craeken_exp;
    }

    public static class_5132.class_5133 createMobAttributes() {
        return BaseWaterEntity.createMobAttributes().method_26868(class_5134.field_23716, DarkWatersMod.config.craekenconfigs.craeken_health).method_26868(class_5134.field_23721, DarkWatersMod.config.craekenconfigs.craeken_attack_damage);
    }

    protected class_4095.class_5303<?> method_28306() {
        return new SmartBrainProvider((class_1309)this);
    }

    protected void method_5958() {
        this.tickBrain((class_1309)this);
    }

    public List<ExtendedSensor<CraekenEntity>> getSensors() {
        return ObjectArrayList.of((Object[])new ExtendedSensor[]{new NearbyPlayersSensor(), new NearbyLivingEntitySensor().setPredicate((target, entity) -> target instanceof class_1657 || !(target instanceof BaseWaterEntity) || target instanceof class_1646), new HurtBySensor(), new UnreachableTargetSensor()});
    }

    public BrainActivityGroup<CraekenEntity> getCoreTasks() {
        return BrainActivityGroup.coreTasks((class_4097[])new class_4097[]{new LookAtTarget(), new MoveToWalkTarget()});
    }

    public BrainActivityGroup<CraekenEntity> getIdleTasks() {
        return BrainActivityGroup.idleTasks((class_4097[])new class_4097[]{new FirstApplicableBehaviour(new ExtendedBehaviour[]{new TargetOrRetaliate(), new SetPlayerLookTarget().stopIf(target -> {
            class_1657 player;
            return !target.method_5805() || target instanceof class_1657 && ((player = (class_1657)target).method_7337() || player.method_7325());
        }), new SetRandomLookTarget()}), new OneRandomBehaviour(new ExtendedBehaviour[]{new SetRandomWalkTarget().speedModifier(1.0f), new Idle().runFor(entity -> entity.method_6051().method_43051(30, 60))})});
    }

    public BrainActivityGroup<CraekenEntity> getFightTasks() {
        return BrainActivityGroup.fightTasks((class_4097[])new class_4097[]{new InvalidateAttackTarget().stopIf(target -> {
            class_1657 player;
            return !target.method_5805() || target instanceof class_1657 && ((player = (class_1657)target).method_7337() || player.method_7325());
        }), new SetWalkTargetToAttackTarget().speedMod((owner, target) -> Float.valueOf(1.5f)), new WaterMeleeAttack(10).whenStarting(entity -> this.method_19540(true)).whenStarting(entity -> this.method_19540(false))});
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        boolean isAttacking = this.field_6252;
        boolean isDead = this.field_6272 || (double)this.method_6032() < 0.01 || this.method_29504();
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "idle_controller", 0, event -> {
            if (event.isMoving() && !isDead && !isAttacking) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("moving"));
            }
            return event.setAndContinue(RawAnimation.begin().thenLoop("idle"));
        }).triggerableAnim("attack", RawAnimation.begin().then("attack", Animation.LoopType.PLAY_ONCE)).triggerableAnim("grab", RawAnimation.begin().then("grab", Animation.LoopType.PLAY_ONCE)).triggerableAnim("death", RawAnimation.begin().thenPlayAndHold("death"))});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Override
    public void method_5773() {
        super.method_5773();
        if (this.attackProgress > 0) {
            --this.attackProgress;
            if (!this.method_37908().field_9236 && this.attackProgress <= 0) {
                this.setCurrentAttackType(AttackType.NONE);
            }
        }
        if (this.attackProgress == 0 && this.field_6252) {
            this.attackProgress = 10;
        }
        if (!this.method_37908().field_9236 && this.getCurrentAttackType() == AttackType.NONE) {
            this.setCurrentAttackType(switch (this.field_5974.method_43048(4)) {
                case 1 -> AttackType.GRAB;
                default -> AttackType.ATTACK;
            });
        }
    }

    public double method_33191(class_1309 livingEntity) {
        return this.method_17681() * 1.0f * (this.method_17681() * 1.0f + livingEntity.method_17681());
    }

    public boolean method_42150(class_1309 livingEntity) {
        double d = this.method_5649(livingEntity.method_23317(), livingEntity.method_23318(), livingEntity.method_23321());
        return d <= this.method_33191(livingEntity);
    }

    protected class_3414 method_5994() {
        return class_3417.field_14818;
    }

    protected class_3414 method_6002() {
        return class_3417.field_14732;
    }

    protected class_3414 method_6011(class_1282 source) {
        return this.method_6051().method_43051(0, 3) == 1 ? DarkWatersSounds.CRAEKEN_HURT1 : DarkWatersSounds.CRAEKEN_HURT2;
    }
}

