/*
 * Decompiled with CFR 0.152.
 */
package dev.foxgirl.mc.loadingbackgrounds;

import com.google.common.collect.Iterators;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.foxgirl.bundled.Q;
import dev.foxgirl.bundled.ay;
import dev.foxgirl.bundled.ba;
import dev.foxgirl.bundled.bh;
import dev.foxgirl.bundled.bl;
import dev.foxgirl.bundled.bm;
import dev.foxgirl.bundled.bn;
import dev.foxgirl.bundled.d;
import dev.foxgirl.bundled.e;
import dev.foxgirl.bundled.v;
import dev.foxgirl.mc.loadingbackgrounds.Config;
import dev.foxgirl.mc.loadingbackgrounds.LoadingBackgrounds;
import dev.foxgirl.mc.loadingbackgrounds.impl.PNG;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.ConnectScreen;
import net.minecraft.client.gui.screens.LevelLoadingScreen;
import net.minecraft.client.gui.screens.ProgressScreen;
import net.minecraft.client.gui.screens.ReceivingLevelScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.Unit;
import org.apache.logging.log4j.Logger;

public final class LoadingBackgroundsKt {
    private static final d config$delegate = e.lazy(LoadingBackgroundsKt::config_delegate$lambda$0);
    private static final Set<String> loadingMessageTranslationKeys;
    private static final bl resourcePackRegex;
    private static int reloadResourcePacksHash;
    private static final ay<Double> seconds;
    private static Iterator<PNG> pngIterator;
    private static PNG pngPrevious;
    private static PNG pngCurrent;
    private static double secondsAtChange;
    private static boolean isFading;

    public static final Logger getLogger() {
        Logger logger = LoadingBackgrounds.LOGGER;
        ba.checkNotNullExpressionValue(logger, "");
        return logger;
    }

    public static final Config getConfig() {
        d d2 = config$delegate;
        return (Config)d2.getValue();
    }

    public static final Minecraft getMinecraft() {
        Minecraft minecraft = Minecraft.m_91087_();
        ba.checkNotNullExpressionValue(minecraft, "");
        return minecraft;
    }

    public static final PackRepository getResourcePacks() {
        PackRepository packRepository = LoadingBackgroundsKt.getMinecraft().m_91099_();
        ba.checkNotNullExpressionValue(packRepository, "");
        return packRepository;
    }

    public static final ReloadableResourceManager getResourceManager() {
        ResourceManager resourceManager = LoadingBackgroundsKt.getMinecraft().m_91098_();
        ba.checkNotNull(resourceManager);
        return (ReloadableResourceManager)resourceManager;
    }

    public static final TextureManager getTextureManager() {
        TextureManager textureManager = LoadingBackgroundsKt.getMinecraft().m_91097_();
        ba.checkNotNullExpressionValue(textureManager, "");
        return textureManager;
    }

    public static final Executor getBackgroundExecutor() {
        ExecutorService executorService = Util.m_183991_();
        ba.checkNotNull(executorService);
        return executorService;
    }

    public static final Executor getIoExecutor() {
        ExecutorService executorService = Util.m_183992_();
        ba.checkNotNull(executorService);
        return executorService;
    }

    public static final Executor getGameExecutor() {
        return (Executor)LoadingBackgroundsKt.getMinecraft();
    }

    public static final Set<String> getLoadingMessageTranslationKeys() {
        return loadingMessageTranslationKeys;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isLoadingMessage(Component component) {
        Component p0;
        if (component == null) {
            return false;
        }
        ComponentContents contents = component.m_214077_();
        if (contents instanceof TranslatableContents) {
            if (loadingMessageTranslationKeys.contains(((TranslatableContents)contents).m_237508_())) return true;
        }
        List list = component.m_7360_();
        ba.checkNotNullExpressionValue(list, "");
        Iterable $this$any$iv = list;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            p0 = (Component)element$iv;
            boolean bl2 = false;
        } while (!LoadingBackgroundsKt.isLoadingMessage(p0));
        return true;
    }

    public static final boolean isLoadingScreen(Screen screen) {
        ba.checkNotNullParameter(screen, "");
        if (screen instanceof ProgressScreen) {
            return true;
        }
        if (screen instanceof ConnectScreen) {
            return true;
        }
        if (screen instanceof LevelLoadingScreen) {
            return true;
        }
        if (screen instanceof ReceivingLevelScreen) {
            return true;
        }
        return LoadingBackgroundsKt.isLoadingMessage(screen.m_96636_());
    }

    public static final bl getResourcePackRegex() {
        return resourcePackRegex;
    }

    public static final int getReloadResourcePacksHash() {
        return reloadResourcePacksHash;
    }

    public static final void setReloadResourcePacksHash(int n2) {
        reloadResourcePacksHash = n2;
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean reloadResourcePacks() {
        void $this$mapTo$iv$iv;
        Collection collection = LoadingBackgroundsKt.getResourcePacks().m_10519_();
        ba.checkNotNullExpressionValue(collection, "");
        Iterable $this$map$iv = collection;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(v.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Pack pack = (Pack)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl2 = false;
            collection2.add(it.m_10446_());
        }
        int oldHash = reloadResourcePacksHash;
        int newHash = ((Object)((List)destination$iv$iv)).hashCode();
        if (oldHash == newHash) {
            return false;
        }
        reloadResourcePacksHash = newHash;
        boolean added = false;
        for (Pack pack : LoadingBackgroundsKt.getResourcePacks().m_10519_()) {
            String string = pack.m_10446_();
            ba.checkNotNullExpressionValue(string, "");
            if (!resourcePackRegex.containsMatchIn(string)) {
                String string2 = pack.m_10429_().getString();
                ba.checkNotNullExpressionValue(string2, "");
                if (!resourcePackRegex.containsMatchIn(string2)) continue;
            }
            added = LoadingBackgroundsKt.getResourcePacks().m_275855_(pack.m_10446_()) || added;
        }
        if (added) {
            LoadingBackgroundsKt.getResourceManager().m_142463_(LoadingBackgroundsKt.getBackgroundExecutor(), LoadingBackgroundsKt.getGameExecutor(), CompletableFuture.completedFuture(Unit.INSTANCE), LoadingBackgroundsKt.getResourcePacks().m_10525_());
            return true;
        }
        return false;
    }

    public static final List<ResourceLocation> selectPNGLocations() {
        Map resources = LoadingBackgroundsKt.getResourceManager().m_214159_("textures/gui/backgrounds", LoadingBackgroundsKt::selectPNGLocations$lambda$2);
        List<ResourceLocation> locations = v.toList(resources.keySet());
        return locations;
    }

    public static final List<ResourceLocation> selectPNGLocationsOrReload() {
        List<ResourceLocation> locations = LoadingBackgroundsKt.selectPNGLocations();
        if (locations.isEmpty() && LoadingBackgroundsKt.getConfig().getShouldLoadResources() && LoadingBackgroundsKt.reloadResourcePacks()) {
            locations = LoadingBackgroundsKt.selectPNGLocations();
        }
        return locations;
    }

    public static final List<PNG> selectPNGs() {
        List<ResourceLocation> locations = LoadingBackgroundsKt.selectPNGLocationsOrReload();
        if (!((Collection)locations).isEmpty()) {
            List<PNG> list = PNG.Companion.get((Iterable<? extends ResourceLocation>)locations).get(5L, TimeUnit.SECONDS);
            ba.checkNotNullExpressionValue(list, "");
            return list;
        }
        return v.emptyList();
    }

    public static final void renderPNG(Screen screen, GuiGraphics gui, PNG png, float brightness, float opacity) {
        ba.checkNotNullParameter(screen, "");
        ba.checkNotNullParameter(gui, "");
        ba.checkNotNullParameter(png, "");
        float offsetX = 0.0f;
        float offsetY = 0.0f;
        float scaleX = (float)screen.f_96543_ / (float)png.getWidth();
        float scaleY = (float)screen.f_96544_ / (float)png.getHeight();
        if (scaleX < scaleY) {
            scaleX = scaleY;
            offsetX = 0.0f - ((float)screen.f_96543_ - (float)png.getWidth() * scaleX) * 0.5f;
        } else {
            scaleY = scaleX;
            offsetY = 0.0f - ((float)screen.f_96544_ - (float)png.getHeight() * scaleY) * 0.5f;
        }
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableBlend();
        ShaderInstance shader = RenderSystem.getShader();
        float[] shaderColor = RenderSystem.getShaderColor();
        int shaderTexture = RenderSystem.getShaderTexture((int)0);
        RenderSystem.setShaderColor((float)brightness, (float)brightness, (float)brightness, (float)opacity);
        gui.m_280163_(png.getLocation(), 0, 0, offsetX, offsetY, screen.f_96543_, screen.f_96544_, (int)((float)png.getWidth() * scaleX), (int)((float)png.getHeight() * scaleY));
        RenderSystem.setShader(() -> LoadingBackgroundsKt.renderPNG$lambda$3(shader));
        RenderSystem.setShaderColor((float)shaderColor[0], (float)shaderColor[1], (float)shaderColor[2], (float)shaderColor[3]);
        RenderSystem.setShaderTexture((int)0, (int)shaderTexture);
        RenderSystem.disableBlend();
    }

    public static final ay<Double> getSeconds() {
        return seconds;
    }

    public static final Iterator<PNG> getPngIterator() {
        return pngIterator;
    }

    public static final void setPngIterator(Iterator<PNG> iterator) {
        pngIterator = iterator;
    }

    public static final PNG getPngPrevious() {
        return pngPrevious;
    }

    public static final void setPngPrevious(PNG pNG) {
        pngPrevious = pNG;
    }

    public static final PNG getPngCurrent() {
        return pngCurrent;
    }

    public static final void setPngCurrent(PNG pNG) {
        pngCurrent = pNG;
    }

    public static final double getSecondsAtChange() {
        return secondsAtChange;
    }

    public static final void setSecondsAtChange(double d2) {
        secondsAtChange = d2;
    }

    public static final boolean isFading() {
        return isFading;
    }

    public static final void setFading(boolean bl2) {
        isFading = bl2;
    }

    public static final boolean renderBackground(Screen screen, GuiGraphics gui) {
        ba.checkNotNullParameter(screen, "");
        ba.checkNotNullParameter(gui, "");
        if (!LoadingBackgroundsKt.isLoadingScreen(screen)) {
            return false;
        }
        double secondsNow = ((Number)seconds.invoke()).doubleValue();
        double secondsSinceChange = secondsNow - secondsAtChange;
        if (pngIterator == null || secondsSinceChange > Math.max(LoadingBackgroundsKt.getConfig().getSecondsFade(), LoadingBackgroundsKt.getConfig().getSecondsStay()) + 5.0) {
            secondsSinceChange = 0.0;
            secondsAtChange = secondsNow;
            isFading = false;
            List<PNG> pngs = LoadingBackgroundsKt.selectPNGs();
            if (pngs.isEmpty()) {
                return false;
            }
            pngIterator = Iterators.cycle((Iterable)pngs);
            Iterator<PNG> iterator = pngIterator;
            ba.checkNotNull(iterator);
            pngPrevious = iterator.next();
            Iterator<PNG> iterator2 = pngIterator;
            ba.checkNotNull(iterator2);
            pngCurrent = iterator2.next();
        }
        if (isFading) {
            PNG pNG = pngPrevious;
            ba.checkNotNull(pNG);
            LoadingBackgroundsKt.renderPNG(screen, gui, pNG, LoadingBackgroundsKt.getConfig().getBrightness(), 1.0f);
            PNG pNG2 = pngCurrent;
            ba.checkNotNull(pNG2);
            LoadingBackgroundsKt.renderPNG(screen, gui, pNG2, LoadingBackgroundsKt.getConfig().getBrightness(), (float)bh.coerceIn(secondsSinceChange / LoadingBackgroundsKt.getConfig().getSecondsFade(), 0.0, 1.0));
            if (secondsSinceChange > LoadingBackgroundsKt.getConfig().getSecondsFade()) {
                secondsAtChange = secondsNow;
                isFading = false;
            }
        } else {
            PNG pNG = pngCurrent;
            ba.checkNotNull(pNG);
            LoadingBackgroundsKt.renderPNG(screen, gui, pNG, LoadingBackgroundsKt.getConfig().getBrightness(), 1.0f);
            if (secondsSinceChange > LoadingBackgroundsKt.getConfig().getSecondsStay()) {
                secondsAtChange = secondsNow;
                isFading = true;
                pngPrevious = pngCurrent;
                Iterator<PNG> iterator = pngIterator;
                ba.checkNotNull(iterator);
                pngCurrent = iterator.next();
            }
        }
        return true;
    }

    public static final void init() {
        LoadingBackgroundsKt.getLogger().info("Hello from Loading Backgrounds :3c");
    }

    private static final Config config_delegate$lambda$0() {
        return Config.Companion.load();
    }

    private static final boolean selectPNGLocations$lambda$2(ResourceLocation it) {
        String string = it.m_135815_();
        ba.checkNotNullExpressionValue(string, "");
        return bn.endsWith$default(string, ".png", false, 2, null);
    }

    private static final ShaderInstance renderPNG$lambda$3(ShaderInstance $shader) {
        return $shader;
    }

    private static final double seconds$lambda$5$lambda$4(long $start) {
        return (double)(System.nanoTime() - $start) * 1.0E-9;
    }

    static {
        String[] stringArray = new String[]{"menu.generatingLevel", "menu.generatingTerrain", "menu.loadingForcedChunks", "menu.loadingLevel", "menu.preparingSpawn", "menu.savingChunks", "menu.savingLevel", "menu.working", "multiplayer.downloadingStats", "multiplayer.downloadingTerrain", "selectWorld.data_read", "selectWorld.loading_list", "selectWorld.resource_load", "resourcepack.downloading", "resourcepack.progress", "download.pack.title"};
        loadingMessageTranslationKeys = Q.setOf(stringArray);
        resourcePackRegex = new bl("load(ing)?[\\W_]{0,3}(background|bg|image|img|pic)", bm.IGNORE_CASE);
        boolean bl2 = false;
        long start = System.nanoTime();
        seconds = () -> LoadingBackgroundsKt.seconds$lambda$5$lambda$4(start);
    }
}

