/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.betterburning.config;

import net.darkhax.betterburning.config.IConfig;
import net.minecraftforge.common.ForgeConfigSpec;

public class ConfigForge
implements IConfig {
    private final ForgeConfigSpec spec;
    private final ForgeConfigSpec.BooleanValue fireResExtinguish;
    private final ForgeConfigSpec.BooleanValue fireFromDamagesource;
    private final ForgeConfigSpec.BooleanValue fireDamageSpreads;
    private final ForgeConfigSpec.DoubleValue fireDamageSpreadChance;
    private final ForgeConfigSpec.BooleanValue flameArrowSkeletons;
    private final ForgeConfigSpec.ConfigValue<Double> flameArrowChance;
    private final ForgeConfigSpec.BooleanValue flintAndSteelDealsFireDamage;
    private final ForgeConfigSpec.IntValue flintAndSteelFireDamage;
    private final ForgeConfigSpec.BooleanValue fireOverlay;
    private final ForgeConfigSpec.IntValue fireHitBurnTime;
    private final ForgeConfigSpec.IntValue soulfireHitBurnTime;
    private final ForgeConfigSpec.BooleanValue punchOutFlames;
    private final ForgeConfigSpec.BooleanValue extinguishWithBottle;

    public ConfigForge() {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        builder.comment("General settings for the mod.");
        builder.push("general");
        builder.comment("Should having fire resistance stop things from being on fire visually?");
        this.fireResExtinguish = builder.define("fireResistanceExtinguish", true);
        builder.comment("Fixes some fire related damage sources not causing mobs to drop cooked items?");
        this.fireFromDamagesource = builder.define("fireFromDamagesource", true);
        builder.comment("Should fire damage spread between mobs when they hurt eachother? Zombies already do this and won't be changed.");
        this.fireDamageSpreads = builder.define("fireDamageSpreads", true);
        builder.comment("What is the % chance that fire damage will spread between mobs?");
        this.fireDamageSpreadChance = builder.defineInRange("fireDamageSpreadChance", 0.3, 0.0, 1.0);
        builder.comment("Should skeletons shoot flaming arrows while on fire?");
        this.flameArrowSkeletons = builder.define("flameArrowSkeletons", true);
        builder.comment("What is the % chance skeletons will shoot flaming arrows while on fire?");
        this.flameArrowChance = builder.defineInRange("flameArrowSkeletonChance", 0.7, 0.0, 1.0);
        builder.comment("Should flint and steel deal fire damage when used as a weapon?");
        this.flintAndSteelDealsFireDamage = builder.define("ShouldFlintAndSteelDoFireDamage", true);
        builder.comment("How much fire damage should flint and steel do?");
        this.flintAndSteelFireDamage = builder.defineInRange("flintAndSteelFireDamage", 3, 0, Integer.MAX_VALUE);
        builder.comment("Should the fire/burning HUD overlay be hidden if the player has fire immunity?");
        this.fireOverlay = builder.define("hideFireOverlayWhenImmune", true);
        builder.comment("How long should Fire burn players if they try to punch it out?");
        this.fireHitBurnTime = builder.defineInRange("fireHitBurnTime", 1, 0, Integer.MAX_VALUE);
        builder.comment("How long should Soulfire burn players if they try to punch it out?");
        this.soulfireHitBurnTime = builder.defineInRange("soulfireHitBurnTime", 2, 0, Integer.MAX_VALUE);
        builder.comment("Should players be able to put out fire blocks by punching them?");
        this.punchOutFlames = builder.define("punchOutFlames", true);
        builder.comment("Can players put out fire with bottled water?");
        this.extinguishWithBottle = builder.define("extinguishWithBottledWater", true);
        this.spec = builder.build();
    }

    public ForgeConfigSpec getSpec() {
        return this.spec;
    }

    @Override
    public boolean shouldFireResExtinguish() {
        return (Boolean)this.fireResExtinguish.get();
    }

    @Override
    public boolean shouldDamageSourceCauseFire() {
        return (Boolean)this.fireFromDamagesource.get();
    }

    @Override
    public boolean shouldFireDamageSpread() {
        return (Boolean)this.fireDamageSpreads.get();
    }

    @Override
    public double getFireDamageSpreadChance() {
        return (Double)this.fireDamageSpreadChance.get();
    }

    @Override
    public boolean shouldSkeletonsShootFireArrows() {
        return (Boolean)this.flameArrowSkeletons.get();
    }

    @Override
    public double getSkeletonFlameArrowChance() {
        return (Double)this.flameArrowChance.get();
    }

    @Override
    public boolean shouldFlintAndSteelDoFireDamage() {
        return (Boolean)this.flintAndSteelDealsFireDamage.get();
    }

    @Override
    public int getFlintAndSteelFireDamage() {
        return (Integer)this.flintAndSteelFireDamage.get();
    }

    @Override
    public boolean hideFireOverlay() {
        return (Boolean)this.fireOverlay.get();
    }

    @Override
    public int getFirePunchBurnTime() {
        return (Integer)this.fireHitBurnTime.get();
    }

    @Override
    public int getSoulFirePunchBurnTime() {
        return (Integer)this.soulfireHitBurnTime.get();
    }

    @Override
    public boolean canPunchOutFlames() {
        return (Boolean)this.punchOutFlames.get();
    }

    @Override
    public boolean canExtinguishWithBottledWater() {
        return (Boolean)this.extinguishWithBottle.get();
    }
}

