/*
 * Decompiled with CFR 0.152.
 */
package com.min01.oceanicrealms.network;

import com.min01.oceanicrealms.entity.living.EntityCrab;
import com.min01.oceanicrealms.util.OceanicUtil;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;

public class UpdateCrabDancePacket {
    private final UUID entityUUID;
    private final boolean isDance;
    private final BlockPos jukebox;

    public UpdateCrabDancePacket(UUID entityUUID, boolean isDance, BlockPos jukebox) {
        this.entityUUID = entityUUID;
        this.isDance = isDance;
        this.jukebox = jukebox;
    }

    public UpdateCrabDancePacket(FriendlyByteBuf buf) {
        this.entityUUID = buf.m_130259_();
        this.isDance = buf.readBoolean();
        this.jukebox = buf.m_130135_();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130077_(this.entityUUID);
        buf.writeBoolean(this.isDance);
        buf.m_130064_(this.jukebox);
    }

    public static class Handler {
        public static boolean onMessage(UpdateCrabDancePacket message, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                Entity entity = OceanicUtil.getEntityByUUID(((NetworkEvent.Context)ctx.get()).getSender().f_19853_, message.entityUUID);
                if (entity instanceof EntityCrab) {
                    EntityCrab crab = (EntityCrab)entity;
                    crab.jukebox = message.jukebox.equals((Object)BlockPos.f_121853_) ? null : message.jukebox;
                    crab.setDance(message.isDance);
                }
            });
            ctx.get().setPacketHandled(true);
            return true;
        }
    }
}

