/*
 * Decompiled with CFR 0.152.
 */
package com.min01.oceanicrealms.misc;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public class KinematicChain {
    protected Entity entity;
    protected Vec3 target;
    protected Vec3 anchorPos;
    protected ChainSegment[] segments;

    public KinematicChain(Entity entity, int length) {
        this(entity, length, 0.0f);
    }

    public KinematicChain(Entity entity, int length, float distance) {
        this.entity = entity;
        this.segments = new ChainSegment[length];
        this.createSegments(distance);
    }

    public void createSegments(float distance) {
        this.setupSegments(distance);
        this.setupPos();
    }

    public void setupSegments(float distance) {
        for (int i = 0; i < this.segments.length; ++i) {
            this.segments[i] = new ChainSegment(distance);
        }
    }

    public void setupPos() {
        for (ChainSegment segment : this.segments) {
            segment.setPos(this.entity.m_20182_());
        }
    }

    public void setOldPosAndRot() {
        for (ChainSegment segment : this.segments) {
            segment.setOldPos(segment.position);
            segment.setOldRot(segment.rotation);
        }
    }

    public void tick() {
        int i;
        if (this.target != null) {
            ChainSegment tip = this.getTipSegment();
            Vec3 tipPos = tip.getPos();
            Vec3 toTarget = this.target.m_82546_(tipPos);
            double dist = toTarget.m_82553_();
            double moveDist = Math.min(dist, (double)tip.distance);
            tip.setRot(this.lookAt(tipPos, this.target));
            tip.setPos(this.getLookPos(tip.getRot(), tipPos, 0.0, 0.0, moveDist));
        }
        for (i = 1; i < this.segments.length; ++i) {
            int index = i - 1;
            ChainSegment current = this.segments[this.segments.length - i - 1];
            ChainSegment next = this.segments[this.segments.length - index - 1];
            current.setRot(this.lookAt(current.getPos(), next.getPos()));
            current.setPos(this.getLookPos(current.getRot(), next.getPos(), 0.0, 0.0, -current.distance));
        }
        if (this.anchorPos != null) {
            this.segments[0].setPos(this.anchorPos);
        }
        for (i = 0; i < this.segments.length - 1; ++i) {
            ChainSegment current = this.segments[i];
            ChainSegment next = this.segments[i + 1];
            current.setRot(this.lookAt(current.getPos(), next.getPos()));
            next.setPos(this.getLookPos(current.getRot(), current.getPos(), 0.0, 0.0, next.distance));
        }
    }

    public void addParticle(Vec3 pos, double deltaX, double deltaY, double deltaZ, double speed, int count) {
        Level level = this.entity.f_19853_;
        for (int i = 0; i < count; ++i) {
            double d1 = level.f_46441_.m_188583_() * deltaX;
            double d3 = level.f_46441_.m_188583_() * deltaY;
            double d5 = level.f_46441_.m_188583_() * deltaZ;
            double d6 = level.f_46441_.m_188583_() * speed;
            double d7 = level.f_46441_.m_188583_() * speed;
            double d8 = level.f_46441_.m_188583_() * speed;
            level.m_7107_((ParticleOptions)ParticleTypes.f_123795_, pos.f_82479_ + d1, pos.f_82480_ + d3, pos.f_82481_ + d5, d6, d7, d8);
        }
    }

    public Vec2 lookAt(Vec3 startPos, Vec3 pos) {
        Vec3 vec3 = startPos;
        double d0 = pos.f_82479_ - vec3.f_82479_;
        double d1 = pos.f_82480_ - vec3.f_82480_;
        double d2 = pos.f_82481_ - vec3.f_82481_;
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        float xRot = Mth.m_14177_((float)((float)(-(Mth.m_14136_((double)d1, (double)d3) * 57.2957763671875))));
        float yRot = Mth.m_14177_((float)((float)(Mth.m_14136_((double)d2, (double)d0) * 57.2957763671875) - 90.0f));
        return new Vec2(xRot, yRot);
    }

    public Vec3 getLookPos(Vec2 rotation, Vec3 position, double left, double up, double forwards) {
        Vec2 vec2 = rotation;
        Vec3 vec3 = position;
        float f = Mth.m_14089_((float)((vec2.f_82471_ + 90.0f) * ((float)Math.PI / 180)));
        float f1 = Mth.m_14031_((float)((vec2.f_82471_ + 90.0f) * ((float)Math.PI / 180)));
        float f2 = Mth.m_14089_((float)(-vec2.f_82470_ * ((float)Math.PI / 180)));
        float f3 = Mth.m_14031_((float)(-vec2.f_82470_ * ((float)Math.PI / 180)));
        float f4 = Mth.m_14089_((float)((-vec2.f_82470_ + 90.0f) * ((float)Math.PI / 180)));
        float f5 = Mth.m_14031_((float)((-vec2.f_82470_ + 90.0f) * ((float)Math.PI / 180)));
        Vec3 vec31 = new Vec3((double)(f * f2), (double)f3, (double)(f1 * f2));
        Vec3 vec32 = new Vec3((double)(f * f4), (double)f5, (double)(f1 * f4));
        Vec3 vec33 = vec31.m_82537_(vec32).m_82490_(-1.0);
        double d0 = vec31.f_82479_ * forwards + vec32.f_82479_ * up + vec33.f_82479_ * left;
        double d1 = vec31.f_82480_ * forwards + vec32.f_82480_ * up + vec33.f_82480_ * left;
        double d2 = vec31.f_82481_ * forwards + vec32.f_82481_ * up + vec33.f_82481_ * left;
        return new Vec3(vec3.f_82479_ + d0, vec3.f_82480_ + d1, vec3.f_82481_ + d2);
    }

    public ChainSegment[] getSegments() {
        return this.segments;
    }

    public Entity getEntity() {
        return this.entity;
    }

    public void setAnchorPos(Vec3 target) {
        this.anchorPos = target;
    }

    public Vec3 getAnchorPos() {
        return this.anchorPos;
    }

    public void setTarget(Vec3 target) {
        this.target = target;
    }

    public Vec3 getTarget() {
        return this.target;
    }

    public ChainSegment getTipSegment() {
        return this.segments[this.segments.length - 1];
    }

    public static class ChainSegment {
        protected Vec3 position = Vec3.f_82478_;
        protected Vec3 oldPosition = Vec3.f_82478_;
        protected Vec2 rotation = Vec2.f_82462_;
        protected Vec2 oldRotation = Vec2.f_82462_;
        protected float distance;

        public ChainSegment(float distance) {
            this.distance = distance;
        }

        public Vec3 position(float partialTicks) {
            return this.oldPosition.m_165921_(this.position, (double)partialTicks);
        }

        public Vec2 getRot(float partialTick) {
            float xRot = Mth.m_14179_((float)partialTick, (float)this.oldRotation.f_82470_, (float)this.rotation.f_82470_);
            float yRot = Mth.m_14189_((float)partialTick, (float)this.oldRotation.f_82471_, (float)this.rotation.f_82471_);
            return new Vec2(xRot, yRot);
        }

        public void setRot(Vec2 rot) {
            this.rotation = rot;
        }

        public Vec2 getRot() {
            return this.rotation;
        }

        public void setOldRot(Vec2 rot) {
            this.oldRotation = rot;
        }

        public Vec2 getOldRot() {
            return this.oldRotation;
        }

        public void setPos(Vec3 pos) {
            this.position = pos;
        }

        public Vec3 getPos() {
            return this.position;
        }

        public void setOldPos(Vec3 pos) {
            this.oldPosition = pos;
        }

        public Vec3 getOldPos() {
            return this.oldPosition;
        }

        public void setDistance(float distance) {
            this.distance = distance;
        }

        public float getDistance() {
            return this.distance;
        }
    }
}

