/*
 * Decompiled with CFR 0.152.
 */
package com.min01.oceanicrealms.entity.living;

import com.min01.oceanicrealms.entity.AbstractOceanicCreature;
import com.min01.oceanicrealms.entity.AgeableWaterAnimal;
import com.min01.oceanicrealms.entity.ai.control.BoidMoveControl;
import com.min01.oceanicrealms.entity.living.EntityWhaleshark;
import com.min01.oceanicrealms.item.OceanicItems;
import com.min01.oceanicrealms.util.OceanicUtil;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Math;

public class EntityMackerelFish
extends AbstractOceanicCreature
implements Bucketable {
    public static final EntityDataAccessor<Boolean> FROM_BUCKET = SynchedEntityData.m_135353_(EntityMackerelFish.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Integer> FOLLOW_DURATION = SynchedEntityData.m_135353_(EntityMackerelFish.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public final AnimationState dryAnimationState = new AnimationState();

    public EntityMackerelFish(EntityType<? extends AgeableWaterAnimal> p_33002_, Level p_33003_) {
        super(p_33002_, p_33003_);
        this.f_21342_ = new BoidMoveControl((Mob)this, 85, 0.5f, 0.1f, false);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 3.0).m_22268_(Attributes.f_22279_, (double)0.45f);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(FROM_BUCKET, (Object)false);
        this.f_19804_.m_135372_(FOLLOW_DURATION, (Object)1200);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.f_19853_.f_46443_) {
            this.dryAnimationState.m_246184_(!this.m_20069_(), this.f_19797_);
        }
        OceanicUtil.fishFlopping((LivingEntity)this);
        if (this.f_19797_ % 10 == 0) {
            this.followWhaleshark();
        }
    }

    public void followWhaleshark() {
        List list = this.f_19853_.m_45976_(EntityWhaleshark.class, this.m_20191_().m_82400_(10.0));
        if (!list.isEmpty()) {
            if (this.getFollowDuration() > 0) {
                int size = 8;
                Vec3 targetPos = ((EntityWhaleshark)list.get(0)).m_20182_().m_82520_(Math.random() * (double)size, Math.random() * (double)size, Math.random() * (double)size);
                ((BoidMoveControl)this.m_21566_()).setForceTarget(targetPos);
                this.setFollowDuration(this.getFollowDuration() - 1);
            } else {
                ((BoidMoveControl)this.m_21566_()).setForceTarget(false);
            }
        } else {
            ((BoidMoveControl)this.m_21566_()).setForceTarget(false);
            this.setFollowDuration(1200);
        }
    }

    protected void m_7324_(Entity p_20971_) {
        if (!(p_20971_ instanceof EntityWhaleshark)) {
            super.m_7324_(p_20971_);
        }
    }

    @Override
    public void m_7380_(CompoundTag p_21484_) {
        super.m_7380_(p_21484_);
        p_21484_.m_128405_("FollowDuration", this.getFollowDuration());
    }

    @Override
    public void m_7378_(CompoundTag p_21450_) {
        super.m_7378_(p_21450_);
        if (p_21450_.m_128441_("FollowDuration")) {
            this.setFollowDuration(p_21450_.m_128451_("FollowDuration"));
        }
    }

    public InteractionResult m_6071_(Player p_27477_, InteractionHand p_27478_) {
        return Bucketable.m_148828_((Player)p_27477_, (InteractionHand)p_27478_, (LivingEntity)this).orElse(super.m_6071_(p_27477_, p_27478_));
    }

    public void m_6872_(ItemStack p_27494_) {
        Bucketable.m_148822_((Mob)this, (ItemStack)p_27494_);
        this.m_7380_(p_27494_.m_41784_());
    }

    public void m_142278_(CompoundTag p_148708_) {
        Bucketable.m_148825_((Mob)this, (CompoundTag)p_148708_);
        this.m_7378_(p_148708_);
    }

    public boolean m_27487_() {
        return (Boolean)this.f_19804_.m_135370_(FROM_BUCKET);
    }

    public void m_27497_(boolean p_148834_) {
        this.f_19804_.m_135381_(FROM_BUCKET, (Object)p_148834_);
    }

    public ItemStack m_28282_() {
        return new ItemStack((ItemLike)OceanicItems.MACKEREL_FISH_BUCKET.get());
    }

    public SoundEvent m_142623_() {
        return SoundEvents.f_11782_;
    }

    public void setFollowDuration(int value) {
        this.f_19804_.m_135381_(FOLLOW_DURATION, (Object)value);
    }

    public int getFollowDuration() {
        return (Integer)this.f_19804_.m_135370_(FOLLOW_DURATION);
    }
}

