/*
 * Decompiled with CFR 0.152.
 */
package com.min01.oceanicrealms.entity;

import com.min01.oceanicrealms.entity.AbstractAnimatableWaterAnimal;
import com.min01.oceanicrealms.entity.AgeableWaterAnimal;
import com.min01.oceanicrealms.entity.ai.control.OceanicSwimmingMoveControl;
import com.min01.oceanicrealms.util.OceanicUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;

public abstract class AbstractOceanicCreature
extends AbstractAnimatableWaterAnimal {
    private float rollAngle = 0.0f;

    public AbstractOceanicCreature(EntityType<? extends AgeableWaterAnimal> p_33002_, Level p_33003_) {
        super(p_33002_, p_33003_);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.f_21342_ = new OceanicSwimmingMoveControl((Mob)this, 85, 0.5f, 0.1f, false);
        this.f_21365_ = new SmoothSwimmingLookControl((Mob)this, 10);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(4, (Goal)new RandomSwimmingGoal((PathfinderMob)this, this.m_21172_(Attributes.f_22279_), 10){

            public boolean m_8036_() {
                return super.m_8036_() && AbstractOceanicCreature.this.canRandomSwim();
            }
        });
    }

    protected PathNavigation m_6037_(Level p_27480_) {
        return new WaterBoundPathNavigation((Mob)this, p_27480_);
    }

    public AgeableMob m_142606_(ServerLevel p_146743_, AgeableMob p_146744_) {
        return null;
    }

    @Override
    public void m_6075_() {
        super.m_6075_();
        if (this.m_20069_()) {
            Vec3 movement = this.m_20184_();
            float speed = (float)movement.m_82553_();
            if (speed > 0.01f) {
                float targetRoll = (float)Math.toDegrees(Math.atan2(movement.f_82479_, movement.f_82481_)) * 0.1f;
                this.rollAngle += (targetRoll - this.rollAngle) * 0.05f;
            } else {
                this.rollAngle *= 0.9f;
            }
        }
    }

    public float getRollAngle() {
        return this.rollAngle;
    }

    public int m_5792_() {
        return 100;
    }

    public static boolean checkFishSpawnRules(EntityType<? extends AbstractOceanicCreature> type, ServerLevelAccessor pServerLevel, MobSpawnType pMobSpawnType, BlockPos pPos, RandomSource pRandom) {
        return pServerLevel.m_6425_(pPos.m_7495_()).m_205070_(FluidTags.f_13131_) && pServerLevel.m_8055_(pPos.m_7494_()).m_60713_(Blocks.f_49990_) && pServerLevel.m_8055_(pPos.m_6630_(2)).m_60713_(Blocks.f_49990_);
    }

    public void m_7023_(Vec3 p_27490_) {
        if (this.m_21515_() && this.m_20069_()) {
            this.m_19920_(this.m_6113_(), p_27490_);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_((double)0.9f));
        } else {
            super.m_7023_(p_27490_);
        }
    }

    public void m_146922_(float p_146923_) {
        super.m_146922_(OceanicUtil.rotlerp(this.m_146908_(), p_146923_, this.getBodyRotationSpeed()));
    }

    public Vec3 getSwimRadius() {
        return new Vec3(35.0, 10.0, 35.0);
    }

    public int getBodyRotationSpeed() {
        return 10;
    }

    public boolean canRandomSwim() {
        return (!this.isUsingSkill() || this.m_5448_() == null) && this.m_21573_().m_26571_();
    }
}

