/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.integration.forge;

import dev.ftb.mods.ftblibrary.FTBLibraryClient;
import dev.ftb.mods.ftblibrary.config.ui.ResourceSearchMode;
import dev.ftb.mods.ftblibrary.config.ui.SelectItemStackScreen;
import dev.ftb.mods.ftblibrary.config.ui.SelectableResource;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.ItemIcon;
import dev.ftb.mods.ftblibrary.sidebar.SidebarGroupGuiButton;
import dev.ftb.mods.ftblibrary.ui.IScreenWrapper;
import dev.ftb.mods.ftblibrary.util.client.PositionedIngredient;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.handlers.IGlobalGuiHandler;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.runtime.IClickableIngredient;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.ModList;
import org.jetbrains.annotations.NotNull;

@JeiPlugin
public class JEIIntegration
implements IModPlugin,
IGlobalGuiHandler {
    public static IJeiRuntime runtime = null;
    private static final ResourceSearchMode<ItemStack> JEI_ITEMS = new ResourceSearchMode<ItemStack>(){

        @Override
        public Icon getIcon() {
            return ItemIcon.getItemIcon(Items.f_42410_);
        }

        @Override
        public MutableComponent getDisplayName() {
            return Component.m_237115_((String)"ftblibrary.select_item.list_mode.jei");
        }

        @Override
        public Collection<? extends SelectableResource<ItemStack>> getAllResources() {
            if (runtime == null) {
                return Collections.emptySet();
            }
            return runtime.getIngredientManager().getAllIngredients((IIngredientType)VanillaTypes.ITEM_STACK).stream().map(SelectableResource::item).toList();
        }
    };

    public void onRuntimeAvailable(IJeiRuntime r) {
        runtime = r;
    }

    @NotNull
    public ResourceLocation getPluginUid() {
        return new ResourceLocation("ftblibrary", "jei");
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        if (ModList.get().isLoaded("roughlyenoughitems")) {
            return;
        }
        registration.addGlobalGuiHandler((IGlobalGuiHandler)this);
    }

    @NotNull
    public Collection<Rect2i> getGuiExtraAreas() {
        Screen currentScreen = Minecraft.m_91087_().f_91080_;
        if (FTBLibraryClient.areButtonsVisible(currentScreen)) {
            return Collections.singleton(SidebarGroupGuiButton.lastDrawnArea);
        }
        return Collections.emptySet();
    }

    public Optional<IClickableIngredient<?>> getClickableIngredientUnderMouse(double mouseX, double mouseY) {
        IScreenWrapper wrapper;
        Screen currentScreen = Minecraft.m_91087_().f_91080_;
        if (currentScreen instanceof IScreenWrapper && (wrapper = (IScreenWrapper)currentScreen).getGui().getIngredientUnderMouse().isPresent()) {
            PositionedIngredient underMouse = wrapper.getGui().getIngredientUnderMouse().get();
            Object object = underMouse.ingredient();
            if (object instanceof ItemStack) {
                ItemStack stack = (ItemStack)object;
                typed = runtime.getIngredientManager().createTypedIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)stack);
                if (((Optional)typed).isPresent()) {
                    return Optional.of(new ClickableIngredient((ITypedIngredient)((Optional)typed).get(), underMouse.area()));
                }
            } else {
                typed = underMouse.ingredient();
                if (typed instanceof FluidStack) {
                    FluidStack stack = (FluidStack)typed;
                    typed = runtime.getIngredientManager().createTypedIngredient((IIngredientType)ForgeTypes.FLUID_STACK, (Object)stack);
                    if (((Optional)typed).isPresent()) {
                        return Optional.of(new ClickableIngredient((ITypedIngredient)((Optional)typed).get(), underMouse.area()));
                    }
                }
            }
        }
        return Optional.empty();
    }

    static {
        if (!ModList.get().isLoaded("roughlyenoughitems")) {
            SelectItemStackScreen.KNOWN_MODES.prependMode(JEI_ITEMS);
        }
    }

    private record ClickableIngredient<T>(ITypedIngredient<T> typedStack, Rect2i clickedArea) implements IClickableIngredient<T>
    {
        public ITypedIngredient<T> getTypedIngredient() {
            return this.typedStack;
        }

        public Rect2i getArea() {
            return this.clickedArea;
        }
    }
}

