/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.world.everdawn.gen.features.cave;

import com.legacy.blue_skies.registries.SkiesFeatures;
import com.legacy.blue_skies.util.GeometryHelper;
import com.legacy.blue_skies.world.general_features.cave.AbstractCaveFeature;
import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class CaveMagmaFeature
extends AbstractCaveFeature<NoneFeatureConfiguration> {
    public CaveMagmaFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    @Override
    public boolean generate(WorldGenLevel world, ChunkGenerator chunkGen, RandomSource rand, BlockPos pos, NoneFeatureConfiguration config) {
        pos = new BlockPos(pos.m_123341_(), 10, pos.m_123343_());
        int width = rand.m_188503_(6) + 5;
        int height = rand.m_188503_(7) + 6;
        int depth = rand.m_188503_(6) + 5;
        for (int x = -width; x <= width; ++x) {
            for (int z = -depth; z <= depth; ++z) {
                for (int y = -height; y <= height; ++y) {
                    BlockPos offsetPos;
                    if (!GeometryHelper.isInEllipsoid(width, height, depth, x, y, z) || !SkiesFeatures.Carvers.CARVABLE_BLOCKS.contains(world.m_8055_(offsetPos = pos.m_7918_(x, y, z)).m_60734_())) continue;
                    float chance = y <= 1 ? 1.0f : ((float)y <= (float)height / 2.0f ? 0.25f : 0.05f);
                    if (!(rand.m_188501_() < chance)) continue;
                    this.m_5974_((LevelWriter)world, offsetPos, Blocks.f_50450_.m_49966_());
                }
            }
        }
        return true;
    }

    @Override
    public boolean isValidPos(WorldGenLevel world, ChunkGenerator chunkGen, RandomSource rand, BlockPos pos, NoneFeatureConfiguration config) {
        return world.m_6425_(new BlockPos(pos.m_123341_(), 10, pos.m_123343_())).m_205070_(FluidTags.f_13132_);
    }
}

