/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.world.everdawn.gen.features;

import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.world.general_features.AbstractSkyTreeFeature;
import com.mojang.serialization.Codec;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;

public class LunarTreeFeature
extends AbstractSkyTreeFeature {
    private static final BlockState LOG = SkiesBlocks.lunar_log.m_49966_();
    private static final BlockState LOG_X = (BlockState)LOG.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.X);
    private static final BlockState LOG_Z = (BlockState)LOG.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.Z);
    private static final BlockState LEAF = SkiesBlocks.lunar_leaves.m_49966_();
    private int minTreeHeight;

    public LunarTreeFeature(Codec<TreeConfiguration> config, int minTreeHeightIn) {
        super(config, true);
        this.minTreeHeight = minTreeHeightIn;
    }

    @Override
    public boolean place(WorldGenLevel world, RandomSource rand, BlockPos pos, BiConsumer<BlockPos, BlockState> changedLogs, BiConsumer<BlockPos, BlockState> changedLeaves) {
        int i;
        int height = rand.m_188503_(3) + this.minTreeHeight;
        if (!this.isAreaOk(world, pos, height, 1, 3, 7)) {
            return false;
        }
        for (int y = 0; y < height; ++y) {
            this.setBlockIfOk(changedLogs, world, pos.m_6630_(y), LOG);
        }
        this.setLeafBall(changedLeaves, world, rand, pos.m_7918_(0, height - 2, 0));
        int iPosX = height - 4 - rand.m_188503_(3);
        int iNegX = height - 4 - rand.m_188503_(3);
        int iPosZ = height - 4 - rand.m_188503_(3);
        int iNegZ = height - 4 - rand.m_188503_(3);
        for (i = 1; i <= 3; ++i) {
            this.setBlockIfOk(changedLogs, world, pos.m_7918_(i, iPosX + i, 0), LOG_X);
            this.setBlockIfOk(changedLogs, world, pos.m_7918_(0, iPosZ + i, i), LOG_Z);
            if (i != 3) continue;
            this.setLeafBall(changedLeaves, world, rand, pos.m_7918_(i, iPosX + 2, 0));
            this.setLeafBall(changedLeaves, world, rand, pos.m_7918_(0, iPosZ + 2, i));
        }
        for (i = -1; i >= -3; --i) {
            this.setBlockIfOk(changedLogs, world, pos.m_7918_(i, iNegX - i, 0), LOG_X);
            this.setBlockIfOk(changedLogs, world, pos.m_7918_(0, iNegZ - i, i), LOG_Z);
            if (i != -3) continue;
            this.setLeafBall(changedLeaves, world, rand, pos.m_7918_(i, iNegX + 2, 0));
            this.setLeafBall(changedLeaves, world, rand, pos.m_7918_(0, iNegZ + 2, i));
        }
        return true;
    }

    protected void setLeafBall(BiConsumer<BlockPos, BlockState> changedLeaves, WorldGenLevel world, RandomSource rand, BlockPos pos) {
        int i;
        for (int y = 0; y <= 2; ++y) {
            this.setBlockIfOk(changedLeaves, world, pos.m_7918_(0, y, 0), LEAF);
            for (int i2 = -1; i2 <= 1; i2 += 2) {
                this.setBlockIfOk(changedLeaves, world, pos.m_7918_(i2, y, 0), LEAF);
                this.setBlockIfOk(changedLeaves, world, pos.m_7918_(0, y, i2), LEAF);
            }
        }
        for (i = -1; i <= 1; i += 2) {
            this.setBlockIfOk(changedLeaves, world, pos.m_7918_(i, 1, i), LEAF);
            this.setBlockIfOk(changedLeaves, world, pos.m_7918_(i, 1, -i), LEAF);
        }
        for (i = -2; i <= 2; i += 4) {
            this.setBlockIfOk(changedLeaves, world, pos.m_7918_(i, 1, 0), LEAF);
            this.setBlockIfOk(changedLeaves, world, pos.m_7918_(0, 1, i), LEAF);
        }
    }
}

