/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.util;

import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.phys.Vec3;

public final class GeometryHelper {
    public static void drawParticleLine(ServerLevel world, ParticleOptions particle, Vec3 firstPos, Vec3 secondPos, double particleSpacing, double particleSpeed, boolean forced) {
        GeometryHelper.drawParticleLine(world, particle, firstPos, secondPos, particleSpacing, particleSpeed, Vec3.f_82478_, forced);
    }

    public static void drawParticleLine(ServerLevel world, ParticleOptions particle, Vec3 firstPos, Vec3 secondPos, double particleSpacing, double particleSpeed, Vec3 particleOffset, boolean forced) {
        if (particleSpacing == 0.0) {
            particleSpacing = 0.1;
        }
        Vec3 angle = GeometryHelper.calcAngle(firstPos, secondPos);
        double magnitude = GeometryHelper.calcDistance(firstPos, secondPos);
        if (magnitude == 0.0) {
            magnitude = 1.0E-4;
        }
        double intervalX = angle.m_7096_() / magnitude * particleSpacing;
        double intervalY = angle.m_7098_() / magnitude * particleSpacing;
        double intervalZ = angle.m_7094_() / magnitude * particleSpacing;
        for (double i = 0.0; i <= magnitude / particleSpacing; i += 1.0) {
            if (forced) {
                for (ServerPlayer p : world.m_6907_()) {
                    world.m_8624_(p, particle, true, firstPos.m_7096_() - intervalX * i, firstPos.m_7098_() - intervalY * i, firstPos.m_7094_() - intervalZ * i, 1, particleOffset.m_7096_(), particleOffset.m_7098_(), particleOffset.m_7094_(), particleSpeed);
                }
                continue;
            }
            world.m_8767_(particle, firstPos.m_7096_() - intervalX * i, firstPos.m_7098_() - intervalY * i, firstPos.m_7094_() - intervalZ * i, 1, particleOffset.m_7096_(), particleOffset.m_7098_(), particleOffset.m_7094_(), particleSpeed);
        }
    }

    public static double calcDistance(Vec3 firstPos, Vec3 secondPos) {
        double x = GeometryHelper.calcExponent(firstPos.m_7096_() - secondPos.m_7096_());
        double y = GeometryHelper.calcExponent(firstPos.m_7098_() - secondPos.m_7098_());
        double z = GeometryHelper.calcExponent(firstPos.m_7094_() - secondPos.m_7094_());
        double dist = Math.sqrt(x + y + z);
        return dist;
    }

    public static double calcDistance(int x1, int z1, int x2, int z2) {
        double x = GeometryHelper.calcExponent(x2 - x1);
        double z = GeometryHelper.calcExponent(z2 - z1);
        double dist = Math.sqrt(x + z);
        return dist;
    }

    public static Vec3 calcAngle(Vec3 firstPos, Vec3 secondPos) {
        double x = firstPos.m_7096_() - secondPos.m_7096_();
        double y = firstPos.m_7098_() - secondPos.m_7098_();
        double z = firstPos.m_7094_() - secondPos.m_7094_();
        return new Vec3(x, y, z);
    }

    public static double calcAngleRad(double arcLength, double radius, double multiplier) {
        if (radius == 0.0) {
            radius = 1.0E-4;
        }
        double angle = arcLength * multiplier / radius;
        return angle;
    }

    public static double calcExponent(double i) {
        return i * i;
    }

    public static boolean isPointInsideRec(Vec3i pos, Vec3i minPos, Vec3i maxPos) {
        return pos.m_123341_() >= minPos.m_123341_() && pos.m_123341_() <= maxPos.m_123341_() && pos.m_123343_() >= minPos.m_123343_() && pos.m_123343_() <= maxPos.m_123343_() && pos.m_123342_() >= minPos.m_123342_() && pos.m_123342_() <= maxPos.m_123342_();
    }

    public static boolean isInEllipsoid(double a, double b, double c, double x, double y, double z) {
        return ((x = a - x / 2.0) - a) * (x - a) / a + ((y = b - y / 2.0) - b) * (y - b) / b + ((z = c - z / 2.0) - c) * (z - c) / c < 1.0;
    }
}

