/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.registries;

import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.structure_gel.api.registry.registrar.Registrar;
import com.legacy.structure_gel.api.registry.registrar.RegistrarHandler;
import java.util.Arrays;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegisterEvent;

public class SkiesPoiTypes {
    public static final RegistrarHandler<PoiType> HANDLER = RegistrarHandler.getOrCreate((ResourceKey)ForgeRegistries.Keys.POI_TYPES, (String)"blue_skies");
    public static final Registrar.Static<PoiType> STAR_EMITTER = SkiesPoiTypes.basic("star_emitter", () -> SkiesBlocks.star_emitter);
    public static final Registrar.Static<PoiType> TROUGH = SkiesPoiTypes.basic("trough", () -> SkiesBlocks.trough);
    public static final Registrar.Static<PoiType> TOOL_BOX = SkiesPoiTypes.basic("tool_box", () -> SkiesBlocks.tool_box);
    public static final Registrar.Static<PoiType> BAG_OF_SPOILS = SkiesPoiTypes.basic("bag_of_spoils", () -> SkiesBlocks.bag_of_spoils);
    public static final Registrar.Static<PoiType> SUMMONING_TABLE = SkiesPoiTypes.basic("summoning_table", () -> SkiesBlocks.summoning_table);
    public static final Registrar.Static<PoiType> ALCHEMY_TABLE = SkiesPoiTypes.basic("alchemy_table", () -> SkiesBlocks.alchemy_table);
    public static final Registrar.Static<PoiType> EVERBRIGHT_PORTAL = SkiesPoiTypes.withTicketCount("everbright_portal", () -> SkiesBlocks.everbright_portal, 0);
    public static final Registrar.Static<PoiType> EVERDAWN_PORTAL = SkiesPoiTypes.withTicketCount("everdawn_portal", () -> SkiesBlocks.everdawn_portal, 0);
    public static final Registrar.Static<PoiType> SPIDER_NEST = SkiesPoiTypes.withTicketCount("spider_nest", () -> SkiesBlocks.spider_nest, 0);
    public static final Registrar.Static<PoiType> KEYSTONE = HANDLER.createStatic("keystone", () -> new PoiType(SkiesPoiTypes.getAllStates(SkiesBlocks.bright_blinding_keystone, SkiesBlocks.dawn_blinding_keystone, SkiesBlocks.nature_keystone, SkiesBlocks.poison_keystone), 0, 1));
    public static final Registrar.Static<PoiType> WARDING_PEARL = HANDLER.createStatic("warding_pearl", () -> new PoiType(SkiesPoiTypes.getAllStates(SkiesBlocks.warding_pearl, SkiesBlocks.wall_warding_pearl), 0, 1));

    public static void init(RegisterEvent event) {
        HANDLER.registerValues(event);
    }

    private static Registrar.Static<PoiType> withTicketCount(String name, Supplier<Block> block, int ticket) {
        return HANDLER.createStatic(name, () -> new PoiType(SkiesPoiTypes.getAllStates((Block)block.get()), ticket, 1));
    }

    private static Registrar.Static<PoiType> basic(String name, Supplier<Block> block) {
        return SkiesPoiTypes.withTicketCount(name, block, 1);
    }

    private static Set<BlockState> getAllStates(Block block) {
        return Set.copyOf(block.m_49965_().m_61056_());
    }

    public static Set<BlockState> getAllStates(Block ... blocks) {
        return Arrays.stream(blocks).flatMap(b -> SkiesPoiTypes.getAllStates(b).stream()).collect(Collectors.toSet());
    }
}

