/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.registries;

import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.data.objects.tags.SkiesBlockTags;
import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.registries.SkiesFeatures;
import com.legacy.structure_gel.api.registry.registrar.RegistrarHandler;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.valueproviders.ConstantFloat;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.util.valueproviders.TrapezoidFloat;
import net.minecraft.util.valueproviders.UniformFloat;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.carver.CanyonCarverConfiguration;
import net.minecraft.world.level.levelgen.carver.CarverConfiguration;
import net.minecraft.world.level.levelgen.carver.CarverDebugSettings;
import net.minecraft.world.level.levelgen.carver.CaveCarverConfiguration;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.heightproviders.BiasedToBottomHeight;
import net.minecraft.world.level.levelgen.heightproviders.ConstantHeight;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;

public class SkiesConfiguredCarvers {
    public static final RegistrarHandler<ConfiguredWorldCarver<?>> HANDLER = RegistrarHandler.getOrCreate((ResourceKey)Registries.f_257003_, (String)"blue_skies").bootstrap(c -> SkiesConfiguredCarvers.bootstrap(c));
    public static final ResourceKey<ConfiguredWorldCarver<?>> SKY_NOISE_CARVER = SkiesConfiguredCarvers.createKey("sky_noise_carver");
    public static final ResourceKey<ConfiguredWorldCarver<?>> SKY_CAVE_CARVER = SkiesConfiguredCarvers.createKey("sky_cave_carver");
    public static final ResourceKey<ConfiguredWorldCarver<?>> SKY_CANYON_CARVER = SkiesConfiguredCarvers.createKey("sky_canyon_carver");
    public static final ResourceKey<ConfiguredWorldCarver<?>> EVERBRIGHT_NOISE_CARVER = SkiesConfiguredCarvers.createKey("everbright_noise_carver");
    public static final ResourceKey<ConfiguredWorldCarver<?>> EVERBRIGHT_CAVE_CARVER = SkiesConfiguredCarvers.createKey("everbright_cave_carver");
    public static final ResourceKey<ConfiguredWorldCarver<?>> EVERBRIGHT_CANYON_CARVER = SkiesConfiguredCarvers.createKey("everbright_canyon_carver");

    private static ResourceKey<ConfiguredWorldCarver<?>> createKey(String key) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_257003_, (ResourceLocation)BlueSkies.locate(key));
    }

    public static void bootstrap(BootstapContext<ConfiguredWorldCarver<?>> bootstrap) {
        HolderGetter blockGetter = bootstrap.m_255420_(Registries.f_256747_);
        CarverConfiguration dummyConfig = new CarverConfiguration(0.0f, (HeightProvider)ConstantHeight.m_161956_((VerticalAnchor)VerticalAnchor.m_158922_((int)0)), (FloatProvider)ConstantFloat.f_146451_, VerticalAnchor.m_158922_((int)0), CarverDebugSettings.f_159114_, (HolderSet)HolderSet.m_205809_((Holder[])new Holder[0]));
        CaveCarverConfiguration caveConfig = new CaveCarverConfiguration(0.14285715f, (HeightProvider)BiasedToBottomHeight.m_161931_((VerticalAnchor)VerticalAnchor.m_158922_((int)0), (VerticalAnchor)VerticalAnchor.m_158922_((int)127), (int)8), (FloatProvider)ConstantFloat.m_146458_((float)0.5f), VerticalAnchor.m_158930_((int)10), (HolderSet)blockGetter.m_254956_(SkiesBlockTags.CARVER_REPLACEABLES), (FloatProvider)ConstantFloat.m_146458_((float)1.0f), (FloatProvider)ConstantFloat.m_146458_((float)1.0f), (FloatProvider)ConstantFloat.m_146458_((float)-0.7f));
        CanyonCarverConfiguration canyonConfig = new CanyonCarverConfiguration(0.02f, (HeightProvider)BiasedToBottomHeight.m_161931_((VerticalAnchor)VerticalAnchor.m_158922_((int)20), (VerticalAnchor)VerticalAnchor.m_158922_((int)67), (int)8), (FloatProvider)ConstantFloat.m_146458_((float)3.0f), VerticalAnchor.m_158930_((int)10), CarverDebugSettings.m_159136_((boolean)false, (BlockState)SkiesBlocks.lunar_button.m_49966_()), (HolderSet)blockGetter.m_254956_(SkiesBlockTags.CARVER_REPLACEABLES), (FloatProvider)UniformFloat.m_146605_((float)-0.125f, (float)0.125f), new CanyonCarverConfiguration.CanyonShapeConfiguration((FloatProvider)UniformFloat.m_146605_((float)0.75f, (float)1.0f), (FloatProvider)TrapezoidFloat.m_146571_((float)0.0f, (float)6.0f, (float)2.0f), 3, (FloatProvider)UniformFloat.m_146605_((float)0.75f, (float)1.0f), 1.0f, 0.0f));
        bootstrap.m_255272_(SKY_NOISE_CARVER, (Object)SkiesFeatures.Carvers.SKY_NOISE_CARVER.m_65063_(dummyConfig));
        bootstrap.m_255272_(SKY_CAVE_CARVER, (Object)SkiesFeatures.Carvers.SKY_CAVE_CARVER.m_65063_((CarverConfiguration)caveConfig));
        bootstrap.m_255272_(SKY_CANYON_CARVER, (Object)SkiesFeatures.Carvers.SKY_CANYON_CARVER.m_65063_((CarverConfiguration)canyonConfig));
        bootstrap.m_255272_(EVERBRIGHT_NOISE_CARVER, (Object)SkiesFeatures.Carvers.EVERBRIGHT_NOISE_CARVER.m_65063_(dummyConfig));
        bootstrap.m_255272_(EVERBRIGHT_CAVE_CARVER, (Object)SkiesFeatures.Carvers.EVERBRIGHT_CAVE_CARVER.m_65063_((CarverConfiguration)caveConfig));
        bootstrap.m_255272_(EVERBRIGHT_CANYON_CARVER, (Object)SkiesFeatures.Carvers.EVERBRIGHT_CANYON_CARVER.m_65063_((CarverConfiguration)canyonConfig));
    }

    public static void addDawnCarvers(BiomeGenerationSettings.Builder builder) {
        builder.m_255308_(GenerationStep.Carving.AIR, SKY_CAVE_CARVER);
        builder.m_255308_(GenerationStep.Carving.AIR, SKY_CANYON_CARVER);
        builder.m_255308_(GenerationStep.Carving.AIR, SKY_NOISE_CARVER);
    }

    public static void addOceanCarvers(BiomeGenerationSettings.Builder builder) {
    }

    public static void addBrightCarvers(BiomeGenerationSettings.Builder builder) {
        builder.m_255308_(GenerationStep.Carving.AIR, EVERBRIGHT_CAVE_CARVER);
        builder.m_255308_(GenerationStep.Carving.AIR, EVERBRIGHT_CANYON_CARVER);
        builder.m_255308_(GenerationStep.Carving.AIR, EVERBRIGHT_NOISE_CARVER);
    }
}

