/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.client.models.entities.passive;

import com.legacy.blue_skies.entities.passive.CrystalCamelEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class CrystalCamelModel<T extends CrystalCamelEntity>
extends EntityModel<T> {
    protected final ModelPart body;
    protected final ModelPart leftHindLeg;
    protected final ModelPart leftFrontLeg;
    protected final ModelPart rightHindLeg;
    protected final ModelPart rightFrontLeg;
    protected final ModelPart snoot;
    protected final ModelPart neckBottom;
    protected final ModelPart leftEar;
    protected final ModelPart head;
    protected final ModelPart rightEar;
    protected final ModelPart neckTop;
    protected final ModelPart backHump;
    protected final ModelPart frontHump;
    protected final ModelPart saddleTop;
    protected final ModelPart saddleBottom;
    protected final ModelPart chest;
    public boolean saddled = false;
    public boolean chested = false;

    public CrystalCamelModel(ModelPart model) {
        this.neckBottom = model.m_171324_("neck_bottom");
        this.neckTop = this.neckBottom.m_171324_("neck_top");
        this.head = this.neckTop.m_171324_("head");
        this.rightEar = this.head.m_171324_("right_ear");
        this.leftEar = this.head.m_171324_("left_ear");
        this.snoot = this.head.m_171324_("snoot");
        this.body = model.m_171324_("body");
        this.frontHump = model.m_171324_("front_hump");
        this.backHump = model.m_171324_("back_hump");
        this.rightFrontLeg = model.m_171324_("right_front_leg");
        this.leftFrontLeg = model.m_171324_("left_front_leg");
        this.rightHindLeg = model.m_171324_("right_hind_leg");
        this.leftHindLeg = model.m_171324_("left_hind_leg");
        this.saddleTop = model.m_171324_("saddle_top");
        this.saddleBottom = this.saddleTop.m_171324_("saddle_bottom");
        this.chest = model.m_171324_("chest");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.m_171576_();
        PartDefinition neckBottom = root.m_171599_("neck_bottom", CubeListBuilder.m_171558_().m_171514_(0, 37).m_171481_(-3.0f, -3.5f, -9.5f, 6.0f, 5.0f, 8.0f), PartPose.m_171419_((float)0.0f, (float)7.0f, (float)-6.0f));
        PartDefinition neckTop = neckBottom.m_171599_("neck_top", CubeListBuilder.m_171558_().m_171514_(0, 22).m_171481_(-3.0f, -6.5f, -2.5f, 6.0f, 9.0f, 5.0f), PartPose.m_171419_((float)0.0f, (float)-2.0f, (float)-8.0f));
        PartDefinition head = neckTop.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 9).m_171481_(-3.0f, -5.0f, -3.5f, 6.0f, 5.0f, 7.0f), PartPose.m_171419_((float)0.0f, (float)-6.5f, (float)0.0f));
        head.m_171599_("right_ear", CubeListBuilder.m_171558_().m_171514_(17, 0).m_171480_().m_171481_(-1.0f, -1.5f, -1.25f, 2.0f, 2.0f, 2.0f), PartPose.m_171419_((float)-3.0f, (float)-4.5f, (float)1.75f));
        head.m_171599_("left_ear", CubeListBuilder.m_171558_().m_171514_(17, 0).m_171481_(-1.0f, -1.5f, -1.0f, 2.0f, 2.0f, 2.0f), PartPose.m_171419_((float)3.0f, (float)-4.5f, (float)1.5f));
        head.m_171599_("snoot", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-2.0f, -1.5f, -4.0f, 4.0f, 3.0f, 4.0f), PartPose.m_171419_((float)0.0f, (float)-1.5f, (float)-3.5f));
        root.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(29, 0).m_171481_(-6.0f, -10.0f, -7.0f, 12.0f, 18.0f, 10.0f), PartPose.m_171419_((float)0.0f, (float)5.0f, (float)2.0f));
        root.m_171599_("front_hump", CubeListBuilder.m_171558_().m_171514_(74, 0).m_171481_(-3.5f, -9.0f, 3.0f, 7.0f, 7.0f, 3.0f), PartPose.m_171423_((float)0.0f, (float)5.0f, (float)2.0f, (float)1.5708f, (float)0.0f, (float)0.0f));
        root.m_171599_("back_hump", CubeListBuilder.m_171558_().m_171514_(74, 0).m_171481_(-3.5f, 0.0f, 3.0f, 7.0f, 7.0f, 3.0f), PartPose.m_171423_((float)0.0f, (float)5.0f, (float)2.0f, (float)1.5708f, (float)0.0f, (float)0.0f));
        root.m_171599_("right_front_leg", CubeListBuilder.m_171558_().m_171514_(29, 29).m_171480_().m_171481_(-2.09f, 0.0f, -2.09f, 4.0f, 14.0f, 4.0f), PartPose.m_171419_((float)-3.9f, (float)10.0f, (float)-5.9f));
        root.m_171599_("left_front_leg", CubeListBuilder.m_171558_().m_171514_(29, 29).m_171481_(-1.91f, 0.0f, -2.09f, 4.0f, 14.0f, 4.0f), PartPose.m_171419_((float)3.9f, (float)10.0f, (float)-5.9f));
        root.m_171599_("right_hind_leg", CubeListBuilder.m_171558_().m_171514_(29, 29).m_171480_().m_171481_(-2.09f, 0.0f, -1.91f, 4.0f, 14.0f, 4.0f), PartPose.m_171419_((float)-3.9f, (float)10.0f, (float)7.9f));
        root.m_171599_("left_hind_leg", CubeListBuilder.m_171558_().m_171514_(29, 29).m_171481_(-1.91f, 0.0f, -1.91f, 4.0f, 14.0f, 4.0f), PartPose.m_171419_((float)3.9f, (float)10.0f, (float)7.9f));
        PartDefinition saddleTop = root.m_171599_("saddle_top", CubeListBuilder.m_171558_().m_171514_(80, 41).m_171481_(-5.5f, -2.0f, -5.5f, 10.0f, 3.0f, 13.0f), PartPose.m_171419_((float)0.5f, (float)0.0f, (float)0.0f));
        saddleTop.m_171599_("saddle_bottom", CubeListBuilder.m_171558_().m_171514_(73, 18).m_171481_(-7.5f, 1.0f, -5.5f, 14.0f, 7.0f, 13.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        root.m_171599_("chest", CubeListBuilder.m_171558_().m_171514_(33, 49).m_171481_(-7.75f, -5.0f, -2.25f, 16.0f, 8.0f, 7.0f), PartPose.m_171419_((float)0.0f, (float)1.0f, (float)7.75f));
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)128, (int)64);
    }

    public Iterable<ModelPart> getCamelLegParts() {
        return List.of(this.rightHindLeg, this.leftHindLeg, this.rightFrontLeg, this.leftFrontLeg);
    }

    public Iterable<ModelPart> getCamelBodyParts() {
        return List.of(this.body, this.frontHump, this.backHump);
    }

    public Iterable<ModelPart> getCamelHeadParts() {
        return List.of(this.neckBottom);
    }

    public void setupAnim(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        boolean local = entityIn.m_6109_();
        if (local) {
            limbSwing *= 0.6f;
        }
        this.neckBottom.f_104203_ = headPitch * ((float)Math.PI / 180) + Mth.m_14089_((float)(limbSwing * 0.6662f)) * (local ? 0.05f : 0.08f) * limbSwingAmount;
        this.neckBottom.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.body.f_104203_ = 1.5707964f;
        float legSwing = 1.0f;
        this.leftFrontLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * legSwing * limbSwingAmount;
        this.rightFrontLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * legSwing * limbSwingAmount;
        this.leftHindLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * legSwing * limbSwingAmount;
        this.rightHindLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * legSwing * limbSwingAmount;
    }

    public void m_7695_(PoseStack matrixStackIn, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        if (this.f_102610_) {
            matrixStackIn.m_85836_();
            matrixStackIn.m_85841_(0.71428573f, 0.64935064f, 0.7936508f);
            matrixStackIn.m_85837_(0.0, 1.3125, (double)0.22f);
            this.getCamelHeadParts().forEach(model -> model.m_104306_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha));
            matrixStackIn.m_85849_();
            matrixStackIn.m_85836_();
            matrixStackIn.m_85841_(0.625f, 0.45454544f, 0.45454544f);
            matrixStackIn.m_85837_(0.0, 2.0625, 0.0);
            this.getCamelBodyParts().forEach(model -> model.m_104306_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha));
            matrixStackIn.m_85849_();
            matrixStackIn.m_85836_();
            matrixStackIn.m_85841_(0.45454544f, 0.41322312f, 0.45454544f);
            matrixStackIn.m_85837_(0.0, 2.0625, 0.0);
            this.getCamelLegParts().forEach(model -> model.m_104306_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha));
            matrixStackIn.m_85849_();
        } else {
            this.getCamelLegParts().forEach(model -> model.m_104306_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha));
            this.getCamelBodyParts().forEach(model -> model.m_104306_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha));
            this.getCamelHeadParts().forEach(model -> model.m_104306_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha));
            if (this.saddled) {
                this.saddleTop.m_104306_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
            }
            if (this.chested) {
                this.chest.m_104306_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
            }
        }
    }
}

