/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.client.models.entities.hostile;

import com.legacy.blue_skies.client.SkiesClientUtil;
import com.legacy.blue_skies.entities.hostile.PolargeistEntity;
import java.util.List;
import net.minecraft.client.model.ListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.util.Mth;

public class PolargeistModel<T extends PolargeistEntity>
extends ListModel<T> {
    protected final ModelPart body;
    protected final ModelPart bodyMid;
    protected final ModelPart bodyIceBottom;
    protected final ModelPart head;
    protected final ModelPart snout;
    protected final ModelPart rightEar;
    protected final ModelPart leftEar;
    protected final ModelPart rightFrontLeg;
    protected final ModelPart leftFrontLeg;
    protected final ModelPart leftHindLeg;
    protected final ModelPart rightHindLeg;

    public PolargeistModel(ModelPart model) {
        super(RenderType::m_110470_);
        this.head = model.m_171324_("head");
        this.rightEar = this.head.m_171324_("right_ear");
        this.leftEar = this.head.m_171324_("left_ear");
        this.snout = this.head.m_171324_("snout");
        this.body = model.m_171324_("body");
        this.bodyMid = this.body.m_171324_("body_middle");
        this.bodyIceBottom = this.body.m_171324_("body_ice_bottom");
        this.rightFrontLeg = model.m_171324_("right_front_leg");
        this.leftFrontLeg = model.m_171324_("left_front_leg");
        this.rightHindLeg = model.m_171324_("right_hind_leg");
        this.leftHindLeg = model.m_171324_("left_hind_leg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.m_171576_();
        PartDefinition head = root.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-5.0f, -4.0f, -8.0f, 10.0f, 8.0f, 8.0f), PartPose.m_171419_((float)0.0f, (float)9.0f, (float)-14.0f));
        head.m_171599_("snout", CubeListBuilder.m_171558_().m_171514_(15, 16).m_171481_(-3.0f, -15.0f, -25.0f, 6.0f, 4.0f, 3.0f).m_171514_(82, 57).m_171481_(-3.0f, -11.0f, -25.0f, 6.0f, 4.0f, 3.0f), PartPose.m_171419_((float)0.0f, (float)15.0f, (float)14.0f));
        head.m_171599_("right_ear", CubeListBuilder.m_171558_().m_171514_(28, 3).m_171480_().m_171481_(-6.0f, -20.0f, -20.0f, 3.0f, 3.0f, 2.0f), PartPose.m_171419_((float)0.0f, (float)15.0f, (float)14.0f));
        head.m_171599_("left_ear", CubeListBuilder.m_171558_().m_171514_(28, 3).m_171481_(3.0f, -20.0f, -20.0f, 3.0f, 3.0f, 2.0f), PartPose.m_171419_((float)0.0f, (float)15.0f, (float)14.0f));
        PartDefinition body = root.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 24).m_171481_(-7.5f, -23.0f, -14.0f, 15.0f, 14.0f, 26.0f), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        body.m_171599_("body_middle", CubeListBuilder.m_171558_().m_171514_(56, 22).m_171481_(-8.5f, -24.0f, -5.0f, 17.0f, 15.0f, 13.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        body.m_171599_("body_ice_bottom", CubeListBuilder.m_171558_().m_171514_(40, 0).m_171481_(-8.5f, -9.0f, -5.0f, 17.0f, 5.0f, 13.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        root.m_171599_("right_front_leg", CubeListBuilder.m_171558_().m_171514_(0, 18).m_171480_().m_171481_(-2.0f, -1.0f, -2.5f, 5.0f, 11.0f, 5.0f), PartPose.m_171419_((float)-5.0f, (float)14.0f, (float)-7.5f));
        root.m_171599_("left_front_leg", CubeListBuilder.m_171558_().m_171514_(0, 18).m_171481_(-3.0f, -1.0f, -2.5f, 5.0f, 11.0f, 5.0f), PartPose.m_171419_((float)5.0f, (float)14.0f, (float)-7.5f));
        root.m_171599_("right_hind_leg", CubeListBuilder.m_171558_().m_171514_(0, 34).m_171480_().m_171481_(-2.5f, 0.0f, -4.0f, 5.0f, 9.0f, 7.0f), PartPose.m_171419_((float)-5.0f, (float)15.0f, (float)9.0f));
        root.m_171599_("left_hind_leg", CubeListBuilder.m_171558_().m_171514_(0, 34).m_171481_(-2.5f, 0.0f, -4.0f, 5.0f, 9.0f, 7.0f), PartPose.m_171419_((float)5.0f, (float)15.0f, (float)9.0f));
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)128, (int)64);
    }

    public Iterable<ModelPart> m_6195_() {
        return List.of(this.head, this.body, this.rightFrontLeg, this.leftFrontLeg, this.leftHindLeg, this.rightHindLeg);
    }

    public void setupAnim(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.f_104203_ = headPitch * ((float)Math.PI / 180);
        this.head.f_104204_ = SkiesClientUtil.lockNum(netHeadYaw * ((float)Math.PI / 180), 0.9f);
        this.head.f_104205_ = 0.0f;
        this.body.m_104227_(0.0f, 24.0f, 0.0f);
        this.setRotationAngle(this.body, 0.0f, 0.0f, 0.0f);
        this.head.m_104227_(0.0f, 9.0f, -14.0f);
        float f = ageInTicks - (float)((PolargeistEntity)((Object)entityIn)).f_19797_;
        float f1 = ((PolargeistEntity)((Object)entityIn)).getStandingAnimationScale(f);
        f1 *= f1;
        float f2 = 1.0f - f1;
        this.rightFrontLeg.f_104203_ = ((PolargeistEntity)((Object)entityIn)).isStanding() ? 0.0f : Mth.m_14089_((float)((float)((double)(limbSwing * 0.6662f) + Math.PI))) * 1.4f * limbSwingAmount;
        this.rightHindLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.leftFrontLeg.f_104203_ = ((PolargeistEntity)((Object)entityIn)).isStanding() ? 0.0f : Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.leftHindLeg.f_104203_ = Mth.m_14089_((float)((float)((double)(limbSwing * 0.6662f) + Math.PI))) * 1.4f * limbSwingAmount;
        this.body.f_104203_ = -0.004203677f - f1;
        float lowerAmount = 13.0f;
        this.body.f_104201_ = 24.0f * f2 + lowerAmount * f1;
        this.body.f_104202_ = 0.0f * -f2 + 8.0f * -f1;
        this.rightFrontLeg.f_104201_ = 14.0f * f2 - 2.0f * f1;
        this.rightFrontLeg.f_104202_ = -10.0f * f2 - 4.0f * f1;
        this.rightFrontLeg.f_104203_ = this.rightFrontLeg.f_104203_ - (f1 * (float)Math.PI * 0.45f + (((PolargeistEntity)((Object)entityIn)).isStanding() ? Mth.m_14089_((float)(ageInTicks * 0.6f)) * 0.2f : 0.0f));
        this.leftFrontLeg.f_104201_ = this.rightFrontLeg.f_104201_;
        this.leftFrontLeg.f_104202_ = this.rightFrontLeg.f_104202_;
        this.leftFrontLeg.f_104203_ = this.leftFrontLeg.f_104203_ - (f1 * (float)Math.PI * 0.45f + (((PolargeistEntity)((Object)entityIn)).isStanding() ? Mth.m_14089_((float)(3.0f + ageInTicks * 0.6f)) * 0.2f : 0.0f));
        this.head.f_104201_ = 9.0f * f2 - 10.0f * f1;
        this.head.f_104202_ = -14.0f * f2 - 3.0f * f1;
        this.head.f_104203_ += f1 * (float)Math.PI * 0.15f;
    }

    public void setRotationAngle(ModelPart modelRenderer, float x, float y, float z) {
        modelRenderer.f_104203_ = x;
        modelRenderer.f_104204_ = y;
        modelRenderer.f_104205_ = z;
    }
}

