/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.blocks.natural;

import com.legacy.blue_skies.data.BlueSkiesData;
import com.legacy.blue_skies.registries.SkiesConfiguredFeatures;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.level.SaplingGrowTreeEvent;
import net.minecraftforge.eventbus.api.Event;

public class SnowcapMushroomBlock
extends DoublePlantBlock
implements BonemealableBlock {
    private static final VoxelShape STEM_BOUNDS = Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    private static final VoxelShape CAP_COLLISION = Block.m_49796_((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)13.0, (double)16.0);
    private static final VoxelShape CAP_BOUNDS = Shapes.m_83110_((VoxelShape)CAP_COLLISION, (VoxelShape)Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)12.0, (double)10.0));

    public SnowcapMushroomBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.getShape(state, level, pos, CAP_BOUNDS, STEM_BOUNDS);
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.getShape(state, level, pos, CAP_COLLISION, Shapes.m_83040_());
    }

    public VoxelShape m_7952_(BlockState state, BlockGetter level, BlockPos pos) {
        return Shapes.m_83040_();
    }

    private VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, VoxelShape upperShape, VoxelShape lowerShape) {
        boolean isUpper = state.m_61143_((Property)f_52858_) == DoubleBlockHalf.UPPER;
        Vec3 offset = isUpper ? state.m_60824_(level, pos) : level.m_8055_(pos.m_7494_()).m_60824_(level, pos.m_7494_());
        return (isUpper ? upperShape : lowerShape).m_83216_(offset.f_82479_, offset.f_82480_, offset.f_82481_);
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        if (state.m_61143_((Property)f_52858_) == DoubleBlockHalf.LOWER) {
            return super.m_7898_(state, level, pos) || level.m_8055_(pos.m_7495_()).m_204336_(BlockTags.f_13057_);
        }
        BlockState lowerState = level.m_8055_(pos.m_7495_());
        if (state.m_60734_() != this) {
            return super.m_7898_(state, level, pos);
        }
        return lowerState.m_60734_() == this && lowerState.m_61143_((Property)f_52858_) == DoubleBlockHalf.LOWER;
    }

    public boolean m_6724_(BlockState state) {
        return state.m_61143_((Property)f_52858_) == DoubleBlockHalf.LOWER;
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!level.f_46443_) {
            SnowcapMushroomBlock.freezeBlocks((Level)level, pos, random);
        }
    }

    public static void freezeBlocks(Level level, BlockPos pos, RandomSource rand) {
        BlockPos randPos = new BlockPos(pos.m_123341_() + rand.m_188503_(3) - 1, pos.m_123342_() - rand.m_188503_(2), pos.m_123343_() + rand.m_188503_(3) - 1);
        BlockState stateAtPos = level.m_8055_(randPos);
        BlockState frozenState = BlueSkiesData.SNOWCAP_MUSHROOM_FREEZING.getState(stateAtPos, rand);
        if (frozenState != null) {
            level.m_46597_(randPos, frozenState);
            if (level instanceof ServerLevel) {
                ((ServerLevel)level).m_8767_((ParticleOptions)ParticleTypes.f_123796_, (double)randPos.m_123341_() + 0.5, (double)randPos.m_123342_() + 0.5, (double)randPos.m_123343_() + 0.5, 8, 0.3, 0.3, 0.3, 0.03);
                level.m_5594_(null, randPos, SoundEvents.f_12031_, SoundSource.BLOCKS, 0.15f, 0.9f + rand.m_188501_() * 0.2f);
            }
        }
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext useContext) {
        return false;
    }

    public boolean m_7370_(LevelReader level, BlockPos pos, BlockState state, boolean isClient) {
        return true;
    }

    public boolean m_214167_(Level level, RandomSource rand, BlockPos pos, BlockState state) {
        return true;
    }

    public void m_214148_(ServerLevel level, RandomSource rand, BlockPos pos, BlockState state) {
        Optional mushroomFeature;
        if (rand.m_188501_() < 0.75f && (mushroomFeature = level.m_9598_().m_175515_(Registries.f_256911_).m_203636_(SkiesConfiguredFeatures.GIANT_SNOWCAP_MUSHROOM)).isPresent()) {
            SaplingGrowTreeEvent event = ForgeEventFactory.blockGrowFeature((LevelAccessor)level, (RandomSource)rand, (BlockPos)pos, (Holder)((Holder)mushroomFeature.get()));
            if (event.getResult().equals((Object)Event.Result.DENY)) {
                return;
            }
            ((ConfiguredFeature)event.getFeature().m_203334_()).m_224953_((WorldGenLevel)level, level.m_7726_().m_8481_(), rand, state.m_61143_((Property)f_52858_) == DoubleBlockHalf.LOWER ? pos : pos.m_7495_());
        }
    }
}

