/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.blocks.natural;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.FarmlandWaterManager;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;

public class SkyFarmlandBlock
extends FarmBlock {
    private final Supplier<Block> dirt;

    public SkyFarmlandBlock(BlockBehaviour.Properties builder, Supplier<Block> dirt) {
        super(builder);
        this.dirt = dirt;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return !this.m_49966_().m_60710_((LevelReader)context.m_43725_(), context.m_8083_()) ? this.dirt.get().m_49966_() : super.m_5573_(context);
    }

    public boolean canSustainPlant(BlockState state, BlockGetter world, BlockPos pos, Direction facing, IPlantable plantable) {
        PlantType plantType = plantable.getPlantType(world, pos.m_121945_(facing));
        if (plantType == PlantType.CROP) {
            return true;
        }
        return super.canSustainPlant(state, world, pos, facing, plantable);
    }

    public void m_142072_(Level level, BlockState state, BlockPos pos, Entity entity, float fallDistance) {
        if (!level.f_46443_ && ForgeHooks.onFarmlandTrample((Level)level, (BlockPos)pos, (BlockState)this.dirt.get().m_49966_(), (float)fallDistance, (Entity)entity)) {
            SkyFarmlandBlock.turnToDirt(level.m_8055_(pos), level, pos, this);
        }
        entity.m_142535_(fallDistance, 1.0f, level.m_269111_().m_268989_());
    }

    public void m_213897_(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (!state.m_60710_((LevelReader)world, pos)) {
            SkyFarmlandBlock.turnToDirt(state, (Level)world, pos, this);
        }
    }

    public void m_213898_(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        int i = (Integer)state.m_61143_((Property)f_53243_);
        if (!SkyFarmlandBlock.hasWater((LevelReader)world, pos) && !world.m_46758_(pos.m_7494_())) {
            if (i > 0) {
                world.m_7731_(pos, (BlockState)state.m_61124_((Property)f_53243_, (Comparable)Integer.valueOf(i - 1)), 2);
            } else if (!this.hasCrops((BlockGetter)world, pos)) {
                SkyFarmlandBlock.turnToDirt(state, (Level)world, pos, this);
            }
        } else if (i < 7) {
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)f_53243_, (Comparable)Integer.valueOf(7)), 2);
        }
    }

    private static boolean hasWater(LevelReader world, BlockPos pos) {
        for (BlockPos blockpos : BlockPos.m_121940_((BlockPos)pos.m_7918_(-4, 0, -4), (BlockPos)pos.m_7918_(4, 1, 4))) {
            if (!world.m_6425_(blockpos).m_205070_(FluidTags.f_13131_)) continue;
            return true;
        }
        return FarmlandWaterManager.hasBlockWaterTicket((LevelReader)world, (BlockPos)pos);
    }

    private boolean hasCrops(BlockGetter world, BlockPos pos) {
        BlockState state = world.m_8055_(pos.m_7494_());
        return state.m_60734_() instanceof IPlantable && this.canSustainPlant(state, world, pos, Direction.UP, (IPlantable)state.m_60734_());
    }

    public static void turnToDirt(BlockState state, Level world, BlockPos pos, SkyFarmlandBlock instance) {
        world.m_46597_(pos, SkyFarmlandBlock.m_49897_((BlockState)state, (BlockState)instance.dirt.get().m_49966_(), (LevelAccessor)world, (BlockPos)pos));
    }

    public boolean isFertile(BlockState state, BlockGetter world, BlockPos pos) {
        if (world.m_8055_(pos).m_60734_() == this) {
            return (Integer)state.m_61143_((Property)FarmBlock.f_53243_) > 0;
        }
        return false;
    }
}

