/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.blocks.natural;

import com.legacy.blue_skies.blocks.natural.SkyCropBlock;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;

public class SkyDoubleCropBlock
extends SkyCropBlock {
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.f_61401_;

    public SkyDoubleCropBlock(Supplier<? extends Item> seed, double height) {
        super(seed, height);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)SkyCropBlock.AGE, (Comparable)Integer.valueOf(0))).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER));
    }

    @Override
    public VoxelShape[] generateShapes(double height) {
        int ages = this.m_7959_().m_6908_().size();
        VoxelShape[] shapes = new VoxelShape[ages];
        for (int i = 0; i < ages; ++i) {
            shapes[i] = Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)((double)(i + 1) / (double)ages * height), (double)12.0);
        }
        return shapes;
    }

    @Override
    public boolean m_6724_(BlockState state) {
        return !this.m_52307_(state) || this.m_52307_(state) && this.isLowerHalf(state);
    }

    @Override
    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!level.m_46749_(pos)) {
            return;
        }
        if (level.m_45524_(pos, 0) >= 9) {
            float f;
            int i = this.m_52305_(state);
            if (i < this.m_7419_() && ForgeHooks.onCropsGrowPre((Level)level, (BlockPos)pos, (BlockState)state, (random.m_188503_((int)(25.0f / (f = SkyDoubleCropBlock.m_52272_((Block)this, (BlockGetter)level, (BlockPos)pos))) + 1) == 0 ? 1 : 0) != 0)) {
                level.m_7731_(pos, this.withState(i + 1, (DoubleBlockHalf)state.m_61143_(HALF)), 2);
                ForgeHooks.onCropsGrowPost((Level)level, (BlockPos)pos, (BlockState)state);
            }
            if (this.m_52307_(state) && this.isLowerHalf(state) && level.m_46859_(pos.m_7494_())) {
                f = SkyDoubleCropBlock.m_52272_((Block)this, (BlockGetter)level, (BlockPos)pos);
                if (ForgeHooks.onCropsGrowPre((Level)level, (BlockPos)pos.m_7494_(), (BlockState)state, (random.m_188503_((int)(25.0f / f) + 1) == 0 ? 1 : 0) != 0)) {
                    level.m_7731_(pos.m_7494_(), this.withState(0, DoubleBlockHalf.UPPER), 2);
                    ForgeHooks.onCropsGrowPost((Level)level, (BlockPos)pos.m_7494_(), (BlockState)state);
                }
            }
        }
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        DoubleBlockHalf doubleblockhalf = (DoubleBlockHalf)state.m_61143_(HALF);
        BlockPos blockpos = doubleblockhalf == DoubleBlockHalf.LOWER ? pos.m_7494_() : pos.m_7495_();
        BlockState blockstate = level.m_8055_(blockpos);
        if (blockstate.m_60734_() == this && blockstate.m_61143_(HALF) != doubleblockhalf) {
            level.m_7731_(blockpos, Blocks.f_50016_.m_49966_(), 35);
            level.m_5898_(player, 2001, blockpos, Block.m_49956_((BlockState)blockstate));
            if (!level.f_46443_ && !player.m_7500_()) {
                SkyDoubleCropBlock.m_49881_((BlockState)state, (Level)level, (BlockPos)pos, (BlockEntity)null, (Entity)player, (ItemStack)player.m_21205_());
                SkyDoubleCropBlock.m_49881_((BlockState)blockstate, (Level)level, (BlockPos)blockpos, (BlockEntity)null, (Entity)player, (ItemStack)player.m_21205_());
            }
        }
        super.m_5707_(level, pos, state, player);
    }

    @Override
    protected boolean m_6266_(BlockState state, BlockGetter level, BlockPos pos) {
        return state.isFertile(level, pos) || state.m_60734_() instanceof FarmBlock;
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        if (this.isLowerHalf(state)) {
            return super.m_7898_(state, level, pos);
        }
        if (!this.isLowerHalf(state)) {
            BlockState downState = level.m_8055_(pos.m_7495_());
            return downState.m_60734_() == this && this.isLowerHalf(downState) && this.m_52307_(downState) && (level.m_45524_(pos, 0) >= 8 || level.m_45527_(pos));
        }
        return false;
    }

    public boolean m_7370_(LevelReader level, BlockPos pos, BlockState state, boolean isClient) {
        BlockState stateAbove = level.m_8055_(pos.m_7494_());
        return !this.m_52307_(state) || this.m_52307_(state) && this.isLowerHalf(state) && (stateAbove.m_60734_() == this && !this.m_52307_(stateAbove) || stateAbove.m_60795_());
    }

    public void m_214148_(ServerLevel level, RandomSource rand, BlockPos pos, BlockState state) {
        int j;
        int i = this.m_52305_(state) + this.m_7125_((Level)level);
        if (i > (j = this.m_7419_())) {
            i = j;
        }
        level.m_7731_(pos, this.withState(i, (DoubleBlockHalf)state.m_61143_(HALF)), 2);
        if (this.isLowerHalf(state) && this.m_52307_(state)) {
            BlockState stateAbove = level.m_8055_(pos.m_7494_());
            if (level.m_46859_(pos.m_7494_())) {
                level.m_46597_(pos.m_7494_(), this.withState(0, DoubleBlockHalf.UPPER));
            } else if (stateAbove.m_60734_() == this && this.m_52305_(stateAbove) < this.m_7419_()) {
                i = this.m_52305_(stateAbove) + this.m_7125_((Level)level);
                if (i > j) {
                    i = j;
                }
                level.m_46597_(pos.m_7494_(), this.withState(i, DoubleBlockHalf.UPPER));
            }
        }
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{HALF});
    }

    private BlockState withState(int age, DoubleBlockHalf half) {
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)SkyCropBlock.AGE, (Comparable)Integer.valueOf(age))).m_61124_(HALF, (Comparable)half);
    }

    private boolean isLowerHalf(BlockState state) {
        return state.m_60734_() == this && ((DoubleBlockHalf)state.m_61143_(HALF)).equals((Object)DoubleBlockHalf.LOWER);
    }
}

