/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.blocks.misc;

import com.legacy.blue_skies.block_entity.TrophyBlockEntity;
import com.legacy.blue_skies.util.DirectionUtil;
import com.legacy.structure_gel.api.util.VoxelShapeUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TrophyBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final EnumProperty<Tier> TIER = EnumProperty.m_61587_((String)"tier", Tier.class);
    public static final EnumProperty<Direction> FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private final Map<Direction, VoxelShape> shapes = new HashMap<Direction, VoxelShape>();
    private final Supplier<EntityType<?>> boss;

    public TrophyBlock(BlockBehaviour.Properties builder, Supplier<EntityType<?>> boss, VoxelShape shape) {
        super(builder);
        this.boss = boss;
        for (Direction dir : DirectionUtil.HORIZONTAL) {
            this.shapes.put(dir, VoxelShapeUtil.rotate((VoxelShape)shape, (Direction)dir));
        }
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_(TIER, (Comparable)((Object)Tier.BRONZE))).m_61124_(FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return this.shapes.get(state.m_61143_(FACING));
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        return ((Tier)((Object)state.m_61143_(TIER))).getItem(this);
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TrophyBlockEntity(pos, state);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float m_7749_(BlockState state, BlockGetter world, BlockPos pos) {
        return 1.0f;
    }

    public boolean m_7923_(BlockState state) {
        return true;
    }

    public boolean m_7420_(BlockState state, BlockGetter world, BlockPos pos) {
        return true;
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        BlockEntity tile = world.m_7702_(pos);
        if (tile instanceof TrophyBlockEntity) {
            ((TrophyBlockEntity)tile).setLabel(stack.m_41788_() ? stack.m_41786_() : this.boss.get().m_20676_());
        }
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Direction facing = context.m_8125_().m_122424_();
        boolean waterlogged = context.m_43725_().m_6425_(context.m_8083_()).m_76152_() == Fluids.f_76193_;
        return (BlockState)((BlockState)this.m_49966_().m_61124_(FACING, (Comparable)facing)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged));
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            world.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)world));
        }
        return state;
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : Fluids.f_76191_.m_76145_();
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{TIER, FACING, WATERLOGGED});
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_(FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_(FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_(FACING)));
    }

    public static enum Tier implements StringRepresentable
    {
        BRONZE("bronze"),
        SILVER("silver"),
        GOLD("gold"),
        PLATINUM("platinum");

        public final String name;

        private Tier(String name) {
            this.name = name;
        }

        public String m_7912_() {
            return this.name;
        }

        public ItemStack getItem(TrophyBlock trophy) {
            ItemStack stack = new ItemStack((ItemLike)trophy);
            CompoundTag nbt = stack.m_41784_();
            CompoundTag states = new CompoundTag();
            states.m_128359_("tier", this.m_7912_());
            nbt.m_128365_("BlockStateTag", (Tag)states);
            return stack;
        }

        public static Tier from(String name) {
            for (Tier t : Tier.values()) {
                if (!t.name.equals(name)) continue;
                return t;
            }
            return BRONZE;
        }
    }
}

