/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.biome_modifiers;

import com.legacy.blue_skies.BlueSkiesConfig;
import com.mojang.serialization.Codec;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ModifiableBiomeInfo;

public class PurifyBiome
implements BiomeModifier {
    public static final PurifyBiome INSTANCE = new PurifyBiome();
    public static final Codec<PurifyBiome> CODEC = Codec.unit(() -> INSTANCE);

    private PurifyBiome() {
    }

    public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        if (phase == BiomeModifier.Phase.REMOVE && biome.m_203543_().map(biomeKey -> "blue_skies".equals(biomeKey.m_135782_().m_135827_())).orElse(false).booleanValue()) {
            for (GenerationStep.Decoration decoration : GenerationStep.Decoration.values()) {
                builder.getGenerationSettings().getFeatures(decoration).removeIf(feature -> {
                    Optional placedFeatureKey = feature.m_203543_();
                    if (placedFeatureKey.isPresent()) {
                        return !BlueSkiesConfig.COMMON.isModAllowedForFeatureGen(((ResourceKey)placedFeatureKey.get()).m_135782_().m_135827_());
                    }
                    return false;
                });
            }
            for (GenerationStep.Decoration decoration : MobCategory.values()) {
                builder.getMobSpawnSettings().getSpawner((MobCategory)decoration).removeIf(spawnerData -> !BlueSkiesConfig.COMMON.isEntityAllowedToSpawn(spawnerData.f_48404_));
            }
        }
    }

    public Codec<? extends BiomeModifier> codec() {
        return CODEC;
    }
}

