/*
 * Decompiled with CFR 0.152.
 */
package fuzs.permanentsponges.world.level.block;

import fuzs.permanentsponges.util.LiquidAbsorptionHelper;
import fuzs.permanentsponges.world.level.block.SpongeMaterial;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class PermanentSpongeBlock
extends Block {
    private final SpongeMaterial spongeMaterial;

    public PermanentSpongeBlock(BlockBehaviour.Properties properties, SpongeMaterial spongeMaterial) {
        super(properties);
        this.spongeMaterial = spongeMaterial;
    }

    public void m_6807_(BlockState newState, Level level, BlockPos pos, BlockState oldState, boolean p_56815_) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (!oldState.m_60713_(newState.m_60734_())) {
                PermanentSpongeBlock.removeAllLiquid(this.spongeMaterial, serverLevel, pos, false, this.spongeMaterial.getPoiType());
            }
        }
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        PermanentSpongeBlock.removeAllLiquid(this.spongeMaterial, level, pos, false);
    }

    public static boolean removeAllLiquid(SpongeMaterial spongeMaterial, ServerLevel level, BlockPos pos, boolean fromStick) {
        return PermanentSpongeBlock.removeAllLiquid(spongeMaterial, level, pos, fromStick, null);
    }

    public static boolean removeAllLiquid(SpongeMaterial spongeMaterial, ServerLevel level, BlockPos pos, boolean fromStick, @Nullable Holder.Reference<PoiType> poiType) {
        int spongeRadius = fromStick ? spongeMaterial.getStickDistance() : spongeMaterial.getBlockDistance();
        boolean destroySource = !fromStick && spongeMaterial.shouldDestroyTouchingHot();
        return LiquidAbsorptionHelper.removeAllLiquid(level, pos, spongeRadius, destroySource, poiType);
    }

    public void m_6810_(BlockState oldState, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        super.m_6810_(oldState, level, pos, newState, movedByPiston);
        if (!oldState.m_60713_(newState.m_60734_())) {
            BlockPos blockPos;
            int spongeRadius = this.spongeMaterial.getBlockDistance() + 1;
            List<BlockPos> positions = LiquidAbsorptionHelper.getSpongeRadius(spongeRadius);
            int i = positions.size() - 1;
            int j = 0;
            while (i >= 0 && (Math.abs((blockPos = positions.get(i)).m_123341_()) == spongeRadius || Math.abs(blockPos.m_123342_()) == spongeRadius || Math.abs(blockPos.m_123343_()) == spongeRadius)) {
                blockPos = blockPos.m_121955_((Vec3i)pos);
                level.m_186469_(blockPos, level.m_6425_(blockPos).m_76152_(), 1);
                --i;
                ++j;
            }
        }
    }
}

