/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.network;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;
import net.p3pp3rf1y.sophisticatedbackpacks.api.CapabilityBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.BackpackContainer;
import net.p3pp3rf1y.sophisticatedcore.network.ISplittableMessage;

public class SyncClientInfoMessage
implements ISplittableMessage {
    private final int slotIndex;
    @Nullable
    private final CompoundTag renderInfoNbt;
    private final int columnsTaken;

    public SyncClientInfoMessage(int slotNumber, @Nullable CompoundTag renderInfoNbt, int columnsTaken) {
        this.slotIndex = slotNumber;
        this.renderInfoNbt = renderInfoNbt;
        this.columnsTaken = columnsTaken;
    }

    public static void encode(SyncClientInfoMessage msg, FriendlyByteBuf packetBuffer) {
        packetBuffer.writeInt(msg.slotIndex);
        packetBuffer.m_130079_(msg.renderInfoNbt);
        packetBuffer.writeInt(msg.columnsTaken);
    }

    public static SyncClientInfoMessage decode(FriendlyByteBuf packetBuffer) {
        return new SyncClientInfoMessage(packetBuffer.readInt(), packetBuffer.m_130261_(), packetBuffer.readInt());
    }

    static void onMessage(SyncClientInfoMessage msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> SyncClientInfoMessage.handleMessage(msg));
        context.setPacketHandled(true);
    }

    private static void handleMessage(SyncClientInfoMessage msg) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null || msg.renderInfoNbt == null || !(player.f_36096_ instanceof BackpackContainer)) {
            return;
        }
        ItemStack backpack = (ItemStack)player.m_150109_().f_35974_.get(msg.slotIndex);
        backpack.getCapability(CapabilityBackpackWrapper.getCapabilityInstance()).ifPresent(backpackWrapper -> {
            backpackWrapper.getRenderInfo().deserializeFrom(msg.renderInfoNbt);
            backpackWrapper.setColumnsTaken(msg.columnsTaken, false);
        });
    }
}

