/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.registry.ModTags;

public class PlacedBlocksTracker
extends SavedData {
    private final Set<BlockPos> placedBlocks = ConcurrentHashMap.newKeySet();
    public boolean isValidBlock = false;

    public void add(BlockPos pos) {
        this.placedBlocks.add(pos.m_7949_());
        this.m_77762_();
    }

    public void remove(BlockPos pos) {
        this.placedBlocks.remove(pos);
        this.m_77762_();
    }

    public boolean contains(BlockPos pos) {
        return this.placedBlocks.contains(pos);
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        ListTag list = new ListTag();
        for (BlockPos pos : this.placedBlocks) {
            CompoundTag posTag = new CompoundTag();
            posTag.m_128405_("x", pos.m_123341_());
            posTag.m_128405_("y", pos.m_123342_());
            posTag.m_128405_("z", pos.m_123343_());
            list.add((Object)posTag);
        }
        tag.m_128365_("placed_blocks", (Tag)list);
        return tag;
    }

    public static PlacedBlocksTracker load(CompoundTag tag) {
        PlacedBlocksTracker tracker = new PlacedBlocksTracker();
        ListTag list = NBTStackHelper.getListOrCreate(tag, "placed_blocks");
        for (Tag t : list) {
            CompoundTag posTag = (CompoundTag)t;
            BlockPos pos = new BlockPos(posTag.m_128451_("x"), posTag.m_128451_("y"), posTag.m_128451_("z"));
            tracker.placedBlocks.add(pos.m_7949_());
        }
        return tracker;
    }

    public static PlacedBlocksTracker get(ServerLevel level) {
        return (PlacedBlocksTracker)level.m_8895_().m_164861_(PlacedBlocksTracker::load, PlacedBlocksTracker::new, "tb_placed_blocks_tracker");
    }

    @Mod.EventBusSubscriber(modid="tombstone", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class PlacedBlocksEvents {
        @SubscribeEvent(priority=EventPriority.LOWEST)
        public static void onPlacedBlock(BlockEvent.EntityPlaceEvent event) {
            LevelAccessor levelAccessor = event.getBlockSnapshot().getLevel();
            if (levelAccessor instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)levelAccessor;
                if (PlacedBlocksEvents.isTrackedBlock(event.getPlacedBlock())) {
                    PlacedBlocksTracker tracker = PlacedBlocksTracker.get(serverLevel);
                    if (tracker.isValidBlock) {
                        tracker.isValidBlock = false;
                    } else {
                        tracker.add(event.getPos());
                    }
                }
            }
        }

        @SubscribeEvent(priority=EventPriority.LOWEST)
        public static void onBrokenBlock(BlockEvent.BreakEvent event) {
            PlacedBlocksTracker tracker;
            if (!event.getPlayer().m_9236_().f_46443_ && PlacedBlocksEvents.isTrackedBlock(event.getState()) && (tracker = PlacedBlocksTracker.get((ServerLevel)event.getPlayer().m_9236_())).contains(event.getPos())) {
                tracker.remove(event.getPos());
            }
        }

        private static boolean isTrackedBlock(BlockState state) {
            return state.m_204336_(ModTags.Blocks.living_corals) || state.m_204336_(ModTags.Blocks.dead_corals);
        }
    }
}

