/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.compatibility;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.vanilla.IJeiBrewingRecipe;
import mezz.jei.api.recipe.vanilla.IVanillaRecipeFactory;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.Tags;
import ovh.corail.tombstone.block.BlockGraveMarble;
import ovh.corail.tombstone.block.ItemBlockGrave;
import ovh.corail.tombstone.capability.SoulConsumerProvider;
import ovh.corail.tombstone.combine.CombineRecipe;
import ovh.corail.tombstone.compatibility.CombineRecipeCategory;
import ovh.corail.tombstone.helper.EngravableHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.item.ItemGraveMagic;
import ovh.corail.tombstone.registry.ModBlocks;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.registry.ModPotions;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
@JeiPlugin
public final class IntegrationJustEnoughItem
implements IModPlugin {
    private static final ResourceLocation JEI_INTEGRATION_RL = new ResourceLocation("tombstone", "jei_integration");
    private final RecipeType<CombineRecipe> recipeType = RecipeType.create((String)"tombstone", (String)"combine", CombineRecipe.class);

    public ResourceLocation getPluginUid() {
        return JEI_INTEGRATION_RL;
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        registry.addRecipeCategories(new IRecipeCategory[]{new CombineRecipeCategory(this.recipeType, registry.getJeiHelpers().getGuiHelper())});
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        jeiRuntime.getIngredientManager().addIngredientsAtRuntime((IIngredientType)VanillaTypes.ITEM_STACK, Collections.singletonList(new ItemStack((ItemLike)ModItems.grave_key)));
    }

    public void registerRecipes(IRecipeRegistration registration) {
        ImmutableList.Builder combineBuilder = ImmutableList.builder();
        combineBuilder.add((Object)new CombineRecipe(Ingredient.m_43929_((ItemLike[])new ItemLike[]{ModItems.impregnated_diamond}), Ingredient.m_43927_((ItemStack[])new ItemStack[]{ModItems.bone_needle.impregnate(new ItemStack((ItemLike)ModItems.bone_needle), "minecraft:cat")}), () -> ModItems.bone_needle.impregnate(new ItemStack((ItemLike)ModItems.impregnated_diamond), "minecraft:rabbit")));
        ModItems.grave_key.getCombineRecipes().forEach(arg_0 -> ((ImmutableList.Builder)combineBuilder).add(arg_0));
        ModItems.grave_dust.getCombineRecipes().forEach(arg_0 -> ((ImmutableList.Builder)combineBuilder).add(arg_0));
        ModItems.strange_scroll.getCombineRecipes().forEach(arg_0 -> ((ImmutableList.Builder)combineBuilder).add(arg_0));
        ModItems.strange_tablet.getCombineRecipes().forEach(arg_0 -> ((ImmutableList.Builder)combineBuilder).add(arg_0));
        ModBlocks.DECORATIVE_GRAVES.values().forEach(decorativeGrave -> {
            for (BlockGraveMarble.MarbleType type : BlockGraveMarble.MarbleType.values()) {
                ItemStack graveStack = ItemBlockGrave.setModelTexture(new ItemStack((ItemLike)decorativeGrave), type.ordinal());
                combineBuilder.add((Object)new CombineRecipe(Ingredient.m_43927_((ItemStack[])new ItemStack[]{graveStack}), Ingredient.m_43927_((ItemStack[])new ItemStack[]{EngravableHelper.setEngravedName(new ItemStack((ItemLike)ModItems.grave_plate), "Unknown")}), () -> EngravableHelper.setEngravedName(graveStack.m_41777_(), "Unknown")));
            }
        });
        registration.addRecipes(this.recipeType, (List)combineBuilder.build());
        ImmutableList.Builder builder = ImmutableList.builder();
        IVanillaRecipeFactory factory = registration.getVanillaRecipeFactory();
        builder.add((Object)factory.createAnvilRecipe(new ItemStack((ItemLike)ModItems.grave_plate), Helper.getStacks((TagKey<Item>)Tags.Items.INGOTS_IRON), Collections.singletonList(EngravableHelper.setEngravedName(new ItemStack((ItemLike)ModItems.grave_plate), "Unknown"))));
        ItemStack tablet = NBTStackHelper.setBoolean(new ItemStack((ItemLike)ModItems.tablet_of_assistance), "enchant", true);
        builder.add((Object)factory.createAnvilRecipe(tablet, Collections.singletonList(new ItemStack((ItemLike)ModItems.grave_dust)), Collections.singletonList(EngravableHelper.setEngravedName(tablet.m_41777_(), "Unknown"))));
        registration.addRecipes(RecipeTypes.ANVIL, (List)builder.build());
        ImmutableList.Builder potionBuilder = ImmutableList.builder();
        potionBuilder.add((Object)new JeiBrewingRecipe(ModPotions.spectral, ModBlocks.thornveil.m_5456_(), ModPotions.earthly_garden));
        potionBuilder.add((Object)new JeiBrewingRecipe(ModPotions.spectral, Items.f_220220_, ModPotions.bait));
        potionBuilder.add((Object)new JeiBrewingRecipe(ModPotions.spectral, Items.f_42363_, ModPotions.frostbite));
        potionBuilder.add((Object)new JeiBrewingRecipe(ModPotions.spectral, Items.f_220224_, ModPotions.darkness));
        potionBuilder.add((Object)new JeiBrewingRecipe(ModPotions.spectral, Items.f_42714_, ModPotions.discretion));
        potionBuilder.add((Object)new JeiBrewingRecipe(Potions.f_43581_, ModItems.grave_dust, ModPotions.restoration));
        registration.addRecipes(RecipeTypes.BREWING, (List)potionBuilder.build());
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        for (Block block : ModBlocks.DECORATIVE_GRAVES.values()) {
            registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)block.m_5456_(), (stack, ctx) -> String.valueOf(ItemBlockGrave.getModelTexture(stack)));
        }
        registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)ModItems.tablet_of_home, (stack, ctx) -> ModItems.tablet_of_home.isAncient((ItemStack)stack) ? "ancient" : (ModItems.tablet_of_home.isEnchanted((ItemStack)stack) ? "enchanted" : "normal"));
        registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)ModItems.tablet_of_recall, (stack, ctx) -> ModItems.tablet_of_recall.isAncient((ItemStack)stack) ? "ancient" : (ModItems.tablet_of_recall.isEnchanted((ItemStack)stack) ? "enchanted" : "normal"));
        registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)ModItems.tablet_of_assistance, (stack, ctx) -> ModItems.tablet_of_assistance.isAncient((ItemStack)stack) ? "ancient" : (ModItems.tablet_of_assistance.isEnchanted((ItemStack)stack) ? "enchanted" : "normal"));
        registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)ModItems.tablet_of_cupidity, (stack, ctx) -> ModItems.tablet_of_cupidity.isAncient((ItemStack)stack) ? "ancient" : (ModItems.tablet_of_cupidity.isEnchanted((ItemStack)stack) ? "enchanted" : "normal"));
        registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)ModItems.tablet_of_guard, (stack, ctx) -> ModItems.tablet_of_guard.isAncient((ItemStack)stack) ? "ancient" : (ModItems.tablet_of_guard.isEnchanted((ItemStack)stack) ? "enchanted" : "normal"));
        ModItems.scroll_buff.values().forEach(scroll -> registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, scroll, (stack, ctx) -> {
            ItemGraveMagic graveMagic = (ItemGraveMagic)stack.m_41720_();
            return graveMagic.isAncient((ItemStack)stack) ? "ancient" : (graveMagic.isEnchanted((ItemStack)stack) ? "enchanted" : "normal");
        }));
        registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)ModItems.grave_key, (stack, ctx) -> ModItems.grave_key.isEnchanted((ItemStack)stack) ? "enchanted" : "normal");
        registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)ModItems.fishing_rod_of_misadventure, (stack, ctx) -> ModItems.fishing_rod_of_misadventure.isAncient((ItemStack)stack) ? "ancient" : (ModItems.fishing_rod_of_misadventure.isEnchanted((ItemStack)stack) ? "enchanted" : "normal"));
        registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)Items.f_151058_, (stack, ctx) -> stack.getCapability(SoulConsumerProvider.CAP_SOUL_CONSUMER).map(c -> c.isEnchanted((ItemStack)stack)).orElse(false) != false ? "enchanted" : "normal");
    }

    private static class JeiBrewingRecipe
    implements IJeiBrewingRecipe {
        private final List<ItemStack> input;
        private final List<ItemStack> ingredient;
        private final ItemStack output;

        private JeiBrewingRecipe(Potion input, Item ingredient, Potion output) {
            this.input = Collections.singletonList(PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)input));
            this.ingredient = Collections.singletonList(new ItemStack((ItemLike)ingredient));
            this.output = PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)output);
        }

        public List<ItemStack> getPotionInputs() {
            return this.input;
        }

        public List<ItemStack> getIngredients() {
            return this.ingredient;
        }

        public ItemStack getPotionOutput() {
            return this.output;
        }

        public int getBrewingSteps() {
            return 2;
        }
    }
}

