/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.common.advancements.UseItemSuccessTrigger;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.CustomCreativeTabContents;
import vazkii.botania.common.item.ItemWithBannerPattern;
import vazkii.botania.common.lib.BotaniaTags;
import vazkii.patchouli.api.PatchouliAPI;

public class LexicaBotaniaItem
extends Item
implements ItemWithBannerPattern,
CustomCreativeTabContents {
    public static final String TAG_ELVEN_UNLOCK = "botania:elven_unlock";

    public LexicaBotaniaItem(Item.Properties settings) {
        super(settings);
    }

    public static boolean isOpen() {
        return BuiltInRegistries.f_257033_.m_7981_((Object)BotaniaItems.lexicon).equals((Object)PatchouliAPI.get().getOpenBookGui());
    }

    @Override
    public void addToCreativeTab(Item me, CreativeModeTab.Output output) {
        output.m_246326_((ItemLike)this);
        ItemStack creative = new ItemStack((ItemLike)this);
        creative.m_41784_().m_128379_(TAG_ELVEN_UNLOCK, true);
        output.m_246342_(creative);
    }

    public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)LexicaBotaniaItem.getEdition().m_6881_().m_130940_(ChatFormatting.GRAY));
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack stack = playerIn.m_21120_(handIn);
        if (playerIn instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)playerIn;
            UseItemSuccessTrigger.INSTANCE.trigger(player, stack, player.m_284548_(), player.m_20185_(), player.m_20186_(), player.m_20189_());
            PatchouliAPI.get().openBookGUI(player, BuiltInRegistries.f_257033_.m_7981_((Object)this));
            playerIn.m_5496_(BotaniaSounds.lexiconOpen, 1.0f, (float)(0.7 + Math.random() * 0.4));
        }
        return InteractionResultHolder.m_19092_((Object)stack, (boolean)worldIn.m_5776_());
    }

    public static Component getEdition() {
        try {
            return PatchouliAPI.get().getSubtitle(BuiltInRegistries.f_257033_.m_7981_((Object)BotaniaItems.lexicon));
        }
        catch (IllegalArgumentException e) {
            return Component.m_237113_((String)"");
        }
    }

    public static Component getTitle(ItemStack stack) {
        Component title = stack.m_41786_();
        String akashicTomeNBT = "akashictome:displayName";
        if (stack.m_41782_() && stack.m_41783_().m_128441_(akashicTomeNBT)) {
            CompoundTag nameTextComponent = stack.m_41783_().m_128469_(akashicTomeNBT);
            title = Component.Serializer.m_130701_((String)nameTextComponent.m_128461_("text"));
        }
        return title;
    }

    public static boolean isElven(ItemStack stack) {
        return stack.m_41782_() && stack.m_41783_().m_128471_(TAG_ELVEN_UNLOCK);
    }

    public static BlockHitResult doRayTrace(Level world, Player player, ClipContext.Fluid fluidMode) {
        return Item.m_41435_((Level)world, (Player)player, (ClipContext.Fluid)fluidMode);
    }

    @Override
    public TagKey<BannerPattern> getBannerPattern() {
        return BotaniaTags.BannerPatterns.PATTERN_ITEM_LEXICON;
    }
}

