/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.flower.generating;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.block.BotaniaFlowerBlocks;
import vazkii.botania.common.block.flower.generating.FluidGeneratorBlockEntity;
import vazkii.botania.common.handler.BotaniaSounds;

public class ThermalilyBlockEntity
extends FluidGeneratorBlockEntity {
    public static final int COOLDOWN_TICKS_MULTIPLER = 400;
    public static final String TAG_COOLDOWN_MAGNITUDE = "cooldownStrength";
    private int cooldownStrength = 15;
    public static final int[] COOLDOWN_ROLL_PDF = new int[]{10, 5, 3, 2, 1, 1, 3, 3, 3, 2, 1, 1, 1, 2, 2};
    public static final int COOLDOWN_ROLL_TOTAL;

    public ThermalilyBlockEntity(BlockPos pos, BlockState state) {
        super(BotaniaFlowerBlocks.THERMALILY, pos, state, (TagKey<Fluid>)FluidTags.f_13132_, 600, 45);
    }

    @Override
    public int getCooldownTime(boolean finishedPrevious) {
        if (finishedPrevious) {
            this.cooldownStrength = ThermalilyBlockEntity.rollNewCooldownStrength(this.m_58904_().m_213780_());
        }
        return 400 * this.cooldownStrength;
    }

    public static int rollNewCooldownStrength(RandomSource random) {
        int total = random.m_188503_(COOLDOWN_ROLL_TOTAL);
        int index = 0;
        while (total >= COOLDOWN_ROLL_PDF[index]) {
            total -= COOLDOWN_ROLL_PDF[index];
            ++index;
        }
        return index + 1;
    }

    @Override
    public int getColor() {
        return 13646848;
    }

    @Override
    public void doBurnParticles() {
        WispParticleData data = WispParticleData.wisp((float)Math.random() / 6.0f, 0.7f, 0.05f, 0.05f, 1.0f);
        this.emitParticle(data, 0.5 + Math.random() * 0.2 - 0.1, 0.9 + Math.random() * 0.2 - 0.1, 0.5 + Math.random() * 0.2 - 0.1, 0.0, (float)Math.random() / 60.0f, 0.0);
    }

    @Override
    public void playSound() {
        this.m_58904_().m_5594_(null, this.getEffectivePos(), BotaniaSounds.thermalily, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    @Override
    public int getComparatorSignal() {
        return this.burnTime > 0 ? 0 : this.cooldownStrength;
    }

    @Override
    public int getMaxMana() {
        return 750;
    }

    @Override
    public void writeToPacketNBT(CompoundTag cmp) {
        super.writeToPacketNBT(cmp);
        cmp.m_128405_(TAG_COOLDOWN_MAGNITUDE, this.cooldownStrength);
    }

    @Override
    public void readFromPacketNBT(CompoundTag cmp) {
        super.readFromPacketNBT(cmp);
        this.cooldownStrength = cmp.m_128451_(TAG_COOLDOWN_MAGNITUDE);
    }

    static {
        int acc = 0;
        for (int i : COOLDOWN_ROLL_PDF) {
            acc += i;
        }
        COOLDOWN_ROLL_TOTAL = acc;
    }
}

