/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.block_entity;

import com.google.common.base.Preconditions;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Clearable;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntity;

public abstract class SimpleInventoryBlockEntity
extends BotaniaBlockEntity
implements Clearable {
    private final SimpleContainer itemHandler = this.createItemHandler();

    protected SimpleInventoryBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.itemHandler.m_19164_(i -> this.m_6596_());
    }

    private static void copyToInv(NonNullList<ItemStack> src, Container dest) {
        Preconditions.checkArgument((src.size() == dest.m_6643_() ? 1 : 0) != 0);
        for (int i = 0; i < src.size(); ++i) {
            dest.m_6836_(i, (ItemStack)src.get(i));
        }
    }

    private static NonNullList<ItemStack> copyFromInv(Container inv) {
        NonNullList ret = NonNullList.m_122780_((int)inv.m_6643_(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ret.set(i, (Object)inv.m_8020_(i));
        }
        return ret;
    }

    @Override
    public void readPacketNBT(CompoundTag tag) {
        NonNullList tmp = NonNullList.m_122780_((int)this.inventorySize(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)tag, (NonNullList)tmp);
        SimpleInventoryBlockEntity.copyToInv((NonNullList<ItemStack>)tmp, (Container)this.itemHandler);
    }

    @Override
    public void writePacketNBT(CompoundTag tag) {
        ContainerHelper.m_18973_((CompoundTag)tag, SimpleInventoryBlockEntity.copyFromInv((Container)this.itemHandler));
    }

    public final int inventorySize() {
        return this.getItemHandler().m_6643_();
    }

    protected abstract SimpleContainer createItemHandler();

    public void m_6211_() {
        this.getItemHandler().m_6211_();
    }

    public final Container getItemHandler() {
        return this.itemHandler;
    }
}

