/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.block_entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;
import vazkii.botania.common.block.block_entity.ExposedSimpleInventoryBlockEntity;
import vazkii.botania.xplat.XplatAbstractions;

public class OpenCrateBlockEntity
extends ExposedSimpleInventoryBlockEntity {
    public OpenCrateBlockEntity(BlockPos pos, BlockState state) {
        this(BotaniaBlockEntities.OPEN_CRATE, pos, state);
    }

    protected OpenCrateBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    protected SimpleContainer createItemHandler() {
        return new SimpleContainer(1);
    }

    public static void serverTick(Level level, BlockPos worldPosition, BlockState state, OpenCrateBlockEntity self) {
        ItemStack stack;
        boolean redstone = level.m_276867_(worldPosition);
        if (self.canEject() && !(stack = self.getItemHandler().m_8020_(0)).m_41619_()) {
            self.eject(stack, redstone);
        }
    }

    public boolean canEject() {
        float width = EntityType.f_20461_.m_20678_();
        float height = EntityType.f_20461_.m_20679_();
        double ejectX = (double)this.f_58858_.m_123341_() + 0.5;
        double ejectY = (float)this.f_58858_.m_123342_() - height;
        double ejectZ = (double)this.f_58858_.m_123343_() + 0.5;
        AABB itemBB = new AABB(ejectX - (double)(width / 2.0f), ejectY, ejectZ - (double)(width / 2.0f), ejectX + (double)(width / 2.0f), ejectY + (double)height, ejectZ + (double)(width / 2.0f));
        return this.f_58857_.m_45772_(itemBB);
    }

    public void eject(ItemStack stack, boolean redstone) {
        double ejectY = (float)this.f_58858_.m_123342_() - EntityType.f_20461_.m_20679_();
        ItemEntity item = new ItemEntity(this.f_58857_, (double)this.f_58858_.m_123341_() + 0.5, ejectY, (double)this.f_58858_.m_123343_() + 0.5, stack);
        item.m_20256_(Vec3.f_82478_);
        if (redstone) {
            XplatAbstractions.INSTANCE.itemFlagsComponent((ItemEntity)item).timeCounter = -200;
        }
        this.getItemHandler().m_6836_(0, ItemStack.f_41583_);
        this.f_58857_.m_7967_((Entity)item);
    }

    @Override
    public boolean m_7157_(int index, @NotNull ItemStack stack, @Nullable Direction direction) {
        return false;
    }
}

