/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.core.handler;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Collections;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.Set;
import java.util.WeakHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.BossEvent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.joml.Matrix4f;
import vazkii.botania.client.core.helper.CoreShaders;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.common.entity.GaiaGuardianEntity;

public final class BossBarHandler {
    public static final Set<GaiaGuardianEntity> bosses = Collections.newSetFromMap(new WeakHashMap());
    private static final ResourceLocation BAR_TEXTURE = new ResourceLocation("botania:textures/gui/boss_bar.png");

    private BossBarHandler() {
    }

    public static OptionalInt onBarRender(GuiGraphics gui, int x, int y, BossEvent bossEvent, boolean drawName) {
        for (GaiaGuardianEntity currentBoss : bosses) {
            int n;
            if (!currentBoss.getBossInfoUuid().equals(bossEvent.m_18860_())) continue;
            Minecraft mc = Minecraft.m_91087_();
            int frameU = 0;
            int frameV = 0;
            int frameWidth = 185;
            int frameHeight = 15;
            int healthU = 0;
            int healthV = frameV + frameHeight;
            int healthWidth = 181;
            int healthHeight = 7;
            int healthX = x + (frameWidth - healthWidth) / 2;
            int healthY = y + (frameHeight - healthHeight) / 2;
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int playerCountHeight = BossBarHandler.drawPlayerCount(currentBoss.getPlayerCount(), gui, x, y);
            RenderHelper.drawTexturedModalRect(gui, BAR_TEXTURE, x, y, frameU, frameV, frameWidth, frameHeight);
            BossBarHandler.drawHealthBar(gui, currentBoss, healthX, healthY, healthU, healthV, (int)((float)healthWidth * bossEvent.m_142717_()), healthHeight, false);
            if (drawName) {
                Component name = bossEvent.m_18861_();
                int centerX = mc.m_91268_().m_85445_() / 2;
                gui.m_280653_(mc.f_91062_, name, centerX, y - 10, 10617228);
            }
            if (drawName) {
                Objects.requireNonNull(mc.f_91062_);
                n = 9;
            } else {
                n = 0;
            }
            return OptionalInt.of(frameHeight + playerCountHeight + n);
        }
        return OptionalInt.empty();
    }

    private static int drawPlayerCount(int playerCount, GuiGraphics gui, int x, int y) {
        PoseStack ps = gui.m_280168_();
        ps.m_85836_();
        int px = x + 160;
        int py = y + 12;
        Minecraft mc = Minecraft.m_91087_();
        ItemStack stack = new ItemStack((ItemLike)Items.f_42680_);
        gui.m_280480_(stack, px, py);
        gui.m_280488_(mc.f_91062_, Integer.toString(playerCount), px + 15, py + 4, 0xFFFFFF);
        ps.m_85849_();
        return 5;
    }

    private static void drawHealthBar(GuiGraphics gui, GaiaGuardianEntity currentBoss, int x, int y, int u, int v, int w, int h, boolean bg) {
        ShaderInstance shader = CoreShaders.dopplegangerBar();
        if (shader != null) {
            float time = currentBoss.getInvulTime();
            float grainIntensity = time > 20.0f ? 1.0f : Math.max(currentBoss.isHardMode() ? 0.5f : 0.0f, time / 20.0f);
            shader.m_173356_("BotaniaGrainIntensity").m_5985_(grainIntensity);
            shader.m_173356_("BotaniaHpFract").m_5985_(currentBoss.m_21223_() / currentBoss.m_21233_());
        }
        float minU = (float)u / 256.0f;
        float maxU = (float)(u + w) / 256.0f;
        float minV = (float)v / 256.0f;
        float maxV = (float)(v + h) / 256.0f;
        Matrix4f matrix = gui.m_280168_().m_85850_().m_252922_();
        RenderSystem.setShader(CoreShaders::dopplegangerBar);
        BufferBuilder builder = Tesselator.m_85913_().m_85915_();
        builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        builder.m_252986_(matrix, (float)x, (float)(y + h), 0.0f).m_7421_(minU, maxV).m_5752_();
        builder.m_252986_(matrix, (float)(x + w), (float)(y + h), 0.0f).m_7421_(maxU, maxV).m_5752_();
        builder.m_252986_(matrix, (float)(x + w), (float)y, 0.0f).m_7421_(maxU, minV).m_5752_();
        builder.m_252986_(matrix, (float)x, (float)y, 0.0f).m_7421_(minU, minV).m_5752_();
        Tesselator.m_85913_().m_85914_();
    }
}

