/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets2.common.network.packets;

import com.direwolf20.buildinggadgets2.api.gadgets.GadgetModes;
import com.direwolf20.buildinggadgets2.common.items.BaseGadget;
import com.direwolf20.buildinggadgets2.util.GadgetNBT;
import com.direwolf20.buildinggadgets2.util.modes.BaseMode;
import com.google.common.collect.ImmutableSortedSet;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class PacketModeSwitch {
    boolean rotate;
    ResourceLocation modeId;

    public PacketModeSwitch(ResourceLocation modeId, boolean rotate) {
        this.modeId = modeId;
    }

    public static PacketModeSwitch decode(FriendlyByteBuf buf) {
        return new PacketModeSwitch(buf.m_130281_(), buf.readBoolean());
    }

    public static void encode(PacketModeSwitch message, FriendlyByteBuf buf) {
        buf.m_130085_(message.modeId);
        buf.writeBoolean(message.rotate);
    }

    public static void handle(PacketModeSwitch message, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            Item patt1548$temp;
            ServerPlayer sender = ((NetworkEvent.Context)context.get()).getSender();
            if (sender == null) {
                return;
            }
            ItemStack gadget = BaseGadget.getGadget((Player)sender);
            if (gadget.m_41619_() || !((patt1548$temp = gadget.m_41720_()) instanceof BaseGadget)) {
                return;
            }
            BaseGadget actualGadget = (BaseGadget)patt1548$temp;
            if (message.rotate) {
                ResourceLocation mode = actualGadget.rotateModes(gadget);
                return;
            }
            ResourceLocation modeId = message.modeId;
            ImmutableSortedSet<BaseMode> modesForGadget = GadgetModes.INSTANCE.getModesForGadget(actualGadget.gadgetTarget());
            BaseMode modeToUse = modesForGadget.stream().filter(e -> e.getId().equals((Object)modeId)).findFirst().orElse((BaseMode)modesForGadget.first());
            GadgetNBT.setMode(gadget, modeToUse);
        });
        context.get().setPacketHandled(true);
    }
}

