/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets2.client.screen.widgets;

import com.direwolf20.buildinggadgets2.client.screen.MaterialListGUI;
import com.direwolf20.buildinggadgets2.client.screen.widgets.EntryList;
import com.direwolf20.buildinggadgets2.common.worlddata.BG2DataClient;
import com.direwolf20.buildinggadgets2.util.BuildingUtils;
import com.direwolf20.buildinggadgets2.util.GadgetNBT;
import com.direwolf20.buildinggadgets2.util.ItemStackKey;
import com.direwolf20.buildinggadgets2.util.datatypes.StatePos;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class ScrollingMaterialList
extends EntryList<Entry> {
    private static final int UPDATE_MILLIS = 1000;
    public static final int TOP = 16;
    public static final int BOTTOM = 32;
    private static final int SLOT_SIZE = 18;
    private static final int MARGIN = 2;
    private static final int ENTRY_HEIGHT;
    private static final int LINE_SIDE_MARGIN = 8;
    private Screen gui;
    private SortingModes sortingMode;
    private long lastUpdate;
    private ArrayList<StatePos> statePosArrayList;
    private Map<ItemStackKey, Integer> itemCountsMap;
    private ItemStack templateItem;
    public List<Component> hoveringText;

    public ScrollingMaterialList(Screen gui, int windowLeftX, int windowTopY, int windowWidth, int windowHeight, ItemStack templateItem) {
        super(windowLeftX, windowTopY, windowWidth, windowHeight, ENTRY_HEIGHT);
        this.gui = gui;
        this.setSortingMode(SortingModes.NAME);
        this.setTemplateItem(templateItem);
        this.updateEntries();
    }

    public void setTemplateItem(ItemStack templateItem) {
        this.templateItem = templateItem;
        this.statePosArrayList = new ArrayList();
        this.updateEntries();
    }

    private void updateEntries() {
        LocalPlayer player;
        this.lastUpdate = System.currentTimeMillis();
        this.m_93516_();
        this.m_93410_(0.0);
        if (this.statePosArrayList == null || this.statePosArrayList.isEmpty()) {
            this.statePosArrayList = BG2DataClient.getLookupFromUUID(GadgetNBT.getUUID(this.templateItem));
        }
        if ((player = Minecraft.m_91087_().f_91074_) == null) {
            return;
        }
        this.itemCountsMap = StatePos.getItemList(this.statePosArrayList);
        for (Map.Entry<ItemStackKey, Integer> entry : this.itemCountsMap.entrySet()) {
            if (entry.getKey().getStack().m_41619_()) continue;
            int itemCount = BuildingUtils.countItemStacks((Player)player, entry.getKey().getStack());
            this.m_7085_((AbstractSelectionList.Entry)new Entry(this, entry.getKey().getStack(), entry.getValue(), itemCount));
        }
        this.sort();
    }

    protected int m_5756_() {
        return this.getRight() - 2 - 6;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 69) {
            assert (Minecraft.m_91087_().f_91074_ != null);
            Minecraft.m_91087_().f_91074_.m_6915_();
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    @Override
    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
    }

    public void reset() {
        this.itemCountsMap = null;
    }

    public SortingModes getSortingMode() {
        return this.sortingMode;
    }

    public void setSortingMode(SortingModes sortingMode) {
        this.sortingMode = sortingMode;
        this.sort();
    }

    private void sort() {
        this.m_6702_().sort(this.sortingMode.getComparator());
    }

    static {
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        ENTRY_HEIGHT = Math.max(22, 9 * 2 + 6);
    }

    public static enum SortingModes {
        NAME(Comparator.comparing(Entry::getItemName), (Component)Component.m_237115_((String)"buildinggadgets2.screen.sortaz")),
        NAME_REVERSED(NAME.getComparator().reversed(), (Component)Component.m_237115_((String)"buildinggadgets2.screen.sortza")),
        REQUIRED(Comparator.comparingInt(Entry::getRequired), (Component)Component.m_237115_((String)"buildinggadgets2.screen.requiredasc")),
        REQUIRED_REVERSED(REQUIRED.getComparator().reversed(), (Component)Component.m_237115_((String)"buildinggadgets2.screen.requireddesc")),
        MISSING(Comparator.comparingInt(Entry::getMissing), (Component)Component.m_237115_((String)"buildinggadgets2.screen.missingasc")),
        MISSING_REVERSED(MISSING.getComparator().reversed(), (Component)Component.m_237115_((String)"buildinggadgets2.screen.missingdesc"));

        private final Comparator<Entry> comparator;
        private final Component translatable;
        public static final SortingModes[] VALUES;

        private SortingModes(Comparator<Entry> comparator, Component translatable) {
            this.comparator = comparator;
            this.translatable = translatable;
        }

        public Comparator<Entry> getComparator() {
            return this.comparator;
        }

        public Component getTranslatable() {
            return this.translatable;
        }

        public SortingModes next() {
            int nextIndex = this.ordinal() + 1;
            return VALUES[nextIndex >= VALUES.length ? 0 : nextIndex];
        }

        static {
            VALUES = SortingModes.values();
        }
    }

    public static class Entry
    extends ObjectSelectionList.Entry<Entry> {
        private ScrollingMaterialList parent;
        private int required;
        private int available;
        private ItemStack stack;
        private String itemName;
        private String amount;
        private int widthItemName;
        private int widthAmount;
        private int hoveringTextX;
        private int hoveringTextY;

        public Entry(ScrollingMaterialList parent, ItemStack item, int required, int available) {
            this.parent = parent;
            this.required = required;
            this.available = Mth.m_14045_((int)available, (int)0, (int)required);
            this.stack = item;
            this.itemName = this.stack.m_41786_().getString();
            this.amount = this.available + "/" + required;
            this.widthItemName = Minecraft.m_91087_().f_91062_.m_92895_(this.itemName);
            this.widthAmount = Minecraft.m_91087_().f_91062_.m_92895_(this.amount);
        }

        public void m_6311_(GuiGraphics guiGraphics, int index, int topY, int leftX, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float particleTicks) {
            int right = leftX + entryWidth - 4;
            int bottom = topY + entryHeight;
            int slotX = leftX + 2 - 15;
            int slotY = topY + 2;
            this.drawIcon(guiGraphics, this.stack, slotX, slotY);
            this.drawTextOverlay(guiGraphics, right, topY, bottom, slotX);
            this.drawHoveringText(this.stack, slotX, slotY, mouseX, mouseY);
        }

        private void drawTextOverlay(GuiGraphics guiGraphics, int right, int top, int bottom, int slotX) {
            int itemNameX = slotX + 18 + 2;
            Font fontRenderer = Minecraft.m_91087_().f_91062_;
            int rightEdge = MaterialListGUI.getXForAlignedRight(right, fontRenderer.m_92895_(this.amount)) - 5;
            MaterialListGUI.renderTextVerticalCenter(guiGraphics, this.itemName, itemNameX, rightEdge, top, bottom, Color.WHITE.getRGB());
            Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
            MaterialListGUI.renderTextHorizontalRight(guiGraphics, this.amount, right, MaterialListGUI.getYForAlignedCenter(top, bottom, 9), this.getTextColor());
        }

        private void drawGuidingLine(int right, int top, int bottom, int itemNameX, int widthItemName, int widthAmount) {
            if (!this.isSelected()) {
                int lineXStart = itemNameX + widthItemName + 8;
                int lineXEnd = right - widthAmount - 8;
                int lineY = MaterialListGUI.getYForAlignedCenter(top, bottom - 1, 1);
                RenderSystem.enableBlend();
                RenderSystem.blendFunc((int)770, (int)771);
                RenderSystem.setShaderColor((float)255.0f, (float)255.0f, (float)255.0f, (float)34.0f);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.disableBlend();
            }
        }

        private void drawHoveringText(ItemStack item, int slotX, int slotY, int mouseX, int mouseY) {
            if (MaterialListGUI.isPointInBox(mouseX, mouseY, slotX, slotY, 18, 18)) {
                this.setTaskHoveringText(mouseX, mouseY, MaterialListGUI.m_280152_((Minecraft)Minecraft.m_91087_(), (ItemStack)item));
            }
        }

        private void drawIcon(GuiGraphics guiGraphics, ItemStack item, int slotX, int slotY) {
            Lighting.m_84930_();
            guiGraphics.m_280480_(item, slotX, slotY);
            Lighting.m_84931_();
        }

        private boolean hasEnoughItems() {
            return this.required == this.available;
        }

        private int getTextColor() {
            return this.hasEnoughItems() ? Color.GREEN.getRGB() : (this.available == 0 ? Color.RED.getRGB() : Color.YELLOW.getRGB());
        }

        public int getRequired() {
            return this.required;
        }

        public int getAvailable() {
            return this.available;
        }

        public int getMissing() {
            return this.required - this.available;
        }

        public ItemStack getStack() {
            return this.stack;
        }

        public String getItemName() {
            return this.itemName;
        }

        public String getFormattedRequired() {
            int maxSize = this.stack.m_41741_();
            int stacks = this.required / maxSize;
            int leftover = this.required % maxSize;
            if (stacks == 0) {
                return String.valueOf(leftover);
            }
            return stacks + "\u00d7" + maxSize + "+" + leftover;
        }

        public boolean m_6375_(double x, double y, int button) {
            if (this.m_5953_(x, y)) {
                this.parent.m_6987_((AbstractSelectionList.Entry)this);
                return true;
            }
            return false;
        }

        public boolean isSelected() {
            return this.parent.m_93511_() == this;
        }

        public Component m_142172_() {
            return Component.m_237119_();
        }

        public void setTaskHoveringText(int x, int y, List<Component> text) {
            this.hoveringTextX = x;
            this.hoveringTextY = y;
            this.parent.hoveringText = text;
        }
    }
}

