/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.bargain.preview;

import com.google.gson.JsonObject;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import tictim.paraglider.ParagliderUtils;
import tictim.paraglider.api.bargain.OfferPreview;

public record QuantifiedItem(@NotNull ItemStack item, int quantity) implements OfferPreview
{
    public QuantifiedItem(@NotNull Item item, int quantity) {
        this(new ItemStack((ItemLike)item), Math.max(0, quantity));
    }

    public QuantifiedItem(@NotNull ItemStack item, int quantity) {
        this.item = Objects.requireNonNull(item);
        this.quantity = Math.max(0, quantity);
    }

    public QuantifiedItem(@NotNull JsonObject object) {
        this(QuantifiedItem.parseItemStack(object), GsonHelper.m_13824_((JsonObject)object, (String)"count", (int)1));
    }

    @NotNull
    public static QuantifiedItem read(@NotNull FriendlyByteBuf buffer) {
        return new QuantifiedItem(buffer.m_130267_(), buffer.m_130242_());
    }

    private static ItemStack parseItemStack(JsonObject object) {
        ItemStack stack = ShapedRecipe.m_151274_((JsonObject)object);
        stack.m_41764_(1);
        return stack;
    }

    @NotNull
    public ItemStack getItem() {
        return this.item;
    }

    public int getQuantity() {
        return this.quantity;
    }

    @Override
    @NotNull
    public ItemStack preview() {
        return this.item;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    @NotNull
    public @NotNull List<@NotNull Component> getTooltip() {
        return Screen.m_280152_((Minecraft)Minecraft.m_91087_(), (ItemStack)this.item);
    }

    @NotNull
    public ItemStack getItemWithQuantity() {
        ItemStack copy = this.item.m_41777_();
        copy.m_41764_(this.quantity);
        return copy;
    }

    @NotNull
    public JsonObject serialize() {
        JsonObject obj = new JsonObject();
        obj.addProperty("item", "" + ParagliderUtils.getKey(this.item.m_41720_()));
        if (this.quantity != 1) {
            obj.addProperty("count", (Number)this.quantity);
        }
        return obj;
    }

    public void write(@NotNull FriendlyByteBuf buffer) {
        buffer.m_130055_(this.item);
        buffer.m_130130_(this.quantity);
    }
}

