/*
 * Decompiled with CFR 0.152.
 */
package net.additions.archipelagoadditions.item.custom;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import org.jetbrains.annotations.Nullable;

public class HeathersAxeItem
extends Item {
    public HeathersAxeItem(Item.Properties properties) {
        super(properties);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        if (slot == EquipmentSlot.MAINHAND) {
            CompoundTag tag = stack.m_41784_();
            boolean isOn = tag.m_128471_("Unfolded");
            builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", isOn ? -2.8 : -2.6, AttributeModifier.Operation.ADDITION));
            builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", isOn ? 9.0 : 7.0, AttributeModifier.Operation.ADDITION));
        }
        return builder.build();
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        pTooltipComponents.add((Component)new TranslatableComponent("tooltip.archipelagoadditions.heathers_axe.tooltip"));
        pTooltipComponents.add((Component)new TranslatableComponent("tooltip.archipelagoadditions.dragon_aggro.tooltip"));
    }

    public static boolean isOn(ItemStack stack) {
        return stack.m_41782_() && stack.m_41783_().m_128471_("Unfolded");
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        boolean wasOn = stack.m_41784_().m_128471_("Unfolded");
        stack.m_41783_().m_128379_("Unfolded", !wasOn);
        if (!level.f_46443_) {
            float pitch = 0.9f + level.f_46441_.nextFloat() * 0.2f;
            level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11677_, SoundSource.PLAYERS, 1.0f, pitch);
        }
        return InteractionResultHolder.m_19092_((Object)stack, (boolean)level.m_5776_());
    }

    public float m_8102_(ItemStack pStack, BlockState pState) {
        if (pState.m_60713_(Blocks.f_50033_)) {
            return 15.0f;
        }
        Material material = pState.m_60767_();
        return material != Material.f_76300_ && material != Material.f_76302_ && !pState.m_204336_(BlockTags.f_13035_) && material != Material.f_76285_ ? 1.0f : 1.5f;
    }

    public boolean m_8096_(BlockState pBlock) {
        return pBlock.m_60713_(Blocks.f_50033_);
    }

    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        return ToolActions.DEFAULT_SWORD_ACTIONS.contains(toolAction);
    }

    public int m_6473_() {
        return 1;
    }
}

