/*
 * Decompiled with CFR 0.152.
 */
package de.cristelknight999.t_and_t.config.configs;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.cristelknight999.t_and_t.config.configs.Others;
import de.cristelknight999.t_and_t.config.configs.PillagerOutposts;
import de.cristelknight999.t_and_t.config.configs.Villages;
import de.cristelknight999.t_and_t.config.r.ConfigUtil;
import de.cristelknight999.t_and_t.config.r.JanksonOps;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.RecordComponent;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.Util;

public record TTConfig(Villages villages, PillagerOutposts pillagerOutposts, Others others) {
    public static final Path CONFIG_PATH = ConfigUtil.CONFIG_T_AND_T.resolve("structure_enable_or_disable.json5");
    public static final Path CONFIG_PACK_PATH = ConfigUtil.RES_T_AND_T.resolve("config_pack");
    private static TTConfig INSTANCE = null;
    public static final TTConfig DEFAULT = new TTConfig(new Villages(new Villages.VillageCold(true, true, true, true, true, true, true, true, true, true, true, true), new Villages.VillageWarm(true, true, true, true, true), new Villages.VillageExclusive(true, true, true, true, true, true, true)), new PillagerOutposts(new PillagerOutposts.PillagerCold(true, true, true, true, true, true, true, true, true, true, true, true, true, true, true), new PillagerOutposts.PillagerWarm(true, true, true, true, true, true, true), new PillagerOutposts.PillagerExclusive(true, true, true, true, true, true, true, true)), new Others(true, true));
    public static final Codec<TTConfig> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Villages.CODEC_VILLAGES.fieldOf("villages").forGetter(ttConfig -> ttConfig.villages), (App)PillagerOutposts.CODEC_PILLAGER_OUTPOSTS.fieldOf("pillagerOutposts").forGetter(ttConfig -> ttConfig.pillagerOutposts), (App)Others.CODEC_OTHERS.fieldOf("others").forGetter(ttConfig -> ttConfig.others)).apply((Applicative)builder, TTConfig::new));
    public static final String HEADER_OPEN = "/*\nThis config file makes it possible to switch off any structure from Towns and Towers. Big thanks to Cristelknight for making this all possible.\nTo disable a structure, simply set the value of that structure to \"false\".\nTo change the rarity of a structure category, use the other file in the config.\n\nCurseforge link: https://www.curseforge.com/minecraft/mc-mods/towns-and-towers\nModrinth link: https://modrinth.com/mod/towns-and-towers\nPMC link: https://www.planetminecraft.com/data-pack/towns-amp-towers-structure-overhaul/\nGitHub Repository: [NEED TO MAKE ONE]\n";
    public static final String HEADER_CLOSED = "/*\nThis config file makes it possible to switch off any structure from Towns and Towers. Big thanks to Cristelknight for making this all possible.\nTo disable a structure, simply set the value of that structure to \"false\".\nTo change the rarity of a structure category, use the other file in the config.\n\nCurseforge link: https://www.curseforge.com/minecraft/mc-mods/towns-and-towers\nModrinth link: https://modrinth.com/mod/towns-and-towers\nPMC link: https://www.planetminecraft.com/data-pack/towns-amp-towers-structure-overhaul/\nGitHub Repository: [NEED TO MAKE ONE]\n*/";

    public static TTConfig getConfig() {
        return TTConfig.getConfig(false, false);
    }

    public static TTConfig getConfig(boolean serialize, boolean recreate) {
        if (INSTANCE == null || serialize || recreate) {
            Path path = CONFIG_PATH;
            if (!path.toFile().exists() || recreate) {
                TTConfig.createConfig(path);
            }
            INSTANCE = ConfigUtil.readConfig(path, CODEC, JanksonOps.INSTANCE);
        }
        return INSTANCE;
    }

    public static void setINSTANCE(TTConfig config) {
        INSTANCE = config;
    }

    private static void createConfig(Path path) {
        HashMap comments = (HashMap)Util.m_137469_(new HashMap(), map -> {
            map.put("pillagerOutposts", "Here you can find all outposts.");
            map.put("villages", "Here you can find all villages.");
            map.put("others", "Here you can find all structures that aren't villages or outposts.");
            map.put("villages.coldVillages", "Here you can find all villages which spawn in colder biomes.");
            map.put("villages.warmVillages", "Here you can find all villages which spawn in warmer biomes.");
            map.put("pillagerOutposts.coldOutposts", "Here you can find all pillager outposts which spawn in colder biomes.");
            map.put("pillagerOutposts.warmOutposts", "Here you can find all pillager outposts which spawn in warmer biomes.");
            map.put("pillagerOutposts.exclusiveOutposts", "Here you can find all pillager outposts which are exclusive to other worldgen mods (ex.: WWOO, Terralith, BoP, BYG, etc.).");
            map.put("villages.exclusiveVillages", "Here you can find all villages which are exclusive to other worldgen mods (ex.: WWOO, Terralith, BoP, BYG, etc.).");
        });
        if (INSTANCE == null) {
            INSTANCE = DEFAULT;
        }
        ConfigUtil.createConfig(path, CODEC, HEADER_CLOSED, comments, JanksonOps.INSTANCE, INSTANCE);
    }

    public static Map<String, Boolean> values() throws InvocationTargetException, IllegalAccessException {
        HashMap<String, Boolean> values = new HashMap<String, Boolean>();
        values.putAll(TTConfig.villageValues());
        values.putAll(TTConfig.pillagerOutpostValues());
        values.putAll(TTConfig.otherValues());
        return values;
    }

    public static Map<String, Boolean> villageValues() throws InvocationTargetException, IllegalAccessException {
        HashMap<String, Boolean> values = new HashMap<String, Boolean>();
        for (RecordComponent component : Villages.VillageCold.class.getRecordComponents()) {
            values.put(component.getName(), (Boolean)component.getAccessor().invoke((Object)INSTANCE.villages().coldVillages(), new Object[0]));
        }
        for (RecordComponent component : Villages.VillageWarm.class.getRecordComponents()) {
            values.put(component.getName(), (Boolean)component.getAccessor().invoke((Object)INSTANCE.villages().warmVillages(), new Object[0]));
        }
        for (RecordComponent component : Villages.VillageExclusive.class.getRecordComponents()) {
            values.put(component.getName(), (Boolean)component.getAccessor().invoke((Object)INSTANCE.villages().exclusiveVillages(), new Object[0]));
        }
        return values;
    }

    public static Map<String, Boolean> pillagerOutpostValues() throws InvocationTargetException, IllegalAccessException {
        HashMap<String, Boolean> values = new HashMap<String, Boolean>();
        for (RecordComponent component : PillagerOutposts.PillagerCold.class.getRecordComponents()) {
            values.put(component.getName(), (Boolean)component.getAccessor().invoke((Object)INSTANCE.pillagerOutposts().coldOutposts(), new Object[0]));
        }
        for (RecordComponent component : PillagerOutposts.PillagerWarm.class.getRecordComponents()) {
            values.put(component.getName(), (Boolean)component.getAccessor().invoke((Object)INSTANCE.pillagerOutposts().warmOutposts(), new Object[0]));
        }
        for (RecordComponent component : PillagerOutposts.PillagerExclusive.class.getRecordComponents()) {
            values.put(component.getName(), (Boolean)component.getAccessor().invoke((Object)INSTANCE.pillagerOutposts().exclusiveOutposts(), new Object[0]));
        }
        return values;
    }

    public static Map<String, Boolean> otherValues() throws InvocationTargetException, IllegalAccessException {
        HashMap<String, Boolean> values = new HashMap<String, Boolean>();
        for (RecordComponent component : Others.class.getRecordComponents()) {
            values.put(component.getName(), (Boolean)component.getAccessor().invoke((Object)INSTANCE.others(), new Object[0]));
        }
        return values;
    }
}

