/*
 * Decompiled with CFR 0.152.
 */
package com.iobaddons.iobaddons.item;

import com.GACMD.isleofberk.entity.base.dragon.ADragonBase;
import com.GACMD.isleofberk.registery.ModEntities;
import com.iobaddons.iobaddons.IoBAConfig;
import com.iobaddons.iobaddons.IoBARegistry;
import com.iobaddons.iobaddons.IoBAddons;
import com.iobaddons.iobaddons.item.capability.DragonWhistleCapability;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class DragonWhistleItem
extends Item {
    public DragonWhistleItem(Item.Properties itemPropertiesIn) {
        super(itemPropertiesIn);
    }

    public void m_7373_(ItemStack stackIn, @Nullable Level levelIn, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        DragonWhistleCapability.IDragonWhistle whistle = IoBAddons.getCapability(stackIn, IoBARegistry.DRAGON_WHISTLE_CAPABILITY);
        if (whistle != null) {
            tooltipComponents.add((Component)new TranslatableComponent("item.iobaddons.dragon_whistle.tooltip.command").m_130940_(ChatFormatting.BOLD).m_7220_((Component)new TranslatableComponent("item.iobaddons.dragon_whistle.tooltip." + whistle.getWhistleCommandString())));
            if (whistle.getWhistleSelector() >= 0 && whistle.getWhistleSelector() <= 1) {
                tooltipComponents.add((Component)new TranslatableComponent("item.iobaddons.dragon_whistle.tooltip.species").m_130940_(ChatFormatting.BOLD).m_7220_((Component)new TranslatableComponent("species.iobaddons." + whistle.getWhistleSelectorName()).m_130940_(ChatFormatting.RESET)));
            } else if (whistle.getWhistleSelector() == 2) {
                if (whistle.getWhistleSelectorName().equals("fury_family")) {
                    tooltipComponents.add((Component)new TranslatableComponent("item.iobaddons.dragon_whistle.tooltip.dragon").m_130940_(ChatFormatting.BOLD).m_7220_((Component)new TranslatableComponent("species.iobaddons.night_fury").m_7220_((Component)new TextComponent(", "))).m_7220_((Component)new TranslatableComponent("species.iobaddons.light_fury").m_7220_((Component)new TextComponent(", "))).m_7220_((Component)new TranslatableComponent("species.iobaddons.and")).m_130940_(ChatFormatting.RESET).m_7220_((Component)new TranslatableComponent("species.iobaddons.night_light")));
                }
            } else if (whistle.getWhistleSelector() == 3) {
                tooltipComponents.add((Component)new TranslatableComponent("item.iobaddons.dragon_whistle.tooltip.dragon").m_130940_(ChatFormatting.BOLD).m_7220_((Component)new TextComponent("\u00a7f\u00a7o" + whistle.getWhistleSelectorName())));
            }
            tooltipComponents.add((Component)new TranslatableComponent("item.iobaddons.dragon_whistle.tooltip.range").m_130940_(ChatFormatting.BOLD).m_7220_((Component)new TextComponent("\u00a7f" + IoBAConfig.WHISTLE_RANGE.get())));
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level levelIn, Player playerIn, InteractionHand handIn) {
        DragonWhistleCapability.IDragonWhistle whistle;
        ItemStack itemStack = playerIn.m_21120_(handIn);
        if (!levelIn.f_46443_ && (whistle = IoBAddons.getCapability(itemStack, IoBARegistry.DRAGON_WHISTLE_CAPABILITY)) != null) {
            if (whistle.getWhistleSelector() >= 0 && whistle.getWhistleSelector() <= 2) {
                playerIn.m_5661_((Component)new TranslatableComponent("message.iobaddons.dragon_whistle." + whistle.getWhistleCommandString() + "." + whistle.getWhistleSelectorName()), true);
            } else if (whistle.getWhistleSelector() == 3) {
                playerIn.m_5661_((Component)new TranslatableComponent("message.iobaddons.dragon_whistle.command").m_7220_((Component)new TextComponent(whistle.getWhistleSelectorName())).m_7220_((Component)new TranslatableComponent("message.iobaddons.dragon_whistle." + whistle.getWhistleCommandString())), true);
            }
            List nearbyDragons = levelIn.m_45976_(ADragonBase.class, playerIn.m_142469_().m_82377_((double)((Integer)IoBAConfig.WHISTLE_RANGE.get()).intValue(), (double)((Integer)IoBAConfig.WHISTLE_RANGE.get()).intValue(), (double)((Integer)IoBAConfig.WHISTLE_RANGE.get()).intValue()));
            for (ADragonBase dragon : nearbyDragons) {
                if (dragon.m_142480_() != playerIn) continue;
                DragonWhistleItem.commandDragon(dragon, whistle);
            }
            if (whistle.getWhistleCommand() == 2) {
                playerIn.f_19853_.m_6263_(null, playerIn.m_20185_(), playerIn.m_20186_(), playerIn.m_20189_(), SoundEvents.f_12169_, SoundSource.PLAYERS, 1.0f, 1.0f);
            } else if (whistle.getWhistleCommand() == 1) {
                playerIn.f_19853_.m_6263_(null, playerIn.m_20185_(), playerIn.m_20186_(), playerIn.m_20189_(), SoundEvents.f_12212_, SoundSource.PLAYERS, 1.0f, 1.0f);
            } else {
                playerIn.f_19853_.m_6263_(null, playerIn.m_20185_(), playerIn.m_20186_(), playerIn.m_20189_(), SoundEvents.f_12211_, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
            this.setWhistleCooldown(playerIn);
        }
        return InteractionResultHolder.m_19092_((Object)itemStack, (boolean)levelIn.m_5776_());
    }

    public static void cycleWhistleCommand(ItemStack stackIn, Player playerIn) {
        DragonWhistleCapability.IDragonWhistle whistleCap = IoBAddons.getCapability(stackIn, IoBARegistry.DRAGON_WHISTLE_CAPABILITY);
        if (whistleCap != null) {
            whistleCap.cycleWhistleCommand();
            playerIn.m_5661_((Component)new TranslatableComponent("message.iobaddons.dragon_whistle.command_set." + whistleCap.getWhistleCommandString()), true);
        }
    }

    private static boolean isValidDragon(ADragonBase dragonIn, DragonWhistleCapability.IDragonWhistle whistleCapIn) {
        switch (whistleCapIn.getWhistleSelector()) {
            case 0: {
                return true;
            }
            case 1: {
                return whistleCapIn.getWhistleSelectorName().equals(IoBAddons.getDragonTypeTranslation(dragonIn));
            }
            case 2: {
                if (!whistleCapIn.getWhistleSelectorName().equals("fury_family")) break;
                return DragonWhistleItem.isFuryFamily(dragonIn);
            }
            case 3: {
                return dragonIn.m_142081_().equals(whistleCapIn.getWhistleSelectorUUID());
            }
        }
        return false;
    }

    public static boolean isFuryFamily(ADragonBase dragonIn) {
        return dragonIn.m_6095_() == ModEntities.LIGHT_FURY.get() || dragonIn.m_6095_() == ModEntities.NIGHT_FURY.get() || dragonIn.m_6095_() == ModEntities.NIGHT_LIGHT.get();
    }

    private static void commandDragon(ADragonBase dragonIn, DragonWhistleCapability.IDragonWhistle whistleCapIn) {
        if (DragonWhistleItem.isValidDragon(dragonIn, whistleCapIn)) {
            dragonIn.setIsDragonSleeping(false);
            if (dragonIn.getSleepDisturbTicks() < 250) {
                dragonIn.setSleepDisturbTicks(250);
            }
            switch (whistleCapIn.getWhistleCommand()) {
                case 0: {
                    dragonIn.setIsDragonSitting(true);
                    break;
                }
                case 1: {
                    dragonIn.setIsDragonFollowing(true);
                    break;
                }
                case 2: {
                    dragonIn.setIsDragonWandering(true);
                }
            }
        }
    }

    public void setWhistleCooldown(Player playerIn) {
        if (this.shouldApplyWhistleCooldown()) {
            playerIn.m_36335_().m_41524_((Item)this, ((Integer)IoBAConfig.WHISTLE_COOLDOWN.get()).intValue());
        }
    }

    public boolean getWhistleCooldown(Player playerIn) {
        return playerIn.m_36335_().m_41519_((Item)this);
    }

    public boolean shouldApplyWhistleCooldown() {
        return (Integer)IoBAConfig.WHISTLE_COOLDOWN.get() > 0;
    }

    public CompoundTag getShareTag(ItemStack stackIn) {
        CompoundTag nbt = stackIn.m_41784_();
        DragonWhistleCapability.IDragonWhistle whistleCap = IoBAddons.getCapability(stackIn, IoBARegistry.DRAGON_WHISTLE_CAPABILITY);
        if (whistleCap != null) {
            nbt.m_128365_("WhistleData", (Tag)whistleCap.getWhistleData());
        }
        return nbt;
    }

    public void readShareTag(ItemStack stackIn, @Nullable CompoundTag nbtIn) {
        DragonWhistleCapability.IDragonWhistle whistleCap;
        super.readShareTag(stackIn, nbtIn);
        if (nbtIn != null && (whistleCap = IoBAddons.getCapability(stackIn, IoBARegistry.DRAGON_WHISTLE_CAPABILITY)) != null && nbtIn.m_128425_("WhistleData", 10)) {
            whistleCap.setWhistleData(nbtIn.m_128469_("WhistleData"));
        }
    }
}

