/*
 * Decompiled with CFR 0.152.
 */
package com.iobaddons.iobaddons;

import com.GACMD.isleofberk.registery.ModEntities;
import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.iobaddons.iobaddons.IoBASpawnDataPackage;
import com.iobaddons.iobaddons.IoBAddons;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;

public class IoBASpawning {
    public static String CONFIG_FILE = "iobaddons-spawns.json";
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static Map<ResourceLocation, IoBASpawnDataPackage[]> BIOME_SPAWN_SETS = ImmutableMap.of();

    public static void setupSpawnSettings() {
        BIOME_SPAWN_SETS = IoBASpawning.createBiomeMapFromJson(IoBASpawning.getOrCreateSpawnSettings());
    }

    private static JsonArray getOrCreateSpawnSettings() {
        JsonArray jsonArray = new JsonArray();
        File configDir = new File(IoBAddons.getConfigPath().toString());
        if (configDir.exists()) {
            File configFile = new File(configDir, CONFIG_FILE);
            if (!configFile.exists()) {
                try {
                    FileWriter writer = new FileWriter(configFile);
                    GSON.toJson((JsonElement)IoBASpawning.getDefaultSettings(), (Appendable)writer);
                    ((Writer)writer).flush();
                    ((Writer)writer).close();
                }
                catch (IOException e) {
                    IoBAddons.getLogger().error("Unable to write to spawns config file due to the following--");
                    IoBAddons.getLogger().error((Object)e);
                }
            }
            try {
                FileReader reader = null;
                try {
                    reader = new FileReader(configFile);
                    jsonArray = JsonParser.parseReader((Reader)reader).getAsJsonArray();
                }
                catch (FileNotFoundException e) {
                    IoBAddons.getLogger().warn("Couldn't find IoB Addons spawns config file!  Using defaults instead.");
                    e.printStackTrace();
                    IoBASpawning.getDefaultSettings();
                }
            }
            catch (Exception e) {
                IoBAddons.getLogger().error("Unable to load spawns config file due to the following--");
                IoBAddons.getLogger().error((Object)e);
                IoBAddons.getLogger().error("Using default settings instead.");
                jsonArray = IoBASpawning.getDefaultSettings();
            }
        } else {
            IoBAddons.getLogger().warn("Unable to find config directory!  Default spawn settings will be used.");
            jsonArray = IoBASpawning.getDefaultSettings();
        }
        return jsonArray;
    }

    public static JsonArray getDefaultSettings() {
        JsonArray jsonArray = new JsonArray();
        jsonArray.add((JsonElement)IoBASpawning.getSpawnSettingsObject("minecraft:badlands", new IoBASpawnDataPackage[]{new IoBASpawnDataPackage((EntityType)ModEntities.STINGER.get(), 2, 0, 2), new IoBASpawnDataPackage((EntityType)ModEntities.MONSTROUS_NIGHTMARE.get(), 1, 0, 1), new IoBASpawnDataPackage((EntityType)ModEntities.TRIPLE_STRYKE.get(), 1, 0, 2)}));
        jsonArray.add((JsonElement)IoBASpawning.getSpawnSettingsObject("minecraft:bamboo_jungle", new IoBASpawnDataPackage[]{new IoBASpawnDataPackage((EntityType)ModEntities.TERRIBLE_TERROR.get(), 4, 2, 4)}));
        jsonArray.add((JsonElement)IoBASpawning.getSpawnSettingsObject("minecraft:beach", new IoBASpawnDataPackage[]{new IoBASpawnDataPackage((EntityType)ModEntities.TERRIBLE_TERROR.get(), 1, 0, 3)}));
        jsonArray.add((JsonElement)IoBASpawning.getSpawnSettingsObject("minecraft:birch_forest", new IoBASpawnDataPackage[]{new IoBASpawnDataPackage((EntityType)ModEntities.DEADLY_NADDER.get(), 9, 1, 3), new IoBASpawnDataPackage((EntityType)ModEntities.LIGHT_FURY.get(), 3, 0, 1)}));
        jsonArray.add((JsonElement)IoBASpawning.getSpawnSettingsObject("minecraft:dark_forest", new IoBASpawnDataPackage[]{new IoBASpawnDataPackage((EntityType)ModEntities.TERRIBLE_TERROR.get(), 4, 2, 4)}));
        jsonArray.add((JsonElement)IoBASpawning.getSpawnSettingsObject("minecraft:eroded_badlands", new IoBASpawnDataPackage[]{new IoBASpawnDataPackage((EntityType)ModEntities.STINGER.get(), 2, 0, 2), new IoBASpawnDataPackage((EntityType)ModEntities.MONSTROUS_NIGHTMARE.get(), 1, 0, 1)}));
        jsonArray.add((JsonElement)IoBASpawning.getSpawnSettingsObject("minecraft:flower_forest", new IoBASpawnDataPackage[]{new IoBASpawnDataPackage((EntityType)ModEntities.DEADLY_NADDER.get(), 9, 1, 3)}));
        jsonArray.add((JsonElement)IoBASpawning.getSpawnSettingsObject("minecraft:forest", new IoBASpawnDataPackage[]{new IoBASpawnDataPackage((EntityType)ModEntities.DEADLY_NADDER.get(), 9, 1, 3)}));
        jsonArray.add((JsonElement)IoBASpawning.getSpawnSettingsObject("minecraft:frozen_peaks", new IoBASpawnDataPackage[]{new IoBASpawnDataPackage((EntityType)ModEntities.LIGHT_FURY.get(), 3, 0, 1), new IoBASpawnDataPackage((EntityType)ModEntities.NIGHT_FURY.get(), 2, 0, 1), new IoBASpawnDataPackage((EntityType)ModEntities.SKRILL.get(), 5, 0, 1)}));
        jsonArray.add((JsonElement)IoBASpawning.getSpawnSettingsObject("minecraft:grove", new IoBASpawnDataPackage[]{new IoBASpawnDataPackage((EntityType)ModEntities.DEADLY_NADDER.get(), 9, 1, 3), new IoBASpawnDataPackage((EntityType)ModEntities.GRONCKLE.get(), 6, 1, 2)}));
        jsonArray.add((JsonElement)IoBASpawning.getSpawnSettingsObject("minecraft:ice_spikes", new IoBASpawnDataPackage[]{new IoBASpawnDataPackage((EntityType)ModEntities.ZIPPLEBACK.get(), 1, 0, 1)}));
        jsonArray.add((JsonElement)IoBASpawning.getSpawnSettingsObject("minecraft:jagged_peaks", new IoBASpawnDataPackage[]{new IoBASpawnDataPackage((EntityType)ModEntities.LIGHT_FURY.get(), 3, 0, 1), new IoBASpawnDataPackage((EntityType)ModEntities.NIGHT_FURY.get(), 2, 0, 1), new IoBASpawnDataPackage((EntityType)ModEntities.SKRILL.get(), 5, 0, 1)}));
        jsonArray.add((JsonElement)IoBASpawning.getSpawnSettingsObject("minecraft:jungle", new IoBASpawnDataPackage[]{new IoBASpawnDataPackage((EntityType)ModEntities.TERRIBLE_TERROR.get(), 4, 2, 4)}));
        jsonArray.add((JsonElement)IoBASpawning.getSpawnSettingsObject("minecraft:meadow", new IoBASpawnDataPackage[]{new IoBASpawnDataPackage((EntityType)ModEntities.DEADLY_NADDER.get(), 2, 2, 3), new IoBASpawnDataPackage((EntityType)ModEntities.GRONCKLE.get(), 2, 1, 2)}));
        jsonArray.add((JsonElement)IoBASpawning.getSpawnSettingsObject("minecraft:old_growth_birch_forest", new IoBASpawnDataPackage[]{new IoBASpawnDataPackage((EntityType)ModEntities.DEADLY_NADDER.get(), 9, 1, 3), new IoBASpawnDataPackage((EntityType)ModEntities.GRONCKLE.get(), 5, 2, 3), new IoBASpawnDataPackage((EntityType)ModEntities.LIGHT_FURY.get(), 3, 0, 1)}));
        jsonArray.add((JsonElement)IoBASpawning.getSpawnSettingsObject("minecraft:old_growth_pine_taiga", new IoBASpawnDataPackage[]{new IoBASpawnDataPackage((EntityType)ModEntities.TRIPLE_STRYKE.get(), 5, 1, 3)}));
        jsonArray.add((JsonElement)IoBASpawning.getSpawnSettingsObject("minecraft:old_growth_spruce_taiga", new IoBASpawnDataPackage[]{new IoBASpawnDataPackage((EntityType)ModEntities.TRIPLE_STRYKE.get(), 5, 1, 3)}));
        jsonArray.add((JsonElement)IoBASpawning.getSpawnSettingsObject("minecraft:plains", new IoBASpawnDataPackage[]{new IoBASpawnDataPackage((EntityType)ModEntities.GRONCKLE.get(), 6, 1, 2)}));
        jsonArray.add((JsonElement)IoBASpawning.getSpawnSettingsObject("minecraft:river", new IoBASpawnDataPackage[]{new IoBASpawnDataPackage((EntityType)ModEntities.TERRIBLE_TERROR.get(), 1, 0, 3)}));
        jsonArray.add((JsonElement)IoBASpawning.getSpawnSettingsObject("minecraft:savanna", new IoBASpawnDataPackage[]{new IoBASpawnDataPackage((EntityType)ModEntities.STINGER.get(), 10, 2, 4), new IoBASpawnDataPackage((EntityType)ModEntities.DEADLY_NADDER.get(), 6, 2, 3), new IoBASpawnDataPackage((EntityType)ModEntities.GRONCKLE.get(), 6, 1, 2)}));
        jsonArray.add((JsonElement)IoBASpawning.getSpawnSettingsObject("minecraft:savanna_plateau", new IoBASpawnDataPackage[]{new IoBASpawnDataPackage((EntityType)ModEntities.STINGER.get(), 10, 2, 4), new IoBASpawnDataPackage((EntityType)ModEntities.DEADLY_NADDER.get(), 6, 2, 3), new IoBASpawnDataPackage((EntityType)ModEntities.GRONCKLE.get(), 5, 2, 3)}));
        jsonArray.add((JsonElement)IoBASpawning.getSpawnSettingsObject("minecraft:snowy_plains", new IoBASpawnDataPackage[]{new IoBASpawnDataPackage((EntityType)ModEntities.DEADLY_NADDER.get(), 2, 2, 3), new IoBASpawnDataPackage((EntityType)ModEntities.GRONCKLE.get(), 2, 1, 2), new IoBASpawnDataPackage((EntityType)ModEntities.ZIPPLEBACK.get(), 1, 0, 1)}));
        jsonArray.add((JsonElement)IoBASpawning.getSpawnSettingsObject("minecraft:snowy_slopes", new IoBASpawnDataPackage[]{new IoBASpawnDataPackage((EntityType)ModEntities.NIGHT_FURY.get(), 2, 0, 1), new IoBASpawnDataPackage((EntityType)ModEntities.SKRILL.get(), 5, 0, 1)}));
        jsonArray.add((JsonElement)IoBASpawning.getSpawnSettingsObject("minecraft:snowy_taiga", new IoBASpawnDataPackage[]{new IoBASpawnDataPackage((EntityType)ModEntities.TRIPLE_STRYKE.get(), 5, 1, 3)}));
        jsonArray.add((JsonElement)IoBASpawning.getSpawnSettingsObject("minecraft:sparse_jungle", new IoBASpawnDataPackage[]{new IoBASpawnDataPackage((EntityType)ModEntities.DEADLY_NADDER.get(), 6, 2, 3), new IoBASpawnDataPackage((EntityType)ModEntities.ZIPPLEBACK.get(), 6, 2, 3)}));
        jsonArray.add((JsonElement)IoBASpawning.getSpawnSettingsObject("minecraft:stony_peaks", new IoBASpawnDataPackage[]{new IoBASpawnDataPackage((EntityType)ModEntities.NIGHT_FURY.get(), 2, 0, 1), new IoBASpawnDataPackage((EntityType)ModEntities.SKRILL.get(), 5, 0, 1)}));
        jsonArray.add((JsonElement)IoBASpawning.getSpawnSettingsObject("minecraft:stony_shores", new IoBASpawnDataPackage[]{new IoBASpawnDataPackage((EntityType)ModEntities.TERRIBLE_TERROR.get(), 1, 0, 3)}));
        jsonArray.add((JsonElement)IoBASpawning.getSpawnSettingsObject("minecraft:sunflower_plains", new IoBASpawnDataPackage[]{new IoBASpawnDataPackage((EntityType)ModEntities.STINGER.get(), 10, 2, 4), new IoBASpawnDataPackage((EntityType)ModEntities.GRONCKLE.get(), 6, 1, 2)}));
        jsonArray.add((JsonElement)IoBASpawning.getSpawnSettingsObject("minecraft:swamp", new IoBASpawnDataPackage[]{new IoBASpawnDataPackage((EntityType)ModEntities.GRONCKLE.get(), 2, 1, 2), new IoBASpawnDataPackage((EntityType)ModEntities.ZIPPLEBACK.get(), 1, 0, 1)}));
        jsonArray.add((JsonElement)IoBASpawning.getSpawnSettingsObject("minecraft:taiga", new IoBASpawnDataPackage[]{new IoBASpawnDataPackage((EntityType)ModEntities.TRIPLE_STRYKE.get(), 5, 1, 3)}));
        jsonArray.add((JsonElement)IoBASpawning.getSpawnSettingsObject("minecraft:windswept_forest", new IoBASpawnDataPackage[]{new IoBASpawnDataPackage((EntityType)ModEntities.DEADLY_NADDER.get(), 4, 2, 3), new IoBASpawnDataPackage((EntityType)ModEntities.LIGHT_FURY.get(), 3, 0, 1), new IoBASpawnDataPackage((EntityType)ModEntities.NIGHT_FURY.get(), 2, 0, 1), new IoBASpawnDataPackage((EntityType)ModEntities.MONSTROUS_NIGHTMARE.get(), 1, 0, 1)}));
        jsonArray.add((JsonElement)IoBASpawning.getSpawnSettingsObject("minecraft:windswept_gravelly_hills", new IoBASpawnDataPackage[]{new IoBASpawnDataPackage((EntityType)ModEntities.DEADLY_NADDER.get(), 4, 2, 3), new IoBASpawnDataPackage((EntityType)ModEntities.NIGHT_FURY.get(), 2, 0, 1), new IoBASpawnDataPackage((EntityType)ModEntities.MONSTROUS_NIGHTMARE.get(), 1, 0, 1)}));
        jsonArray.add((JsonElement)IoBASpawning.getSpawnSettingsObject("minecraft:windswept_hills", new IoBASpawnDataPackage[]{new IoBASpawnDataPackage((EntityType)ModEntities.DEADLY_NADDER.get(), 4, 2, 3), new IoBASpawnDataPackage((EntityType)ModEntities.MONSTROUS_NIGHTMARE.get(), 1, 0, 1)}));
        jsonArray.add((JsonElement)IoBASpawning.getSpawnSettingsObject("minecraft:windswept_savanna", new IoBASpawnDataPackage[]{new IoBASpawnDataPackage((EntityType)ModEntities.DEADLY_NADDER.get(), 9, 1, 3), new IoBASpawnDataPackage((EntityType)ModEntities.GRONCKLE.get(), 5, 2, 3)}));
        jsonArray.add((JsonElement)IoBASpawning.getSpawnSettingsObject("minecraft:wooded_badlands", new IoBASpawnDataPackage[]{new IoBASpawnDataPackage((EntityType)ModEntities.STINGER.get(), 2, 0, 2), new IoBASpawnDataPackage((EntityType)ModEntities.MONSTROUS_NIGHTMARE.get(), 1, 0, 1), new IoBASpawnDataPackage((EntityType)ModEntities.TRIPLE_STRYKE.get(), 1, 0, 2)}));
        return jsonArray;
    }

    private static JsonObject getSpawnSettingsObject(String biomeNameIn, IoBASpawnDataPackage[] spawnPackagesIn) {
        JsonObject jsonObj = new JsonObject();
        if (spawnPackagesIn.length > 0) {
            jsonObj.addProperty("biome", biomeNameIn);
            jsonObj.add("spawns", (JsonElement)IoBASpawning.getBiomeSpawnSetAsJson(spawnPackagesIn));
        }
        return jsonObj;
    }

    private static Map<ResourceLocation, IoBASpawnDataPackage[]> createBiomeMapFromJson(JsonArray biomeSetsIn) {
        ImmutableMap.Builder builderSettings = ImmutableMap.builder();
        for (JsonElement e : biomeSetsIn) {
            if (!e.isJsonObject() || !e.getAsJsonObject().has("biome") || !e.getAsJsonObject().has("spawns")) continue;
            String name = e.getAsJsonObject().get("biome").getAsString();
            IoBAddons.getLogger().debug("Loading spawns for biome " + name + "...");
            JsonArray spawns = e.getAsJsonObject().get("spawns").getAsJsonArray();
            if (spawns.isEmpty()) continue;
            builderSettings.put((Object)new ResourceLocation(name), (Object)IoBASpawning.getBiomeSpawnSetFromJson(spawns));
        }
        return builderSettings.build();
    }

    private static IoBASpawnDataPackage[] getBiomeSpawnSetFromJson(JsonArray biomeSpawnSetIn) {
        IoBASpawnDataPackage[] biomeSpawnPackages = new IoBASpawnDataPackage[]{};
        if (!biomeSpawnSetIn.isEmpty()) {
            ArrayList<IoBASpawnDataPackage> biomeSpawns = new ArrayList<IoBASpawnDataPackage>();
            for (JsonElement e : biomeSpawnSetIn) {
                IoBASpawnDataPackage spawnSet = new IoBASpawnDataPackage(e.getAsJsonObject());
                if (!spawnSet.isValidSpawnPackage()) continue;
                biomeSpawns.add(spawnSet);
            }
            if (!biomeSpawns.isEmpty()) {
                biomeSpawnPackages = (IoBASpawnDataPackage[])biomeSpawns.stream().toArray(IoBASpawnDataPackage[]::new);
            }
        }
        return biomeSpawnPackages;
    }

    private static JsonArray getBiomeSpawnSetAsJson(IoBASpawnDataPackage[] biomeSpawnSetIn) {
        JsonArray jsonArray = new JsonArray();
        if (biomeSpawnSetIn.length > 0) {
            for (IoBASpawnDataPackage i : biomeSpawnSetIn) {
                if (i == null || !i.isValidSpawnPackage()) continue;
                jsonArray.add((JsonElement)i.convertToJSON());
            }
        }
        return jsonArray;
    }
}

