/*
 * Decompiled with CFR 0.152.
 */
package com.iobaddons.iobaddons;

import com.GACMD.isleofberk.registery.ModEntities;
import com.google.gson.JsonObject;
import com.iobaddons.iobaddons.IoBAddons;
import net.minecraft.world.entity.EntityType;

public class IoBASpawnDataPackage {
    private static String DRAGON_TYPE = "dragonType";
    private static String SPAWN_WEIGHT = "spawnWeight";
    private static String PACK_MIN = "minPackSize";
    private static String PACK_MAX = "maxPackSize";
    private static EntityType<?>[] DRAGON_TYPES = new EntityType[]{(EntityType)ModEntities.GRONCKLE.get(), (EntityType)ModEntities.LIGHT_FURY.get(), (EntityType)ModEntities.DEADLY_NADDER.get(), (EntityType)ModEntities.MONSTROUS_NIGHTMARE.get(), (EntityType)ModEntities.NIGHT_FURY.get(), (EntityType)ModEntities.NIGHT_LIGHT.get(), (EntityType)ModEntities.SKRILL.get(), (EntityType)ModEntities.SPEED_STINGER.get(), (EntityType)ModEntities.STINGER.get(), (EntityType)ModEntities.TERRIBLE_TERROR.get(), (EntityType)ModEntities.TRIPLE_STRYKE.get(), (EntityType)ModEntities.ZIPPLEBACK.get()};
    private final EntityType<?> dragonType;
    private final int weight;
    private final int spawnMin;
    private final int spawnMax;

    public IoBASpawnDataPackage(EntityType<?> dragonTypeIn, int weightIn, int spawnMinIn, int spawnMaxIn) {
        if (this.isValidDragon(dragonTypeIn)) {
            this.dragonType = dragonTypeIn;
        } else {
            IoBAddons.getLogger().warn("Received a non-dragon entity type in the creation of a new spawn data package, invalidating...");
            this.dragonType = null;
        }
        this.weight = weightIn;
        this.spawnMin = spawnMinIn;
        this.spawnMax = Math.max(this.spawnMin, spawnMaxIn);
    }

    public IoBASpawnDataPackage(JsonObject jsonObjIn) {
        this.weight = jsonObjIn.has(SPAWN_WEIGHT) ? Math.max(0, jsonObjIn.get(SPAWN_WEIGHT).getAsInt()) : -1;
        this.spawnMin = jsonObjIn.has(PACK_MIN) ? Math.max(0, jsonObjIn.get(PACK_MIN).getAsInt()) : -1;
        int n = this.spawnMax = jsonObjIn.has(PACK_MAX) ? Math.max(this.spawnMin, jsonObjIn.get(PACK_MAX).getAsInt()) : -1;
        if (jsonObjIn.has(DRAGON_TYPE) && this.weight > 0 && this.spawnMin > -1 && this.spawnMax > 0) {
            boolean foundDragonType = false;
            int i = 0;
            while (!foundDragonType && i < DRAGON_TYPES.length) {
                if (jsonObjIn.get(DRAGON_TYPE).getAsString().equals(DRAGON_TYPES[i].getRegistryName().toString())) {
                    foundDragonType = true;
                    continue;
                }
                ++i;
            }
            this.dragonType = foundDragonType ? DRAGON_TYPES[i] : null;
        } else {
            this.dragonType = null;
        }
        IoBAddons.getLogger().info("Loaded spawn set for dragon " + this.getDragonType().getRegistryName() + " with weight of " + this.weight + ", minimum pack size of " + this.spawnMin + ", and maximum pack size of " + this.spawnMax);
    }

    public EntityType<?> getDragonType() {
        return this.dragonType;
    }

    public int getWeight() {
        return this.weight;
    }

    public int getSpawnMin() {
        return this.spawnMin;
    }

    public int getSpawnMax() {
        return this.spawnMax;
    }

    public JsonObject convertToJSON() {
        JsonObject jsonObj = new JsonObject();
        if (this.isValidSpawnPackage()) {
            jsonObj.addProperty(DRAGON_TYPE, this.dragonType.getRegistryName().toString());
            jsonObj.addProperty(SPAWN_WEIGHT, (Number)this.weight);
            jsonObj.addProperty(PACK_MIN, (Number)this.spawnMin);
            jsonObj.addProperty(PACK_MAX, (Number)this.spawnMax);
        }
        return jsonObj;
    }

    private boolean isValidDragon(EntityType<?> entityTypeIn) {
        boolean isValid = false;
        for (int i = 0; !isValid && i < DRAGON_TYPES.length; ++i) {
            if (DRAGON_TYPES[i] != entityTypeIn) continue;
            isValid = true;
        }
        return isValid;
    }

    public boolean isValidSpawnPackage() {
        return this.dragonType != null && this.weight > 0 && this.spawnMax > 0;
    }
}

