/*
 * Decompiled with CFR 0.152.
 */
package com.iobaddons.iobaddons;

import com.iobaddons.iobaddons.IoBASpawning;
import net.minecraftforge.common.ForgeConfigSpec;

public class IoBAConfig {
    public static ForgeConfigSpec COMMON_CONFIG;
    public static final String CATEGORY_GENERAL = "general_settings";
    public static ForgeConfigSpec.BooleanValue ADVANCED_DEBUG;
    public static ForgeConfigSpec.BooleanValue PREVENT_SHOCK_EFFECT;
    public static final String CATEGORY_ITEMS = "item_settings";
    public static final String CATEGORY_WHISTLE = "dragon_whistle";
    public static ForgeConfigSpec.IntValue WHISTLE_RANGE;
    public static ForgeConfigSpec.BooleanValue ALLOW_SPECIES_SELECT;
    public static ForgeConfigSpec.BooleanValue ALLOW_FAMILY_SELECT;
    public static ForgeConfigSpec.BooleanValue ALLOW_INDIVIDUAL_SELECT;
    public static ForgeConfigSpec.IntValue WHISTLE_COOLDOWN;
    public static final String CATEGORY_CAGE = "dragon_cage";
    public static ForgeConfigSpec.BooleanValue CREATIVE_CAGE_OVERRIDE;
    public static ForgeConfigSpec.BooleanValue ALLOW_CAGE_UNTAMED;
    public static ForgeConfigSpec.BooleanValue ALLOW_CAGE_INVENTORY;
    public static ForgeConfigSpec.BooleanValue ALLOW_RELEASE_NOT_YOURS;
    public static ForgeConfigSpec.IntValue CAGE_HEAL_TICK;
    public static ForgeConfigSpec.IntValue CAGE_COOLDOWN;
    public static final String CATEGORY_DRAGONS = "dragon_settings";
    public static ForgeConfigSpec.BooleanValue PREVENT_DRAGON_FRIENDLY_FIRE;
    public static final String CATEGORY_GRONCKLE = "gronckle_settings";
    public static ForgeConfigSpec.BooleanValue ALLOW_GRONCKLE_CAPTURE;
    public static final String CATEGORY_LIGHT_FURY = "light_fury_settings";
    public static ForgeConfigSpec.BooleanValue ALLOW_LIGHT_FURY_CAPTURE;
    public static final String CATEGORY_NADDER = "deadly_nadder_settings";
    public static ForgeConfigSpec.BooleanValue ALLOW_NADDER_CAPTURE;
    public static final String CATEGORY_NIGHTMARE = "monstrous_nightmare_settings";
    public static ForgeConfigSpec.BooleanValue ALLOW_NIGHTMARE_CAPTURE;
    public static final String CATEGORY_NIGHT_FURY = "night_fury_settings";
    public static ForgeConfigSpec.BooleanValue ALLOW_NIGHT_FURY_CAPTURE;
    public static final String CATEGORY_NIGHT_LIGHT = "night_light_settings";
    public static ForgeConfigSpec.BooleanValue ALLOW_NIGHT_LIGHT_CAPTURE;
    public static final String CATEGORY_SKRILL = "skrill_settings";
    public static ForgeConfigSpec.BooleanValue ALLOW_SKRILL_CAPTURE;
    public static ForgeConfigSpec.BooleanValue SKRILL_LIGHTNING_IMMUNE;
    public static final String CATEGORY_SPEED_STINGER = "speed_stinger_settings";
    public static ForgeConfigSpec.BooleanValue ALLOW_SPEED_STINGER_CAPTURE;
    public static final String CATEGORY_STINGER = "stinger_settings";
    public static ForgeConfigSpec.BooleanValue ALLOW_STINGER_CAPTURE;
    public static final String CATEGORY_TERROR = "terrible_terror_settings";
    public static ForgeConfigSpec.BooleanValue ALLOW_TERROR_CAPTURE;
    public static final String CATEGORY_TRIPLE_STRYKE = "triple_stryke_settings";
    public static ForgeConfigSpec.BooleanValue ALLOW_TRIPLE_STRYKE_CAPTURE;
    public static final String CATEGORY_ZIPPLEBACK = "hideous_zippleback_settings";
    public static ForgeConfigSpec.BooleanValue ALLOW_ZIPPLEBACK_CAPTURE;
    public static final String CATEGORY_SPAWNS = "spawns";
    public static ForgeConfigSpec.BooleanValue USE_IOBA_SPAWNS;

    private static String allowDragonCaptureMessage(String dragonName) {
        return "Allows " + dragonName + " to be carried in a dragon cage.  When this setting is enabled, other restrictions may still apply.  Disabling it will ALWAYS prevent " + dragonName + " from being picked up.";
    }

    static {
        ForgeConfigSpec.Builder COMMON_BUILDER = new ForgeConfigSpec.Builder();
        COMMON_BUILDER.comment("General Settings").push(CATEGORY_GENERAL);
        ADVANCED_DEBUG = COMMON_BUILDER.comment("Enables additional debug logging.  THIS SETTING MAY CAUSE LAG!  Please only enable it if you are troubleshooting or reporting an issue.").define("advanced_debugging", false);
        PREVENT_SHOCK_EFFECT = COMMON_BUILDER.comment("Prevents the shock effect from being applied to ANY entity, effectively removing it from the game.").define("prevent_shock_effect", false);
        COMMON_BUILDER.pop();
        COMMON_BUILDER.push(CATEGORY_ITEMS);
        COMMON_BUILDER.comment("Dragon Whistle Settings").push(CATEGORY_WHISTLE);
        WHISTLE_RANGE = COMMON_BUILDER.comment("Maximum range (in blocks) that dragons can hear the whistle from.  Higher values could cause lag when many entities are present.").defineInRange("whistle_range", 64, 1, 512);
        ALLOW_SPECIES_SELECT = COMMON_BUILDER.comment("Allows the whistle to select a specific dragon species to issue commands to.").define("allow_species_select", true);
        ALLOW_FAMILY_SELECT = COMMON_BUILDER.comment("Allows the whistle to select a specific dragon family to issue commands to (such as night furies, light furies, and night lights).").define("allow_family_select", true);
        ALLOW_INDIVIDUAL_SELECT = COMMON_BUILDER.comment("Allows the whistle to select a specific individual dragon to issue commands to.  Note that individual dragons must be named in order to select them.").define("allow_individual_select", true);
        WHISTLE_COOLDOWN = COMMON_BUILDER.comment(new String[]{"Cooldown time in ticks between whistle commands (per whistle).  Mostly used as a latency mitigation feature, to prevent command duplication.", "Setting this option to 0 disables the cooldown."}).defineInRange("whistle_cooldown", 5, 0, 60);
        COMMON_BUILDER.pop();
        COMMON_BUILDER.comment("Dragon Cage Settings").push(CATEGORY_CAGE);
        CREATIVE_CAGE_OVERRIDE = COMMON_BUILDER.comment("Allows creative mode players to bypass most restrictions for caging dragons, such as type, tame status, and owner restrictions.  Useful for server operators and for hecking around in singleplayer.").define("creative_cage_override", true);
        ALLOW_CAGE_UNTAMED = COMMON_BUILDER.comment("Allows players to cage untamed dragons with the dragon cage.  This can pose balance issues or allow for griefing, so enable at your own risk!").define("allow_cage_untamed", false);
        ALLOW_CAGE_INVENTORY = COMMON_BUILDER.comment("Allows players to cage dragons that have items in their inventory.  PLEASE NOTE, this will cause all items in the dragon's inventory (except for their saddle and the chest itself) to drop on the ground!  When disabled, dragons won't be able to be caged until all items are removed from their inventory.").define("allow_cage_inventory", false);
        ALLOW_RELEASE_NOT_YOURS = COMMON_BUILDER.comment("Allows players to release dragons from cages that don't belong to them.  This can pose balance issues or allow for griefing, so enable at your own risk!").define("allow_release_not_yours", false);
        CAGE_HEAL_TICK = COMMON_BUILDER.comment(new String[]{"How many seconds it takes for a caged dragon's health to increase by half a heart.  Note that passive healing ONLY occurs while the cage is being carried by a player.", "Setting this to 0 disables caged dragon healing."}).defineInRange("cage_heal_tick", 5, 0, 300);
        CAGE_COOLDOWN = COMMON_BUILDER.comment(new String[]{"Cooldown time in ticks between cage pickups/releases (per cage).  Mostly used as a latency mitigation feature, to prevent pickup/release duplication.", "Setting this option to 0 disables the cooldown."}).defineInRange("cage_cooldown", 5, 0, 60);
        COMMON_BUILDER.pop();
        COMMON_BUILDER.pop();
        COMMON_BUILDER.push(CATEGORY_DRAGONS);
        PREVENT_DRAGON_FRIENDLY_FIRE = COMMON_BUILDER.comment(new String[]{"Prevents dragons from directly damaging their owners, or their owners' other tames.", "Please note that this may not prevent ALL damage, such as that caused by walking into fire created by a dragon's fireball."}).define("prevent_dragon_friendly_fire", true);
        COMMON_BUILDER.push(CATEGORY_GRONCKLE);
        ALLOW_GRONCKLE_CAPTURE = COMMON_BUILDER.comment(IoBAConfig.allowDragonCaptureMessage("gronckles")).define("allow_gronckle_capture", true);
        COMMON_BUILDER.pop();
        COMMON_BUILDER.push(CATEGORY_LIGHT_FURY);
        ALLOW_LIGHT_FURY_CAPTURE = COMMON_BUILDER.comment(IoBAConfig.allowDragonCaptureMessage("light furies")).define("allow_light_fury_capture", true);
        COMMON_BUILDER.pop();
        COMMON_BUILDER.push(CATEGORY_NADDER);
        ALLOW_NADDER_CAPTURE = COMMON_BUILDER.comment(IoBAConfig.allowDragonCaptureMessage("deadly nadders")).define("allow_nadder_capture", true);
        COMMON_BUILDER.pop();
        COMMON_BUILDER.push(CATEGORY_NIGHTMARE);
        ALLOW_NIGHTMARE_CAPTURE = COMMON_BUILDER.comment(IoBAConfig.allowDragonCaptureMessage("monstrous nightmares")).define("allow_monstrous_nightmare_capture", true);
        COMMON_BUILDER.pop();
        COMMON_BUILDER.push(CATEGORY_NIGHT_FURY);
        ALLOW_NIGHT_FURY_CAPTURE = COMMON_BUILDER.comment(IoBAConfig.allowDragonCaptureMessage("night furies")).define("allow_night_fury_capture", true);
        COMMON_BUILDER.pop();
        COMMON_BUILDER.push(CATEGORY_NIGHT_LIGHT);
        ALLOW_NIGHT_LIGHT_CAPTURE = COMMON_BUILDER.comment(IoBAConfig.allowDragonCaptureMessage("night lights")).define("allow_night_light_capture", true);
        COMMON_BUILDER.pop();
        COMMON_BUILDER.push(CATEGORY_SKRILL);
        ALLOW_SKRILL_CAPTURE = COMMON_BUILDER.comment(IoBAConfig.allowDragonCaptureMessage("skrills")).define("allow_skrill_capture", true);
        SKRILL_LIGHTNING_IMMUNE = COMMON_BUILDER.comment(new String[]{"Prevents skrills from being damaged by lightning or acquiring the shock effect.", "Please note that enabling this option effectively prevents skrills from fighting each other!"}).define("skrill_lightning_immune", true);
        COMMON_BUILDER.pop();
        COMMON_BUILDER.push(CATEGORY_SPEED_STINGER);
        ALLOW_SPEED_STINGER_CAPTURE = COMMON_BUILDER.comment(IoBAConfig.allowDragonCaptureMessage("speed stingers")).define("allow_speed_stinger_capture", true);
        COMMON_BUILDER.pop();
        COMMON_BUILDER.push(CATEGORY_STINGER);
        ALLOW_STINGER_CAPTURE = COMMON_BUILDER.comment(IoBAConfig.allowDragonCaptureMessage("stingers")).define("allow_stinger_capture", true);
        COMMON_BUILDER.pop();
        COMMON_BUILDER.push(CATEGORY_TERROR);
        ALLOW_TERROR_CAPTURE = COMMON_BUILDER.comment(IoBAConfig.allowDragonCaptureMessage("terrible terrors")).define("allow_terror_capture", true);
        COMMON_BUILDER.pop();
        COMMON_BUILDER.push(CATEGORY_TRIPLE_STRYKE);
        ALLOW_TRIPLE_STRYKE_CAPTURE = COMMON_BUILDER.comment(IoBAConfig.allowDragonCaptureMessage("triple strykes")).define("allow_triple_stryke_capture", true);
        COMMON_BUILDER.pop();
        COMMON_BUILDER.push(CATEGORY_ZIPPLEBACK);
        ALLOW_ZIPPLEBACK_CAPTURE = COMMON_BUILDER.comment(IoBAConfig.allowDragonCaptureMessage("zipplebacks")).define("allow_zippleback_capture", true);
        COMMON_BUILDER.pop();
        COMMON_BUILDER.pop();
        COMMON_BUILDER.comment("Spawn Settings").push(CATEGORY_SPAWNS);
        USE_IOBA_SPAWNS = COMMON_BUILDER.comment(new String[]{"IMPORTANT: This alternative spawn system is designed to compensate for an issue in Isle of Berk that prevents dragons from spawning in modded biomes.  It does NOT prevent Isle of Berk from also spawning dragons as per its own settings.", "It is HIGHLY recommended that you use only one spawn system at a time, as using both may overspawn dragons.  If you are only running vanilla biomes (or Isle of Berk compatible biome mods like Terralith), either spawn system is viable.", "However, if you are using biome mods such as Oh the Biomes You'll Go or Biomes O'Plenty, it is recommended that you use IoB Addons' system and remove dragon spawn values from the Isle of Berk config, as IoB Addons allows dragons to spawn in modded biomes.", "Using both systems simultaneously won't actually break anything, but it may make it harder to adjust dragon rates to your liking due to having two sets of competing spawn values."}).define("use_ioba_spawns", false);
        COMMON_BUILDER.comment("For IoB Addons spawn rates and customizations, see the " + IoBASpawning.CONFIG_FILE + " file in your config folder.").push(CATEGORY_SPAWNS);
        COMMON_BUILDER.pop();
        COMMON_CONFIG = COMMON_BUILDER.build();
    }
}

